/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.template;

import java.util.HashMap;
import java.util.Map;
import org.apache.turbine.services.template.TurbineTemplate;
import org.apache.turbine.util.RunData;

public class TemplateInfo {
    public static final String NAVIGATION_TEMPLATE = "00navigation_template00";
    public static final String LAYOUT_TEMPLATE = "00layout_template00";
    public static final String SERVICE_NAME = "template_service";
    private RunData data = null;
    private Map<String, Object> tempStorage = null;

    public TemplateInfo(RunData data) {
        this.data = data;
        this.tempStorage = new HashMap<String, Object>(10);
    }

    public String getNavigationTemplate() {
        return this.getString(NAVIGATION_TEMPLATE);
    }

    public void setNavigationTemplate(String v) {
        this.setTemp(NAVIGATION_TEMPLATE, v);
    }

    public String getScreenTemplate() {
        return this.data.getParameters().getString("template", null);
    }

    public void setScreenTemplate(String v) {
        this.data.getParameters().setString("template", v);
        try {
            this.setLayoutTemplate(TurbineTemplate.getLayoutTemplateName(v));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLayoutTemplate() {
        String value = this.getString(LAYOUT_TEMPLATE);
        return value;
    }

    public void setLayoutTemplate(String v) {
        this.setTemp(LAYOUT_TEMPLATE, v);
    }

    public Object getTemplateContext(String name) {
        return this.getTemp(name);
    }

    public void setTemplateContext(String name, Object v) {
        this.setTemp(name, v);
    }

    public String getService() {
        return this.getString(SERVICE_NAME);
    }

    public void setService(String v) {
        this.setTemp(SERVICE_NAME, v);
    }

    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    public Object getTemp(String name, Object def) {
        try {
            Object val = this.tempStorage.get(name);
            return val != null ? val : def;
        }
        catch (Exception e) {
            return def;
        }
    }

    public void setTemp(String name, Object value) {
        this.tempStorage.put(name, value);
    }

    public String[] getStringArray(String name) {
        String[] value = null;
        Object object = this.getTemp(name, null);
        if (object != null) {
            value = (String[])object;
        }
        return value;
    }

    public String getString(String name) {
        String value = null;
        Object object = this.getTemp(name, null);
        if (object != null) {
            value = (String)object;
        }
        return value;
    }

    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    public Object[] getTempKeys() {
        return this.tempStorage.keySet().toArray();
    }
}

