/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class EHCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Disposable,
Initializable,
ThreadSafe {
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    private long cacheCheckFrequency;
    private String configFile;
    private static final String DEFAULT_CACHE_NAME = "fulcrum";
    private String cacheName;
    private Thread refreshing;
    private boolean continueThread;
    private CacheManager cacheManager;
    private Cache cache;

    public void configure(Configuration config) throws ConfigurationException {
        this.cacheCheckFrequency = config.getChild("cacheCheckFrequency").getValueAsLong(5000L);
        this.cacheName = config.getChild("cacheName").getValue(DEFAULT_CACHE_NAME);
        this.configFile = config.getChild("configurationFile").getValue(null);
    }

    public void initialize() throws Exception {
        if (this.configFile == null) {
            this.cacheManager = new CacheManager();
            this.cacheManager.addCache(this.cacheName);
        } else {
            this.cacheManager = new CacheManager(this.configFile);
        }
        this.cache = this.cacheManager.getCache(this.cacheName);
        this.continueThread = true;
        this.refreshing = new Thread(this);
        this.refreshing.setDaemon(true);
        this.refreshing.setName("EHCacheService Refreshing");
        this.refreshing.start();
        this.getLogger().debug("EHCacheService started!");
    }

    public void dispose() {
        this.continueThread = false;
        this.refreshing.interrupt();
        this.cacheManager.shutdown();
        this.cacheManager = null;
        this.cache = null;
        this.getLogger().debug("EHCacheService stopped!");
    }

    public void addObject(String id, CachedObject o) {
        Element cacheElement = new Element((Serializable)((Object)id), (Serializable)o);
        if (o instanceof RefreshableCachedObject) {
            cacheElement.setEternal(true);
        } else {
            cacheElement.setEternal(false);
            cacheElement.setTimeToLive((int)(o.getExpires() + 500L) / 1000);
        }
        cacheElement.setCreateTime();
        this.cache.put(cacheElement);
    }

    public void flushCache() {
        this.cache.removeAll();
    }

    public List getCachedObjects() {
        ArrayList<Object> values = new ArrayList<Object>();
        Iterator i = this.getKeys().iterator();
        while (i.hasNext()) {
            Element cachedElement = this.cache.get(i.next());
            if (cachedElement == null) continue;
            values.add(cachedElement.getObjectValue());
        }
        return values;
    }

    public int getCacheSize() throws IOException {
        return (int)this.cache.calculateInMemorySize();
    }

    public List getKeys() {
        return this.cache.getKeysWithExpiryCheck();
    }

    public int getNumberOfObjects() {
        return this.getKeys().size();
    }

    public CachedObject getObject(String id) throws ObjectExpiredException {
        RefreshableCachedObject rco;
        Element cachedElement = this.cache.get((Serializable)((Object)id));
        if (cachedElement == null) {
            throw new ObjectExpiredException();
        }
        CachedObject obj = (CachedObject)cachedElement.getObjectValue();
        if (obj.isStale()) {
            if (obj instanceof RefreshableCachedObject) {
                rco = (RefreshableCachedObject)obj;
                if (rco.isUntouched()) {
                    this.removeObject(id);
                    throw new ObjectExpiredException();
                }
                rco.refresh();
                if (rco.isStale()) {
                    this.removeObject(id);
                    throw new ObjectExpiredException();
                }
            } else {
                this.removeObject(id);
                throw new ObjectExpiredException();
            }
        }
        if (obj instanceof RefreshableCachedObject) {
            rco = (RefreshableCachedObject)obj;
            rco.touch();
        }
        return obj;
    }

    public void removeObject(String id) {
        this.cache.remove((Serializable)((Object)id));
    }

    public void run() {
        while (this.continueThread) {
            block6: {
                try {
                    Thread.sleep(this.cacheCheckFrequency);
                }
                catch (InterruptedException exc) {
                    if (this.continueThread) break block6;
                    return;
                }
            }
            Iterator i = this.getKeys().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Element cachedElement = this.cache.get((Serializable)((Object)key));
                if (cachedElement == null) {
                    this.cache.remove((Serializable)((Object)key));
                    continue;
                }
                Object o = cachedElement.getObjectValue();
                if (!(o instanceof RefreshableCachedObject)) continue;
                RefreshableCachedObject rco = (RefreshableCachedObject)o;
                if (rco.isUntouched()) {
                    this.cache.remove((Serializable)((Object)key));
                    continue;
                }
                if (!rco.isStale()) continue;
                rco.refresh();
            }
        }
    }
}

