/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics;

import com.codahale.metrics.CachedGauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.zaxxer.hikari.metrics.MetricsTracker;
import com.zaxxer.hikari.pool.BaseHikariPool;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.util.UtilityElf;
import java.util.concurrent.TimeUnit;

public final class CodaHaleMetricsTracker
extends MetricsTracker {
    private final Timer connectionObtainTimer;
    private final Histogram connectionUsage;
    private final MetricRegistry registry;

    public CodaHaleMetricsTracker(final BaseHikariPool pool, MetricRegistry registry) {
        super(pool);
        this.registry = registry;
        this.connectionObtainTimer = registry.timer(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "Wait"}));
        this.connectionUsage = registry.histogram(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "Usage"}));
        registry.register(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "TotalConnections"}), (Metric)new CachedGauge<Integer>(10L, TimeUnit.SECONDS){

            protected Integer loadValue() {
                return pool.getTotalConnections();
            }
        });
        registry.register(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "IdleConnections"}), (Metric)new CachedGauge<Integer>(10L, TimeUnit.SECONDS){

            protected Integer loadValue() {
                return pool.getIdleConnections();
            }
        });
        registry.register(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "ActiveConnections"}), (Metric)new CachedGauge<Integer>(10L, TimeUnit.SECONDS){

            protected Integer loadValue() {
                return pool.getActiveConnections();
            }
        });
        registry.register(MetricRegistry.name((String)pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "PendingConnections"}), (Metric)new CachedGauge<Integer>(10L, TimeUnit.SECONDS){

            protected Integer loadValue() {
                return pool.getThreadsAwaitingConnection();
            }
        });
    }

    @Override
    public void close() {
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "Wait"}));
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "Usage"}));
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "TotalConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "IdleConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "ActiveConnections"}));
        this.registry.remove(MetricRegistry.name((String)this.pool.getConfiguration().getPoolName(), (String[])new String[]{"pool", "PendingConnections"}));
    }

    @Override
    public Context recordConnectionRequest(long requestTime) {
        return new Context(this.connectionObtainTimer);
    }

    @Override
    public void recordConnectionUsage(PoolBagEntry bagEntry) {
        this.connectionUsage.update(UtilityElf.elapsedTimeMs(bagEntry.lastOpenTime));
    }

    public Timer getConnectionAcquisitionTimer() {
        return this.connectionObtainTimer;
    }

    public Histogram getConnectionDurationHistogram() {
        return this.connectionUsage;
    }

    public static final class Context
    extends MetricsTracker.MetricsContext {
        final Timer.Context innerContext;

        Context(Timer timer) {
            this.innerContext = timer.time();
        }

        @Override
        public void stop() {
            this.innerContext.stop();
        }

        @Override
        public void setConnectionLastOpen(PoolBagEntry bagEntry, long now) {
            bagEntry.lastOpenTime = now;
        }
    }
}

