package org.apache.turbine.services.schedule;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.CriteriaInterface;
import org.apache.torque.om.mapper.RecordMapper;


/**
 * Maps ResultSet rows into JobEntryTorque objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Tue May 28 10:27:13 CEST 2019]
 *
 */
public class BaseJobEntryTorqueRecordMapper implements RecordMapper<JobEntryTorque>
{

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseJobEntryTorqueRecordMapper.class);

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the TURBINE_SCHEDULED_JOB table.
     */
    public JobEntryTorque processRow(
                ResultSet resultSet,
                int offset,
                CriteriaInterface<?> criteria)
            throws TorqueException
    {
        JobEntryTorque jobEntryTorque = new JobEntryTorque();

        try 
        {
            jobEntryTorque.setLoading(true);
            if (criteria == null)
            {
                jobEntryTorque.setJobId(
                        getJobId(resultSet, offset + 1));
                jobEntryTorque.setSecond(
                        getSecond(resultSet, offset + 2));
                jobEntryTorque.setMinute(
                        getMinute(resultSet, offset + 3));
                jobEntryTorque.setHour(
                        getHour(resultSet, offset + 4));
                jobEntryTorque.setWeekDay(
                        getWeekDay(resultSet, offset + 5));
                jobEntryTorque.setDayOfMonth(
                        getDayOfMonth(resultSet, offset + 6));
                jobEntryTorque.setTask(
                        getTask(resultSet, offset + 7));
                jobEntryTorque.setEmail(
                        getEmail(resultSet, offset + 8));
                jobEntryTorque.setProperty(
                        getProperty(resultSet, offset + 9));
            }
            else
            {
                // try to get columns to be mapped
                // from criteria's select columns
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                for (Column column : columnsWithoutOffset)
                {
                    if (BaseJobEntryTorquePeer.JOB_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setJobId(
                            getJobId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.SECOND.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setSecond(
                            getSecond(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.MINUTE.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setMinute(
                            getMinute(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.HOUR.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setHour(
                            getHour(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.WEEK_DAY.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setWeekDay(
                            getWeekDay(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.DAY_OF_MONTH.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setDayOfMonth(
                            getDayOfMonth(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.TASK.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setTask(
                            getTask(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.EMAIL.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setEmail(
                            getEmail(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseJobEntryTorquePeer.PROPERTY.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        jobEntryTorque.setProperty(
                            getProperty(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    totalOffset++;
                }
                if (!columnMapped)
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
            }
            jobEntryTorque.setNew(false);
            jobEntryTorque.setModified(false);
        }
        finally
        {
            jobEntryTorque.setLoading(false);
        }
        return jobEntryTorque;
    }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field jobId in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getJobId(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field second in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getSecond(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field minute in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getMinute(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field hour in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getHour(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field weekDay in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getWeekDay(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field dayOfMonth in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected int getDayOfMonth(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getInt(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field task in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected String getTask(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getString(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field email in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected String getEmail(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                return resultSet.getString(columnIndex);
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }

        /**
         * Reads the value of the <code>columnIndex</code>'th column
         * in the <code>resultSet</code> so that it can be used to set
         * the field property in JobEntryTorque.
         *
         * @param dbObject the database object to fill, not null.
         * @param resultSet the ResultSet to read from, not null.
         * @param columnIndex the index in the resultSet which should be read.
         *
         * @return the content of the column.
         *
         * @throws SQLException if a problem occurs when reading
         *         from the resultSet.
         */
        protected byte[] getProperty(
                    ResultSet resultSet,
                    int columnIndex)
                throws TorqueException
        {
            try
            {
                byte[] value = resultSet.getBytes(columnIndex);
                if (resultSet.wasNull())
                {
                    value = null;
                }
                return value;
            }
            catch (SQLException e)
            {
                throw new TorqueException(e);
            }
        }


}
