/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.mysql.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;

public class ScheduleParser {
    public static Date[] createDatesForSchedule(String schedule) throws ParseException {
        if (schedule == null) {
            throw new ParseException("Cannot create schedules for a null String.", 0);
        }
        StringTokenizer toker = new StringTokenizer(schedule, ",");
        Date[] dates = new Date[toker.countTokens()];
        int cnt = 0;
        while (toker.hasMoreTokens()) {
            String time = toker.nextToken();
            dates[cnt] = ScheduleParser.getDateForSchedule(time);
            ++cnt;
        }
        return dates;
    }

    public static Date getDateForSchedule(String startTime) throws ParseException {
        if (startTime == null) {
            throw new ParseException("Cannot create date for a null String.", 0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        Date date = sdf.parse(startTime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Calendar now = Calendar.getInstance();
        cal.set(now.get(1), now.get(2), now.get(5));
        if (cal.before(now)) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }
}

