/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerData {
    private String serverName = null;
    private int serverPort = 0;
    private String serverScheme = null;
    private String scriptName = null;
    private String contextPath = null;
    private static final Logger log = LogManager.getLogger(ServerData.class);

    public ServerData(String serverName, int serverPort, String serverScheme, String scriptName, String contextPath) {
        if (log.isDebugEnabled()) {
            log.debug("Constructor({}, {}, {}, {}, {})", (Object)serverName, (Object)serverPort, (Object)serverScheme, (Object)scriptName, (Object)contextPath);
        }
        this.setServerName(serverName);
        this.setServerPort(serverPort);
        this.setServerScheme(serverScheme);
        this.setScriptName(scriptName);
        this.setContextPath(contextPath);
    }

    public ServerData(ServerData serverData) {
        log.debug("Copy Constructor({})", (Object)serverData);
        this.setServerName(serverData.getServerName());
        this.setServerPort(serverData.getServerPort());
        this.setServerScheme(serverData.getServerScheme());
        this.setScriptName(serverData.getScriptName());
        this.setContextPath(serverData.getContextPath());
    }

    public ServerData(HttpServletRequest req) {
        this.setServerName(req.getServerName());
        this.setServerPort(req.getServerPort());
        this.setServerScheme(req.getScheme());
        this.setScriptName(req.getServletPath());
        this.setContextPath(req.getContextPath());
    }

    public Object clone() {
        log.debug("clone()");
        return new ServerData(this);
    }

    public String getServerName() {
        return StringUtils.isEmpty((CharSequence)this.serverName) ? "" : this.serverName;
    }

    public void setServerName(String serverName) {
        log.debug("setServerName({})", (Object)serverName);
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        log.debug("setServerPort({})", (Object)serverPort);
        this.serverPort = serverPort;
    }

    public String getServerScheme() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.serverScheme, (CharSequence)"");
    }

    public void setServerScheme(String serverScheme) {
        log.debug("setServerScheme({})", (Object)serverScheme);
        this.serverScheme = serverScheme;
    }

    public String getScriptName() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.scriptName, (CharSequence)"");
    }

    public void setScriptName(String scriptName) {
        log.debug("setScriptName({})", (Object)scriptName);
        this.scriptName = scriptName;
    }

    public String getContextPath() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.contextPath, (CharSequence)"");
    }

    public void setContextPath(String contextPath) {
        log.debug("setContextPath({})", (Object)contextPath);
        this.contextPath = contextPath;
    }

    public void getHostUrl(StringBuilder url) {
        url.append(this.getServerScheme());
        url.append("://");
        url.append(this.getServerName());
        if (this.getServerScheme().equals("http") && this.getServerPort() != 80 || this.getServerScheme().equals("https") && this.getServerPort() != 443) {
            url.append(":");
            url.append(this.getServerPort());
        }
    }

    public String toString() {
        StringBuilder url = new StringBuilder();
        this.getHostUrl(url);
        url.append(this.getContextPath());
        url.append(this.getScriptName());
        return url.toString();
    }
}

