/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import java.util.Properties;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs.utils.config.OptionConverter;
import org.apache.commons.jcs.utils.config.PropertySetter;
import org.apache.commons.jcs.utils.serialization.StandardSerializer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuxiliaryCacheConfigurator {
    private static final Log log = LogFactory.getLog(AuxiliaryCacheConfigurator.class);
    public static final String ATTRIBUTE_PREFIX = ".attributes";
    public static final String CACHE_EVENT_LOGGER_PREFIX = ".cacheeventlogger";
    public static final String SERIALIZER_PREFIX = ".serializer";

    public static ICacheEventLogger parseCacheEventLogger(Properties props, String auxPrefix) {
        ICacheEventLogger cacheEventLogger = null;
        String eventLoggerClassName = auxPrefix + CACHE_EVENT_LOGGER_PREFIX;
        cacheEventLogger = OptionConverter.instantiateByKey(props, eventLoggerClassName, null);
        if (cacheEventLogger != null) {
            String cacheEventLoggerAttributePrefix = auxPrefix + CACHE_EVENT_LOGGER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(cacheEventLogger, props, cacheEventLoggerAttributePrefix + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using custom cache event logger [" + cacheEventLogger + "] for auxiliary [" + auxPrefix + "]"));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("No cache event logger defined for auxiliary [" + auxPrefix + "]"));
        }
        return cacheEventLogger;
    }

    public static IElementSerializer parseElementSerializer(Properties props, String auxPrefix) {
        IElementSerializer elementSerializer = null;
        String elementSerializerClassName = auxPrefix + SERIALIZER_PREFIX;
        elementSerializer = OptionConverter.instantiateByKey(props, elementSerializerClassName, null);
        if (elementSerializer != null) {
            String attributePrefix = auxPrefix + SERIALIZER_PREFIX + ATTRIBUTE_PREFIX;
            PropertySetter.setProperties(elementSerializer, props, attributePrefix + ".");
            if (log.isInfoEnabled()) {
                log.info((Object)("Using custom element serializer [" + elementSerializer + "] for auxiliary [" + auxPrefix + "]"));
            }
        } else {
            elementSerializer = new StandardSerializer();
            if (log.isInfoEnabled()) {
                log.info((Object)("Using standard serializer [" + elementSerializer + "] for auxiliary [" + auxPrefix + "]"));
            }
        }
        return elementSerializer;
    }
}

