/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import jakarta.servlet.http.Part;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeRuntimeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.FileValidator;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.parser.ParameterParser;
import org.apache.fulcrum.parser.ValueParser;

public class UploadPartField
extends Field<Part> {
    private static final long serialVersionUID = -963692413506822188L;

    public UploadPartField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        if (prop != null) {
            throw new IntakeRuntimeException("Default values are not valid for " + this.getClass().getName());
        }
        this.defaultValue = null;
    }

    @Override
    public void setEmptyValue(String prop) {
        if (prop != null) {
            throw new IntakeRuntimeException("Empty values are not valid for " + this.getClass().getName());
        }
        this.emptyValue = null;
    }

    @Override
    protected String getDefaultValidator() {
        return FileValidator.class.getName();
    }

    @Override
    public Field<Part> init(ValueParser vp) throws IntakeException {
        if (!(vp instanceof ParameterParser)) {
            throw new IntakeException("UploadPartFields can only be used with ParameterParser");
        }
        super.init(vp);
        if (this.parser.containsKey((Object)this.getKey())) {
            this.setSet(true);
            this.validate();
        }
        return this;
    }

    @Override
    public boolean validate() {
        ParameterParser pp = (ParameterParser)this.parser;
        if (this.isMultiValued()) {
            Part[] ss = pp.getParts(this.getKey());
            if (ss.length == 0) {
                this.setSet(false);
            }
            if (this.getValidator() != null) {
                for (int i = 0; i < ss.length; ++i) {
                    try {
                        ((FileValidator)this.getValidator()).assertValidity(ss[i]);
                        continue;
                    }
                    catch (ValidationException ve) {
                        this.setMessage(ve.getMessage());
                    }
                }
            }
            if (this.isSet() && this.isValid()) {
                this.doSetValue();
            }
        } else {
            Part s = pp.getPart(this.getKey());
            if (s == null || s.getSize() == 0L) {
                this.setSet(false);
            }
            if (this.getValidator() != null) {
                try {
                    ((FileValidator)this.getValidator()).assertValidity(s);
                    if (this.isSet()) {
                        this.doSetValue();
                    }
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            } else if (this.isSet()) {
                this.doSetValue();
            }
        }
        return this.isValid();
    }

    @Override
    protected void doSetValue() {
        ParameterParser pp = (ParameterParser)this.parser;
        if (this.isMultiValued()) {
            this.setTestValue(pp.getParts(this.getKey()));
        } else {
            this.setTestValue(pp.getPart(this.getKey()));
        }
    }
}

