<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

TVM Contributors
================
TVM adopts the Apache way and governs by merit. We believe that it is important to create an inclusive community where everyone can use,
contribute to, and influence the direction of the project. We actively invite contributors who have earned the merit to be part of the development community.

See the [community structure document](https://tvm.apache.org/docs/contribute/community.html) for the explanation of community structure and contribution guidelines.


## Committers

We add tag along with committer name to show areas that they are familiar with.
We do encourage everyone to work anything they are interested in.

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri - rocm
- [Matthew Barrett](https://github.com/mbaret): @mbaret - byoc, arm
- [Matthew Brookhart](https://github.com/mbrookhart): @mbrookhart - relay, frontends
- [Yaxing Cai](https://github.com/cyx-6): @cyx-6 - tvm-script, runtime
- [Liangfu Chen](https://github.com/liangfu): @liangfu - vta, chisel, intel FPGA, c runtime
- [Tianqi Chen](https://github.com/tqchen) (PMC): @tqchen - topi, compiler, relay, docs
- [Wei Chen](https://github.com/wweic): @wweic - runtime, relay, vm
- [Zhi Chen](https://github.com/zhiics) (PMC): @zhiics - relay, quantization, pass manager
- [Egor Churaev](https://github.com/echuraev): @echuraev - metal, opencl, adreno
- [Balint Cristian](https://github.com/cbalint13): @cbalint13
- [Siyuan Feng](https://github.com/Hzfengsy) (PMC): @Hzfengsy - tir
- [Josh Fromm](https://github.com/jwfromm) (PMC): @jwfromm - frontends, quantization, topi
- [Mehrdad Hessar](https://github.com/mehrdadh): @mehrdadh - microTVM, hexagon
- [Bohan Hou](https://github.com/spectrometerHBH) (PMC): @spectrometerHBH - tir, arith, tvm-script
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei - topi, frontends
- [Luke Hutton](https://github.com/lhutton1): @lhutton1 - ethos-u, arm
- [Nick Hynes](https://github.com/nhynes): @nhynes: - sgx, rust
- [Animesh Jain](https://github.com/anijain2305): @anijain2305 - quantization, relay
- [Chenfan Jia](https://github.com/jcf94): @jcf94 - auto_scheduler
- [Ziheng Jiang](https://github.com/ZihengJiang) (PMC): @ZihengJiang - relay, compiler
- [Hongyi Jin](https://github.com/jinhongyii): @jinhongyii - tir, tvm-script, arith, relay, topi
- [Manupa Karunaratne](https://github.com/manupak): @manupak - ethos-u, memory planner
- [Elen Kalda](https://github.com/ekalda): @ekalda - ethos-u, arm
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame - relay
- [Tristan Konolige](https://github.com/tkonolige): @tkonolige - profiling, relay, tir, runtime
- [Ruihang Lai](https://github.com/MasterJH5574) (PMC): @MasterJH5574 - tir, tvm-script
- [Wuwei Lin](https://github.com/vinx13) (PMC): @vinx13 - relay, topi, tir, meta_schedule
- [Yizhi Liu](https://github.com/yzhliu) (PMC): @yzhliu - jvm, topi, relay
- [Hao Lu](https://github.com/hlu1): @hlu1 - nnpack, frontends
- [Eric Lunderberg](https://github.com/Lunderberg): @Lunderberg - CI, Vulkan backend
- [Andrew Z. Luo](https://github.com/AndrewZhaoLuo): @AndrewZhaoLuo - amp, relay, frontends
- [Steven Lyubomirsky](https://github.com/slyubomirsky): @slyubomirsky - relay
- [Masahiro Masuda](https://github.com/masahi) (PMC): @masahi - topi, relay
- [Thierry Moreau](https://github.com/tmoreau89) (PMC): @tmoreau89 - vta
- [Kazutaka Morita](https://github.com/kazum): @kazum - frontends, opencl
- [Trevor Morris](https://github.com/trevor-m): @trevor-m - byoc, compiler
- [Leandro Nunes](https://github.com/leandron) (PMC): @leandron - tvmc
- [Lily Orth-Smith](https://github.com/electriclilies): @electriclilies - relay
- [Ashutosh Parkhi](https://github.com/ashutosh-arm): @ashutosh-arm - cmsis-nn
- [Krzysztof Parzyszek](https://github.com/kparzysz-quic) (PMC): @kparzysz-quic - hexagon, llvm
- [Andrew Reusch](https://github.com/areusch): (PMC) @areusch - runtime, microTVM
- [David Riazati](https://github.com/driazati): @driazati - ci, community
- [Jared Roesch](https://github.com/jroesch) (PMC): @jroesch - relay
- [Gustavo Romero](https://github.com/gromero): @gromero - microtvm, tvmc
- [Giuseppe Rossini](https://github.com/giuseros): @giuseros - aot, arm
- [Siju Samuel](https://github.com/siju-samuel): @siju-samuel - frontends
- [Christopher Sidebottom](https://github.com/Mousius): @Mousius - arm, ethos-u, relay
- [Junru Shao](https://github.com/junrushao) (PMC): @junrushao - relay, compiler
- [Haichen Shen](https://github.com/icemelon) (PMC): @icemelon - relay, topi
- [Chris Sullivan](https://github.com/csullivan): @csullivan - amd backend
- [Siva Rama Krishna Reddy](https://github.com/srkreddy1238): @srkreddy1238 - frontends, golang
- [Zhixun Tan](https://github.com/phisiart): @phisiart - opengl, web
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch - topi, compiler, runtime
- [Gavin Uberti](https://github.com/guberti): @guberti - microtvm, arm
- [Luis Vega](https://github.com/vegaluisjose): @vegaluisjose - vta, chisel
- [Leyuan Wang](https://github.com/Laurawly) (PMC): @Laurawly: - topi
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun (PMC): - topi, vision
- [Jian Weng](https://github.com/were): @were: - hybrid script
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene - runtime, topi, frontends
- [Eddie Yan](https://github.com/eqy) (PMC): @eqy - runtime, autotvm, rpc, topi
- [Zihao Ye](https://github.com/yzh119): @yzh119 - tir
- [Hao Yu](https://github.com/comaniac): @comaniac (PMC) - relay, byoc, auto_scheduler
- [Shuai Yuan](https://github.com/ysh329): @ysh329 - ci
- [Qiang Zhang](https://github.com/Johnson9009): @Johnson9009 - relay, tvm-script
- [Lianmin Zheng](https://github.com/merrymercy) (PMC): @merrymercy - autotvm, auto_scheduler, topi, relay
- [Xiyou Zhou](https://github.com/zxybazh): @zxybazh - relay
- [wrongtest](https://github.com/wrongtest-intellif) (PMC): @wrongtest-intellif - tir, tvm-script, arith
- [Anirudh Sundar Subramaniam](https://github.com/quic-sanirudh): @quic-sanirudh

## Reviewers

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri
- [Matthew Barrett](https://github.com/mbaret): @mbaret
- [Arnaud Bergeron](https://github.com/abergeron): @abergeron
- [Florin Blanaru](https://github.com/gigiblender): @gigiblender
- [Matthew Brookhart](https://github.com/mbrookhart): @mbrookhart
- [Yaxing Cai](https://github.com/cyx-6): @cyx-6
- [Liangfu Chen](https://github.com/liangfu): @liangfu
- [Tianqi Chen](https://github.com/tqchen): @tqchen
- [Zhi Chen](https://github.com/zhiics): @zhiics
- [Valery Chernov](https://github.com/vvchernov): @vvchernov
- [Neo Chien](https://github.com/cchung100m): @cchung100m
- [Christian Convey](https://github.com/cconvey/): @cconvey
- [Meghan Cowan](https://github.com/cowanmeg): @cowanmeg
- [Balint Cristian](https://github.com/cbalint13): @cbalint13
- [Egor Churaev](https://github.com/echuraev): @echuraev
- [Xiaoqiang Dan](https://github.com/xqdan): @xqdan
- [Yixin Dong](https://github.com/Ubospica) @Ubospica
- [Haozheng Fan](https://github.com/hzfan): @hzfan
- [Siyuan Feng](https://github.com/Hzfengsy): @Hzfengsy
- [Josh Fromm](https://github.com/jwfromm): @jwfromm
- [Alexey Gladyshev](https://github.com/KJlaccHoeUM9l): @KJlaccHoeUM9l
- [Sergei Grechanik](https://github.com/sgrechanik-h): @sgrechanik-h
- [Altan Haan](https://github.com/altanh): @altanh
- [Mehrdad Hessar](https://github.com/mehrdadh): @mehrdadh
- [Bohan Hou](https://github.com/spectrometerHBH): @spectrometerHBH
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei
- [Luke Hutton](https://github.com/lhutton1): @lhutton1
- [Nick Hynes](https://github.com/nhynes): @nhynes
- [Animesh Jain](https://github.com/anijain2305): @anijain2305
- [Chenfan Jia](https://github.com/jcf94): @jcf94
- [Hua Jiang](https://github.com/huajsj): @huajsj
- [Ziheng Jiang](https://github.com/ZihengJiang): @ZihengJiang
- [Hongyi Jin](https://github.com/jinhongyii): @jinhongyii
- [Manupa Karunaratne](https://github.com/manupak): @manupak
- [Elen Kalda](https://github.com/ekalda): @ekalda
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame
- [Michael J. Klaiber](https://github.com/MichaelJKlaiber/) @MichaelJKlaiber
- [Noah Kontur](https://github.com/konturn/) @konturn
- [Tristan Konolige](https://github.com/tkonolige): @tkonolige
- [Mohamad Katanbaf](https://github.com/mkatanbaf): @mkatanbaf
- [Denise Kutnick](https://github.com/denise-k): @denise-k
- [Ruihang Lai](https://github.com/MasterJH5574): @MasterJH5574
- [Nicola Lancellotti](https://github.com/nicolalancellotti): @NicolaLancellotti
- [Wuwei Lin](https://github.com/vinx13): @vinx13
- [Andrew Liu](https://github.com/hypercubestart): @hypercubestart
- [Henry Liu](https://github.com/optima2005): @optima2005
- [Xin Liu](https://github.com/Meteorix): @Meteorix
- [Yizhi Liu](https://github.com/yzhliu) : @yzhliu
- [Hao Lu](https://github.com/hlu1): @hlu1
- [Eric Lunderberg](https://github.com/Lunderberg): @Lunderberg
- [Andrew Z. Luo](https://github.com/AndrewZhaoLuo): @AndrewZhaoLuo
- [Steven Lyubomirsky](https://github.com/slyubomirsky): @slyubomirsky
- [Alan MacDonald](https://github.com/alanmacd): @alanmacd
- [Masahiro Masuda](https://github.com/masahi): @masahi
- [Andrey Malyshev](https://github.com/elvin-n): @elvin-n
- [Sergey Mironov](https://github.com/grwlf): @grwlf
- [Thierry Moreau](https://github.com/tmoreau89): @tmoreau89
- [Kazutaka Morita](https://github.com/kazum): @kazum
- [Trevor Morris](https://github.com/trevor-m): @trevor-m
- [Tatsuya Nishiyama](https://github.com/nishi-t): @nishi-t
- [Leandro Nunes](https://github.com/leandron): @leandron
- [Jiawei Liu](https://github.com/ganler): @ganler
- [Lily Orth-Smith](https://github.com/electriclilies): @electriclilies
- [Wei Pan](https://github.com/wpan11nv): @wpan11nv
- [Michalis Papadimitriou](https://github.com/mikepapadim): @mikepapadim
- [Krzysztof Parzyszek](https://github.com/kparzysz-quic): @kparzysz-quic
- [Sunghyun Park](https://github.com/sunggg): @sunggg
- [Ashutosh Parkhi](https://github.com/ashutosh-arm): @ashutosh-arm
- [Alexander Peskov](https://github.com/apeskov): @apeskov
- [Pariksheet Pinjari](https://github.com/PariksheetPinjari909): @PariksheetPinjari909
- [Josh Pollock](https://github.com/joshpoll): @joshpoll
- [Ramana Radhakrishnan](https://github.com/u99127): @u99127
- [Andrew Reusch](https://github.com/areusch): @areusch
- [David Riazati](https://github.com/driazati): @driazati
- [Jared Roesch](https://github.com/jroesch): @jroesch
- [Gustavo Romero](https://github.com/gromero): @gromero
- [Giuseppe Rossini](https://github.com/giuseros): @giuseros
- [Siju Samuel](https://github.com/siju-samuel): @siju-samuel
- [Janet Schneider](https://github.com/janetsc): @janetsc
- [Junru Shao](https://github.com/junrushao): @junrushao
- [Haichen Shen](https://github.com/icemelon): @icemelon
- [Qingchao Shen](https://github.com/jikechao): @jikechao
- [Xingjian Shi](https://github.com/sxjscience): @sxjscience
- [Yuanjing Shi](https://github.com/shingjan): @shingjan
- [Mark Shields](https://github.com/mbs-octoml): @mbs-octoml
- [Christopher Sidebottom](https://github.com/mousius): @mousius
- [Siva Rama Krishna Reddy](https://github.com/srkreddy1238): @srkreddy1238
- [Dmitriy Smirnov](https://github.com/d-smirnov): @d-smirnov
- [Jon Soifer](https://github.com/soiferj): @soiferj
- [Adam Straw](https://github.com/adstraw): @adstraw
- [Chris Sullivan](https://github.com/csullivan): @csullivan
- [Anirudh Sundar Subramaniam](https://github.com/quic-sanirudh): @quic-sanirudh
- [Zhixun Tan](https://github.com/phisiart): @phisiart
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch
- [Jorn Tuyls](https://github.com/jtuyls): @jtuyls
- [Gavin Uberti](https://github.com/guberti): @guberti
- [Luis Vega](https://github.com/vegaluisjose): @vegaluisjose
- [Jyotsna Verma](https://github.com/jverma-quic): @jverma-quic
- [Thomas Viehmann](https://github.com/t-vi): @t-vi
- [An Wang](https://github.com/anwang2009): @anwang2009
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun
- [Yuchen Wang](https://github.com/wyc-ruiker): @wyc-ruiker
- [Leyuan Wang](https://github.com/Laurawly): @Laurawly
- [Alex Weaver](https://github.com/alex-weaver): @alex-weaver
- [Logan Weber](https://github.com/weberlo): @weberlo
- [Matt Welsh](https://github.com/mdw-octoml): @mdw-octoml
- [Cheng Wen](https://github.com/chengven027-intellif): @chengven027-intellif
- [Jian Weng](https://github.com/were): @were
- [wrongtest](https://github.com/wrongtest-intellif): @wrongtest-intellif
- [Yong Wu](https://github.com/yongwww): @yongwww
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene
- [Bing Xu](https://github.com/antinucleon): @antinucleon
- [Eddie Yan](https://github.com/eqy): @eqy
- [Aleksei Yazev](https://github.com/Aleksei-grovety): @Aleksei-grovety
- [Zihao Ye](https://github.com/yzh119): @yzh119
- [Hao Yu](https://github.com/comaniac): @comaniac
- [Shuai Yuan](https://github.com/ysh329): @ysh329
- [Joshua Z. Zhang](https://github.com/zhreshold): @zhreshold
- [Lianmin Zheng](https://github.com/merrymercy): @merrymercy
- [Min Chen](https://github.com/multiverstack-intellif): @multiverstack-intellif
- [Xiyou Zhou](https://github.com/zxybazh): @zxybazh
- [@blackkker](https://github.com/blackkker): @blackkker
- [Jiajun Jiang](https://github.com/jiangjiajun): @jiangjiajun
- [Qiang Zhang](https://github.com/Johnson9009): @Johnson9009

## List of Contributors
- [Full List of Contributors](https://github.com/apache/tvm/graphs/contributors)

## Mentors

TVM is now a top-level Apache project. During our Incubator phase, we were fortunate to have the following mentors.

- Markus Weimer @markusweimer
- Sebastian Schelter @sscdotopen
- Byung-Gon Chun @bgchun
- Henry Saputra @hsaputra
- Timothy Chen @tnachen
- Furkan KAMACI @kamaci
