/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.textruler.core.TextRulerExampleDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextRulerAnnotation {
    private TextRulerExampleDocument document;
    private int begin;
    private int end;
    private Type type;
    private String coveredText;
    private Map<String, String> featureMap = new HashMap<String, String>();

    public TextRulerAnnotation(AnnotationFS afs, TextRulerExampleDocument document, List<String> consideredFeatures) {
        this.document = document;
        this.begin = afs.getBegin();
        this.end = afs.getEnd();
        this.type = afs.getType();
        this.coveredText = afs.getCoveredText();
        if (consideredFeatures != null) {
            for (String string : consideredFeatures) {
                Feature feature = afs.getType().getFeatureByBaseName(string);
                if (feature == null || !feature.getRange().isPrimitive()) continue;
                String valueAsString = afs.getFeatureValueAsString(feature);
                if (feature.getRange().getName().equals("uima.cas.String")) {
                    valueAsString = "\"" + valueAsString + "\"";
                }
                this.featureMap.put(string, valueAsString);
            }
        }
    }

    public TextRulerAnnotation(AnnotationFS afs, TextRulerExampleDocument document) {
        this(afs, document, null);
    }

    public TextRulerAnnotation(AnnotationFS afs) {
        this(afs, null);
    }

    public TextRulerExampleDocument getDocument() {
        return this.document;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public Type getType() {
        return this.type;
    }

    public String getCoveredText() {
        return this.coveredText;
    }

    public String toString() {
        return this.getCoveredText();
    }

    public boolean equals(Object o) {
        TextRulerAnnotation a = (TextRulerAnnotation)o;
        return this.document == a.document && this.begin == a.begin && this.end == a.end && this.coveredText.equals(a.coveredText);
    }

    public int hashCode() {
        return this.begin * 17 * this.end + this.coveredText.hashCode();
    }

    public Map<String, String> getFeatureMap() {
        return this.featureMap;
    }

    public void setFeatureMap(Map<String, String> featureMap) {
        this.featureMap = featureMap;
    }
}

