/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import java.util.Map;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractStructureAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class FillAction
extends AbstractStructureAction {
    private Map<IStringExpression, IRutaExpression> features;
    private ITypeExpression structureType;

    public FillAction(ITypeExpression structureType, Map<IStringExpression, IRutaExpression> features) {
        this.structureType = structureType;
        this.features = features;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        Type type = this.getStructureType().getType(context, stream);
        if (type == null) {
            return;
        }
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOfElement(element);
        for (AnnotationFS matchedAnnotation : matchedAnnotations) {
            AnnotationFS m;
            List<AnnotationFS> matchedAnnotations2;
            if (matchedAnnotation == null) {
                return;
            }
            List<AnnotationFS> list = stream.getAnnotationsInWindow(matchedAnnotation, type);
            if (list.isEmpty()) {
                list = stream.getOverappingAnnotations(matchedAnnotation, type);
            }
            if (list.isEmpty() && !(matchedAnnotations2 = match.getMatchedAnnotations(null, element.getContainer())).isEmpty() && (list = stream.getAnnotationsInWindow(m = matchedAnnotations2.get(0), type)).isEmpty()) {
                list = stream.getOverappingAnnotations(m, type);
            }
            for (AnnotationFS annotationFS : list) {
                stream.getCas().removeFsFromIndexes((FeatureStructure)annotationFS);
                context.setAnnotation(matchedAnnotation);
                stream.assignFeatureValues((FeatureStructure)annotationFS, this.features, context);
                stream.getCas().addFsToIndexes((FeatureStructure)annotationFS);
                this.addAnnotationToLabel(annotationFS, context);
            }
        }
    }

    public Map<IStringExpression, IRutaExpression> getFeatures() {
        return this.features;
    }

    public ITypeExpression getStructureType() {
        return this.structureType;
    }
}

