/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.CompositeDestinationInterceptor;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.plugin.AbstractRuntimeConfigurationBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateVirtualDestinationsTask
implements Runnable {
    public static final Logger LOG = LoggerFactory.getLogger(UpdateVirtualDestinationsTask.class);
    private final AbstractRuntimeConfigurationBroker plugin;

    public UpdateVirtualDestinationsTask(AbstractRuntimeConfigurationBroker plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        boolean updatedExistingInterceptor = false;
        RegionBroker regionBroker = (RegionBroker)this.plugin.getBrokerService().getRegionBroker();
        for (DestinationInterceptor destinationInterceptor : this.plugin.getBrokerService().getDestinationInterceptors()) {
            if (!(destinationInterceptor instanceof VirtualDestinationInterceptor)) continue;
            VirtualDestinationInterceptor virtualDestinationInterceptor = (VirtualDestinationInterceptor)destinationInterceptor;
            HashSet existingVirtualDests = new HashSet();
            Collections.addAll(existingVirtualDests, virtualDestinationInterceptor.getVirtualDestinations());
            HashSet newVirtualDests = new HashSet();
            Collections.addAll(newVirtualDests, this.getVirtualDestinations());
            HashSet<VirtualDestination> addedVirtualDests = new HashSet<VirtualDestination>();
            HashSet<VirtualDestination> removedVirtualDests = new HashSet<VirtualDestination>();
            for (VirtualDestination newVirtualDest : newVirtualDests) {
                if (existingVirtualDests.contains(newVirtualDest)) continue;
                addedVirtualDests.add(newVirtualDest);
            }
            for (Object existingVirtualDest : existingVirtualDests) {
                if (newVirtualDests.contains(existingVirtualDest)) continue;
                removedVirtualDests.add((VirtualDestination)existingVirtualDest);
            }
            virtualDestinationInterceptor.setVirtualDestinations(this.getVirtualDestinations());
            this.plugin.info("applied updates to: " + virtualDestinationInterceptor);
            updatedExistingInterceptor = true;
            try {
                Object existingVirtualDest;
                ConnectionContext connectionContext = this.plugin.getBrokerService().getAdminConnectionContext();
                if (!this.plugin.getBrokerService().isUseVirtualDestSubs()) continue;
                for (VirtualDestination removedVirtualDest : removedVirtualDests) {
                    this.plugin.virtualDestinationRemoved(connectionContext, removedVirtualDest);
                    LOG.info("Removing virtual destination: {}", (Object)removedVirtualDest);
                }
                existingVirtualDest = addedVirtualDests.iterator();
                while (existingVirtualDest.hasNext()) {
                    VirtualDestination addedVirtualDest = (VirtualDestination)existingVirtualDest.next();
                    this.plugin.virtualDestinationAdded(connectionContext, addedVirtualDest);
                    LOG.info("Adding virtual destination: {}", (Object)addedVirtualDest);
                }
            }
            catch (Exception e) {
                LOG.warn("Could not process virtual destination advisories", (Throwable)e);
            }
        }
        if (!updatedExistingInterceptor) {
            VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
            virtualDestinationInterceptor.setVirtualDestinations(this.getVirtualDestinations());
            ArrayList<Object> interceptorsList = new ArrayList<Object>();
            interceptorsList.addAll(Arrays.asList(this.plugin.getBrokerService().getDestinationInterceptors()));
            interceptorsList.add(virtualDestinationInterceptor);
            DestinationInterceptor[] destinationInterceptors = interceptorsList.toArray(new DestinationInterceptor[0]);
            this.plugin.getBrokerService().setDestinationInterceptors(destinationInterceptors);
            ((CompositeDestinationInterceptor)regionBroker.getDestinationInterceptor()).setInterceptors(destinationInterceptors);
            this.plugin.info("applied new: " + interceptorsList);
        }
        regionBroker.reapplyInterceptor();
    }

    protected abstract VirtualDestination[] getVirtualDestinations();
}

