/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resourceSpecifier.factory.impl;

import org.apache.uima.resourceSpecifier.TopLevelAnalysisEngineType;
import org.apache.uima.resourceSpecifier.factory.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.resourceSpecifier.factory.CasMultiplier;
import org.apache.uima.resourceSpecifier.factory.DelegateConfiguration;
import org.apache.uima.resourceSpecifier.factory.Delegates;
import org.apache.uima.resourceSpecifier.factory.Scaleout;
import org.apache.uima.resourceSpecifier.factory.ServiceContext;
import org.apache.uima.resourceSpecifier.factory.TopLevelAnalysisEngine;
import org.apache.uima.resourceSpecifier.factory.impl.AggregateDelegateEngineImpl;
import org.apache.uima.resourceSpecifier.factory.impl.AsyncPrimitiveErrorConfigurationImpl;
import org.apache.uima.resourceSpecifier.factory.impl.CasMultiplierImpl;
import org.apache.uima.resourceSpecifier.factory.impl.DelegatesImpl;
import org.apache.uima.resourceSpecifier.factory.impl.ScaleoutImpl;
import org.springframework.util.Assert;

public class TopLevelAnalysisEngineImpl
implements TopLevelAnalysisEngine {
    private TopLevelAnalysisEngineType tlea;
    private Scaleout inputQueueScaleout = null;
    private Scaleout replyQueueScaleout = null;
    private Delegates delegates = null;
    private AsyncPrimitiveErrorConfiguration ec = null;
    private CasMultiplier cm = null;

    protected TopLevelAnalysisEngineImpl(TopLevelAnalysisEngineType tlea, ServiceContext context, DelegateConfiguration ... delegateConfigurations) {
        this.tlea = tlea;
        if (context.isCasMultiplier()) {
            this.cm = new CasMultiplierImpl(tlea.addNewCasMultiplier(), context);
        }
        if (delegateConfigurations != null && delegateConfigurations.length > 0) {
            tlea.setAsync("true");
            AggregateDelegateEngineImpl aggregateDelegateEngine = new AggregateDelegateEngineImpl(tlea, "", context, delegateConfigurations);
            this.delegates = new DelegatesImpl(tlea.addNewDelegates(), aggregateDelegateEngine, context, delegateConfigurations);
        } else {
            tlea.setAsync(String.valueOf(context.isAsync()));
            this.ec = new AsyncPrimitiveErrorConfigurationImpl(tlea.addNewAsyncPrimitiveErrorConfiguration(), context, true);
            this.inputQueueScaleout = new ScaleoutImpl(tlea.addNewScaleout(), context);
        }
    }

    @Override
    public Scaleout getInputQueueScaleout() {
        Assert.notNull((Object)this.inputQueueScaleout);
        return this.inputQueueScaleout;
    }

    @Override
    public void setInputQueueScaleout(Scaleout scaleup) {
        Assert.notNull((Object)this.tlea);
        if (this.inputQueueScaleout == null) {
            this.getInputQueueScaleout().setNumberOfInstances(scaleup.getNumberOfInstances());
        }
    }

    @Override
    public Scaleout getReplyQueueScaleout() {
        Assert.notNull((Object)this.tlea);
        if (this.replyQueueScaleout == null) {
            // empty if block
        }
        return this.replyQueueScaleout;
    }

    @Override
    public void setReplyQueueScaleout(Scaleout replyQueueScaleout) {
        Assert.notNull((Object)this.tlea);
        this.tlea.setInternalReplyQueueScaleout(String.valueOf(replyQueueScaleout));
    }

    @Override
    public Delegates getDelegates() {
        Assert.notNull((Object)this.delegates);
        return this.delegates;
    }

    @Override
    public void setDelegates(Delegates delegates) {
        Assert.notNull((Object)this.tlea);
    }

    @Override
    public CasMultiplier getCasMultiplier() {
        Assert.notNull((Object)this.tlea);
        return null;
    }

    @Override
    public AsyncPrimitiveErrorConfiguration getPrimitiveErrorConfiguration() {
        Assert.notNull((Object)this.ec);
        return this.ec;
    }

    @Override
    public void setPrimitiveErrorConfiguration(AsyncPrimitiveErrorConfiguration ec) {
        Assert.notNull((Object)this.tlea);
    }

    @Override
    public String getKey() {
        Assert.notNull((Object)this.tlea);
        return null;
    }

    @Override
    public void setKey(String key) {
        Assert.notNull((Object)this.tlea);
    }

    @Override
    public boolean isAsync() {
        Assert.notNull((Object)this.tlea);
        return false;
    }

    @Override
    public void setIsAsync() {
        Assert.notNull((Object)this.tlea);
    }

    public void setReplyQueueScaleout() {
    }
}

