/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.StringWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class MessageWarner
extends XMLEmitter {
    boolean abort = false;

    public void startDocument(int n) throws XPathException {
        this.setWriter(new StringWriter());
        this.abort = (n & 0x4000) != 0;
        super.startDocument(n);
    }

    public void endDocument() throws XPathException {
        ErrorListener errorListener = this.getPipelineConfiguration().getErrorListener();
        DynamicError dynamicError = new DynamicError(((StringWriter)this.getWriter()).toString());
        dynamicError.setErrorCode("XTMM9000");
        try {
            if (this.abort) {
                errorListener.error(dynamicError);
            } else {
                errorListener.warning(dynamicError);
            }
        }
        catch (TransformerException transformerException) {
            throw DynamicError.makeDynamicError(transformerException);
        }
    }
}

