/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.CollectionURIResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.Document;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;

public class Collection
extends SystemFunction {
    private String expressionBaseURI = null;

    public String getStaticBaseURI() {
        return this.expressionBaseURI;
    }

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.expressionBaseURI == null) {
            super.checkArguments(staticContext);
            this.expressionBaseURI = staticContext.getBaseURI();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator;
        String string = this.getNumberOfArguments() == 0 ? null : this.argument[0].evaluateItem(xPathContext).getStringValue();
        CollectionURIResolver collectionURIResolver = xPathContext.getConfiguration().getCollectionURIResolver();
        try {
            sequenceIterator = collectionURIResolver.resolve(string, this.expressionBaseURI, xPathContext);
        }
        catch (XPathException xPathException) {
            xPathException.setLocator(this);
            throw xPathException;
        }
        return Collection.getResolverResults(sequenceIterator, this.expressionBaseURI, xPathContext, this);
    }

    public static SequenceIterator getResolverResults(SequenceIterator sequenceIterator, final String string, final XPathContext xPathContext, final SourceLocator sourceLocator) {
        if (sequenceIterator == null) {
            return EmptyIterator.getInstance();
        }
        ItemMappingFunction itemMappingFunction = new ItemMappingFunction(){

            public Item map(Item item) throws XPathException {
                if (item instanceof NodeInfo) {
                    return item;
                }
                if (item instanceof AnyURIValue) {
                    return Document.makeDoc(item.getStringValue(), string, xPathContext, sourceLocator);
                }
                throw new DynamicError("Value returned by CollectionURIResolver must be an anyURI or a NodeInfo");
            }
        };
        return new ItemMappingIterator(sequenceIterator, itemMappingFunction);
    }
}

