/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.agent;

import java.net.InetAddress;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NodeMetricsConfiguration {
    @Value(value="#{ systemProperties['ducc.agent.node.metrics.generator'] }")
    String agentNodeMetricGenerator;
    @Value(value="#{ systemProperties['ducc.agent.node.metrics.target.endpoint'] }")
    String agentNodeMetricEndpointTarget;

    @Bean
    public RouteBuilder routeBuilderForNodeMetrics(final Processor nodeMetricsProcessor) {
        return new RouteBuilder(){

            public void configure() throws Exception {
                System.out.println("............. Generator::" + NodeMetricsConfiguration.this.agentNodeMetricGenerator);
                System.out.println("............. Target::" + NodeMetricsConfiguration.this.agentNodeMetricEndpointTarget);
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from(NodeMetricsConfiguration.this.agentNodeMetricGenerator).setHeader("event", (Expression)this.constant("nodestats"))).setHeader("nodename", (Expression)this.constant(InetAddress.getLocalHost().getHostName()))).setHeader("nodeip", (Expression)this.constant(InetAddress.getLocalHost().getHostAddress()))).process(nodeMetricsProcessor)).to(NodeMetricsConfiguration.this.agentNodeMetricEndpointTarget);
            }
        };
    }
}

