/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.jp;

import java.lang.management.ManagementFactory;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.ducc.transport.agent.IUimaPipelineAEComponent;
import org.apache.uima.ducc.transport.agent.UimaPipelineAEComponent;
import org.apache.uima.ducc.transport.configuration.jp.AgentSession;

public class JmxAEProcessInitMonitor
implements Runnable {
    volatile boolean running = false;
    MBeanServer server = null;
    AgentSession agent;
    static int howManySeenSoFar = 1;
    public List<IUimaPipelineAEComponent> aeStateList = new ArrayList<IUimaPipelineAEComponent>();

    public JmxAEProcessInitMonitor(AgentSession agent) throws Exception {
        this.server = ManagementFactory.getPlatformMBeanServer();
        this.agent = agent;
    }

    private IUimaPipelineAEComponent getUimaAeByName(String name) {
        for (IUimaPipelineAEComponent aeState : this.aeStateList) {
            if (!aeState.getAeName().equals(name)) continue;
            return aeState;
        }
        return null;
    }

    public void updateAgentWhenRunning() {
        this.running = true;
        try {
            this.run();
        }
        catch (Exception ex) {
            this.agent.logger.error("UimaAEJmxMonitor.updateAgentWhenRunning", null, (Throwable)ex, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            return;
        }
        try {
            ObjectName uimaServicePattern = new ObjectName("org.apache.uima:*");
            HashSet<ObjectInstance> mbeans = new HashSet<ObjectInstance>(this.server.queryMBeans(uimaServicePattern, null));
            ArrayList<IUimaPipelineAEComponent> componentsToDelete = new ArrayList<IUimaPipelineAEComponent>();
            boolean updateAgent = false;
            for (ObjectInstance instance : mbeans) {
                String[] aeObjectNameParts;
                String targetName = instance.getObjectName().getKeyProperty("name");
                if (targetName.endsWith("FlowController") || targetName.trim().endsWith("DUCC.Job") || !instance.getClassName().equals("org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl") || (aeObjectNameParts = instance.getObjectName().toString().split(",")).length == 3) continue;
                StringBuffer sb = new StringBuffer();
                for (String part : aeObjectNameParts) {
                    if (part.startsWith("org.apache.uima:type") || part.startsWith("s=")) continue;
                    sb.append("/");
                    if (part.endsWith("Components")) {
                        part = part.substring(0, part.indexOf("Components")).trim();
                    }
                    sb.append(part.substring(part.indexOf("=") + 1));
                }
                AnalysisEngineManagement proxy = JMX.newMBeanProxy(this.server, instance.getObjectName(), AnalysisEngineManagement.class);
                IUimaPipelineAEComponent aeState = null;
                aeState = this.getUimaAeByName(sb.toString());
                if (aeState == null) {
                    if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) continue;
                    aeState = new UimaPipelineAEComponent(sb.toString(), proxy.getThreadId(), AnalysisEngineManagement.State.valueOf((String)proxy.getState()));
                    this.aeStateList.add(aeState);
                    ((UimaPipelineAEComponent)aeState).startInitialization = System.currentTimeMillis();
                    aeState.setAeState(AnalysisEngineManagement.State.Initializing);
                    updateAgent = true;
                } else if (AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Initializing)) {
                    updateAgent = true;
                    aeState.setInitializationTime(System.currentTimeMillis() - ((UimaPipelineAEComponent)aeState).startInitialization);
                } else if (aeState.getAeState().equals((Object)AnalysisEngineManagement.State.Initializing) && AnalysisEngineManagement.State.valueOf((String)proxy.getState()).equals((Object)AnalysisEngineManagement.State.Ready)) {
                    aeState.setAeState(AnalysisEngineManagement.State.Ready);
                    updateAgent = true;
                    JmxAEProcessInitMonitor jmxAEProcessInitMonitor = this;
                    synchronized (jmxAEProcessInitMonitor) {
                        try {
                            this.wait(5L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    aeState.setInitializationTime(proxy.getInitializationTime());
                    componentsToDelete.add(aeState);
                }
                if (this.agent == null || this.agent.logger == null) continue;
                this.agent.logger.debug("UimaAEJmxMonitor.run()", null, new Object[]{"---- AE Name:" + proxy.getName() + " AE State:" + proxy.getState() + " AE init time=" + aeState.getInitializationTime() + " Proxy Init time=" + proxy.getInitializationTime() + " Proxy Thread ID:" + proxy.getThreadId()});
            }
            howManySeenSoFar = 1;
            if (updateAgent && !this.running) {
                if (this.agent != null && this.agent.logger != null) {
                    this.agent.logger.debug("UimaAEJmxMonitor.run()", null, new Object[]{"---- Publishing UimaPipelineAEComponent List - size=" + this.aeStateList.size()});
                }
                try {
                    if (this.agent != null) {
                        this.agent.notify(false, this.aeStateList);
                    }
                }
                catch (Exception ex) {
                    throw ex;
                }
                finally {
                    for (IUimaPipelineAEComponent aeState : componentsToDelete) {
                        this.aeStateList.remove(aeState);
                    }
                }
            }
        }
        catch (UndeclaredThrowableException e) {
            if (!(e.getCause() instanceof InstanceNotFoundException)) {
                if (howManySeenSoFar > 3) {
                    if (this.agent != null && this.agent.logger != null) {
                        this.agent.logger.info("UimaAEJmxMonitor.run()", null, (Throwable)e, new Object[0]);
                    }
                    howManySeenSoFar = 1;
                    throw e;
                }
                ++howManySeenSoFar;
            }
        }
        catch (Throwable e) {
            howManySeenSoFar = 1;
            this.agent.logger.info("UimaAEJmxMonitor.run()", null, e, new Object[0]);
        }
    }
}

