/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.configuration.service;

import java.net.InetAddress;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.uima.ducc.common.IDuccUser;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.container.FlagsHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.Utils;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.configuration.jp.AgentSession;
import org.apache.uima.ducc.transport.configuration.service.ServiceComponent;
import org.apache.uima.ducc.transport.configuration.service.ServiceEventListener;
import org.apache.uima.ducc.transport.dispatcher.DuccEventDispatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class ServiceConfiguration {
    public static final String AGENT_ENDPOINT = "mina:tcp://localhost:";
    protected static DuccLogger logger = new DuccLogger(ServiceConfiguration.class);
    @Autowired
    DuccTransportConfiguration transport;
    @Autowired
    CommonConfiguration common;
    ServiceComponent duccComponent = null;
    CamelContext camelContext;
    AgentSession agent = null;
    RouteBuilder routeBuilder;

    public synchronized RouteBuilder routeBuilderForIncomingRequests(final String thisNodeIP, final ServiceEventListener delegate) {
        return new RouteBuilder(){
            Predicate filter;
            {
                this.filter = new DuccProcessFilter(thisNodeIP);
            }

            public void configure() throws Exception {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process((Processor)new ErrorProcessor())).end();
                ((ChoiceDefinition)this.from(ServiceConfiguration.this.common.managedServiceEndpoint).choice().when(this.filter).bean((Object)delegate)).end().setId(ServiceConfiguration.this.common.managedServiceEndpoint);
            }
        };
    }

    private void checkPrereqs() {
    }

    public String getUserContainerClassForJob(String key) {
        if (key.equals("uima-as")) {
            if (this.common.uimaASProcessContainerClass == null) {
                return "org.apache.uima.ducc.user.jp.UimaASProcessContainer";
            }
            return this.common.uimaASProcessContainerClass;
        }
        if (this.common.uimaProcessContainerClass == null) {
            return "org.apache.uima.ducc.user.jp.UimaProcessContainer";
        }
        return this.common.uimaProcessContainerClass;
    }

    @Bean
    public ServiceComponent getServiceInstance() throws Exception {
        this.checkPrereqs();
        try {
            String thisNodeIP = System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value()) == null ? InetAddress.getLocalHost().getHostAddress() : System.getenv(IDuccUser.EnvironmentVariable.DUCC_IP.value());
            this.camelContext = this.common.camelContext();
            if (System.getProperty(FlagsHelper.Name.JpProcessorClass.pname()) == null) {
                String containerClass = "org.apache.uima.ducc.user.service.UimaASServiceContainer";
                System.setProperty(FlagsHelper.Name.JpProcessorClass.pname(), containerClass);
            }
            int serviceSocketPort = 0;
            String agentSocketParams = "";
            String jpSocketParams = "";
            if (this.common.managedServiceEndpointParams != null) {
                jpSocketParams = "?" + this.common.managedServiceEndpointParams;
            }
            if (this.common.managedProcessStateUpdateEndpointParams != null) {
                agentSocketParams = "?" + this.common.managedProcessStateUpdateEndpointParams;
            }
            boolean disableAgentUpdates = false;
            if (this.common.managedProcessStateUpdateEndpointType != null && this.common.managedProcessStateUpdateEndpointType.equalsIgnoreCase("socket")) {
                String updatePort = System.getenv(IDuccUser.EnvironmentVariable.DUCC_UPDATE_PORT.value());
                if (updatePort == null || updatePort.trim().isEmpty()) {
                    disableAgentUpdates = true;
                }
                this.common.managedProcessStateUpdateEndpoint = AGENT_ENDPOINT + updatePort + agentSocketParams;
            }
            if (this.common.managedServiceEndpointType != null && this.common.managedServiceEndpointType.equalsIgnoreCase("socket")) {
                serviceSocketPort = Utils.findFreePort();
                this.common.managedServiceEndpoint = AGENT_ENDPOINT + serviceSocketPort + jpSocketParams;
            }
            DuccEventDispatcher eventDispatcher = this.transport.duccEventDispatcher(this.common.managedProcessStateUpdateEndpoint, this.camelContext);
            String processId = System.getProperty(IDuccUser.DashD.DUCC_ID_PROCESS_UNIQUE.value());
            if (processId == null) {
                processId = System.getenv(IDuccUser.EnvironmentVariable.DUCC_PROCESS_UNIQUEID.value());
            }
            this.agent = new AgentSession(eventDispatcher, processId, this.common.managedServiceEndpoint);
            if (disableAgentUpdates) {
                this.agent.disable(disableAgentUpdates);
            }
            this.duccComponent = new ServiceComponent("UimaProcess", this.camelContext, this);
            this.duccComponent.setAgentSession(this.agent);
            this.duccComponent.setSaxonJarPath(this.common.saxonJarPath);
            this.duccComponent.setDd2SpringXslPath(this.common.dd2SpringXslPath);
            ServiceEventListener eventListener = new ServiceEventListener(this.duccComponent);
            this.routeBuilder = this.routeBuilderForIncomingRequests(thisNodeIP, eventListener);
            this.camelContext.addRoutes((RoutesBuilder)this.routeBuilder);
            return this.duccComponent;
        }
        catch (Exception e) {
            logger.error("getServiceInstance", null, (Throwable)e, new Object[0]);
            throw e;
        }
    }

    private class DuccProcessFilter
    implements Predicate {
        String thisNodeIP;

        public DuccProcessFilter(String thisNodeIP) {
            this.thisNodeIP = thisNodeIP;
        }

        public synchronized boolean matches(Exchange exchange) {
            boolean result = false;
            try {
                String pid = (String)exchange.getIn().getHeader("processPID");
                String targetIP = (String)exchange.getIn().getHeader("nodeip");
                if (Utils.getPID().equals(pid) && this.thisNodeIP.equals(targetIP)) {
                    result = true;
                }
            }
            catch (Throwable e) {
                logger.error("matches", null, e, new Object[0]);
            }
            return result;
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            logger.error("process", null, caused, new Object[0]);
        }
    }
}

