/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.transport.dispatcher.IDuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccEvent;

public abstract class BaseHttpDispatcher
implements IDuccEventDispatcher {
    String targetEndpoint;
    int socketTimeout = 0;

    public BaseHttpDispatcher(String targetEndpoint, int timeout) throws Exception {
        this.targetEndpoint = targetEndpoint;
        if (timeout == -1) {
            String st = System.getProperty("ducc.cli.httpclient.sotimeout");
            if (st != null) {
                this.socketTimeout = Integer.parseInt(st);
            }
        } else {
            this.socketTimeout = timeout;
        }
    }

    abstract String toXml(Object var1) throws Exception;

    abstract Object fromXml(String var1) throws Exception;

    public String dispatch(String outgoing, String content_type) throws Exception {
        int status;
        URL url = new URL(this.targetEndpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (outgoing != null) {
            conn.setRequestProperty("Content-Type", content_type);
            conn.setDoOutput(true);
            OutputStream postout = conn.getOutputStream();
            postout.write(outgoing.getBytes());
            postout.close();
        }
        if ((status = conn.getResponseCode()) == 200) {
            InputStream content = conn.getInputStream();
            StringBuffer sb = new StringBuffer();
            byte[] slice = new byte[4096];
            int bytes_read = 0;
            BufferedInputStream bis = new BufferedInputStream(content);
            while ((bytes_read = bis.read(slice, 0, slice.length)) != -1) {
                sb.append(new String(slice, 0, bytes_read));
            }
            content.close();
            String response = sb.toString();
            return response;
        }
        String body = conn.getResponseMessage();
        throw new DuccRuntimeException("Ducc Unable to Process Request. Http Response Code: " + status + ". Ducc Service (OR) Returned Exception:", new Exception(body));
    }

    @Override
    public DuccEvent dispatchAndWaitForDuccReply(DuccEvent duccEvent) throws Exception {
        String serBody = null;
        try {
            serBody = this.toXml(duccEvent);
            String response = this.dispatch(serBody, "text/xml");
            return (DuccEvent)this.fromXml(response);
        }
        catch (Throwable t) {
            switch (duccEvent.getEventType()) {
                case JD_STATE: {
                    throw t;
                }
            }
            throw t;
        }
    }

    @Override
    public void close() {
    }
}

