/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.dispatcher;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.uima.ducc.common.utils.DuccProperties;
import org.apache.uima.ducc.transport.dispatcher.BaseHttpDispatcher;
import org.apache.uima.ducc.transport.dispatcher.ClassManager;
import org.apache.uima.ducc.transport.dispatcher.IDuccEventDispatcher;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobReplyDuccEvent;

public class DuccEventHttpDispatcherCl
extends BaseHttpDispatcher
implements IDuccEventDispatcher {
    private ClassManager classManager = null;
    String[] classpath = new String[]{"apache-uima/apache-activemq/lib/optional/xstream*", "lib/google-gson/gson*"};
    int socketTimeout = 0;

    public DuccEventHttpDispatcherCl(String targetEndpoint) throws Exception {
        this(targetEndpoint, -1);
    }

    public DuccEventHttpDispatcherCl(String targetEndpoint, int timeout) throws Exception {
        super(targetEndpoint, timeout);
        this.classManager = new ClassManager(this.classpath);
    }

    private void secureXStream(Object xStream_obj) throws Exception {
        Class<?> c = this.classManager.loadClass("com.thoughtworks.xstream.XStream");
        Method m = c.getDeclaredMethod("setupDefaultSecurity", c);
        m.invoke(null, xStream_obj);
        Object noTypePermissionObject = this.classManager.construct("com.thoughtworks.xstream.security.NoTypePermission");
        Field noneField = noTypePermissionObject.getClass().getDeclaredField("NONE");
        Object anyTypePermissionObject = this.classManager.construct("com.thoughtworks.xstream.security.AnyTypePermission");
        Field anyField = anyTypePermissionObject.getClass().getDeclaredField("ANY");
        this.classManager.invoke(xStream_obj, "addPermission", new Object[]{noneField.get(null)});
        this.classManager.invoke(xStream_obj, "addPermission", new Object[]{anyField.get(null)});
    }

    @Override
    String toXml(Object ev) throws Exception {
        Object dd_obj = this.classManager.construct("com.thoughtworks.xstream.io.xml.DomDriver", new Object[]{null});
        Object xStream_obj = this.classManager.construct("com.thoughtworks.xstream.XStream", new Object[]{dd_obj});
        this.secureXStream(xStream_obj);
        String serializaedMsg = (String)this.classManager.invoke(xStream_obj, "toXML", new Object[]{ev});
        return serializaedMsg;
    }

    @Override
    Object fromXml(String str) throws Exception {
        Object dd_obj = this.classManager.construct("com.thoughtworks.xstream.io.xml.DomDriver", new Object[]{null});
        Object xStream_obj = this.classManager.construct("com.thoughtworks.xstream.XStream", new Object[]{dd_obj});
        this.secureXStream(xStream_obj);
        return this.classManager.invoke(xStream_obj, "fromXML", new Object[]{str});
    }

    Object fromJson(String str, Class<?> cl) throws Exception {
        Object gson_obj = this.classManager.construct("com.google.gson.Gson");
        return this.classManager.invoke(gson_obj, "fromJson", new Object[]{str, cl});
    }

    public Object dispatchJson(Class<?> cl) throws Exception {
        String response = this.dispatch(null, "application/json");
        return this.fromJson(response, cl);
    }

    @Override
    public void close() {
    }

    public static void main(String[] args) {
        try {
            System.setProperty("DUCC_HOME", "/users/cwiklik/releases/builds/uima-ducc/2.2.2/target/apache-uima-ducc-2.2.2-SNAPSHOT");
            String[] classpath = new String[]{"apache-uima/apache-activemq/lib/optional/xstream*", "lib/google-gson/gson*"};
            ClassManager classManager = new ClassManager(classpath);
            Class<?> nullPermissionClaz = classManager.loadClass("com.thoughtworks.xstream.security.NullPermission");
            Class<?> primitiveTypePermissionClaz = classManager.loadClass("com.thoughtworks.xstream.security.PrimitiveTypePermission");
            Object dd_obj = classManager.construct("com.thoughtworks.xstream.io.xml.DomDriver", new Object[]{null});
            Object noTypePermissionObject = classManager.construct("com.thoughtworks.xstream.security.NoTypePermission");
            Field noneField = noTypePermissionObject.getClass().getDeclaredField("NONE");
            Object nullPermissionObject = classManager.construct("com.thoughtworks.xstream.security.NullPermission");
            Field nullField = nullPermissionObject.getClass().getDeclaredField("NULL");
            Object primitiveTypePermissionObject = classManager.construct("com.thoughtworks.xstream.security.PrimitiveTypePermission");
            Field primitivesField = primitiveTypePermissionObject.getClass().getDeclaredField("PRIMITIVES");
            Object xStream_obj = classManager.construct("com.thoughtworks.xstream.XStream", new Object[]{dd_obj});
            Class<?> c = classManager.loadClass("com.thoughtworks.xstream.XStream");
            Method m = c.getDeclaredMethod("setupDefaultSecurity", c);
            m.invoke(null, xStream_obj);
            classManager.invoke(xStream_obj, "addPermission", new Object[]{noneField.get(null)});
            classManager.invoke(xStream_obj, "addPermission", new Object[]{nullField.get(null)});
            classManager.invoke(xStream_obj, "addPermission", new Object[]{primitivesField.get(null)});
            classManager.invoke(xStream_obj, "allowTypesByWildcard", new Object[]{new String[]{"org.apache.uima.*"}});
            HashMap<String, String> map = new HashMap<String, String>();
            String s = " Tests";
            map.put("this", s);
            SubmitJobDuccEvent event1 = new SubmitJobDuccEvent(new DuccProperties(), 1);
            String serializaedMsg = (String)classManager.invoke(xStream_obj, "toXML", new Object[]{event1});
            DuccEventHttpDispatcherCl dispatcher = new DuccEventHttpDispatcherCl("http://" + args[0] + ":19988/or", 4000);
            SubmitJobDuccEvent duccEvent = new SubmitJobDuccEvent(null, 1);
            DuccEvent event = dispatcher.dispatchAndWaitForDuccReply(duccEvent);
            if (event instanceof SubmitJobReplyDuccEvent) {
                System.out.println("Client received SubmitJobReplyDuccEvent");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

