/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.transport.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.AbstractDuccEvent;
import org.apache.uima.ducc.transport.event.DuccEvent;
import org.apache.uima.ducc.transport.event.rm.IResource;
import org.apache.uima.ducc.transport.event.rm.IRmJobState;
import org.apache.uima.ducc.transport.event.rm.IRmStateEvent;

public class RmStateDuccEvent
extends AbstractDuccEvent
implements IRmStateEvent {
    private static final long serialVersionUID = -5878153925779939796L;
    Map<DuccId, IRmJobState> rmJobState;

    public RmStateDuccEvent() {
        super(DuccEvent.EventType.RM_STATE);
    }

    public RmStateDuccEvent(Map<DuccId, IRmJobState> rmJobState) {
        super(DuccEvent.EventType.RM_STATE);
        this.rmJobState = rmJobState;
    }

    @Override
    public Map<DuccId, IRmJobState> getJobState() {
        return this.rmJobState;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("\n");
        ArrayList<IRmJobState> jobs = new ArrayList<IRmJobState>();
        jobs.addAll(this.rmJobState.values());
        Collections.sort(jobs, new JobByIdSorter());
        for (IRmJobState j : jobs) {
            Map<DuccId, IResource> existing;
            int counter = 0;
            if (j.isRefused()) {
                buf.append(String.format("%s %s\n\tRefused: %s\n", new Object[]{j.getDuccType(), j.getId().getFriendly(), j.getReason()}));
                continue;
            }
            String reason = j.getReason();
            if (reason.equals("<none>")) {
                reason = "";
            }
            if ((existing = j.getResources()) == null) {
                buf.append(String.format("%s %s %dGB %s\n\tExisting[0]", new Object[]{j.getDuccType(), j.getId().getFriendly(), j.memoryGbPerProcess(), reason}));
            } else {
                buf.append(String.format("%s %s %dGB %s\n\tExisting[%d]: ", new Object[]{j.getDuccType(), j.getId().getFriendly(), j.memoryGbPerProcess(), reason, existing.size()}));
                for (IResource iResource : existing.values()) {
                    buf.append(iResource.toString());
                    buf.append(" ");
                    if (++counter % 10 != 0) continue;
                    buf.append("\n\t");
                }
                buf.append("\n");
            }
            counter = 0;
            Map<DuccId, IResource> additions = j.getPendingAdditions();
            if (additions == null) {
                buf.append(String.format("\tAdditions[0]", new Object[0]));
            } else {
                buf.append(String.format("\tAdditions[%d]: ", additions.size()));
                for (IResource r2 : additions.values()) {
                    buf.append(r2.toString());
                    buf.append(" ");
                    if (++counter % 10 != 0) continue;
                    buf.append("\n\t");
                }
                buf.append("\n");
            }
            counter = 0;
            Map<DuccId, IResource> map = j.getPendingRemovals();
            if (map == null) {
                buf.append(String.format("\tRemovals[0]", new Object[0]));
                continue;
            }
            buf.append(String.format("\tRemovals[%d]: ", map.size()));
            for (IResource r : map.values()) {
                buf.append(r.toString());
                buf.append(" ");
                if (++counter % 10 != 0) continue;
                buf.append("\n\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private static class JobByIdSorter
    implements Comparator<IRmJobState> {
        private JobByIdSorter() {
        }

        @Override
        public int compare(IRmJobState j1, IRmJobState j2) {
            return (int)(j1.getId().getFriendly() - j2.getId().getFriendly());
        }
    }
}

