/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.QueryValidationException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class UnpreparedException
extends QueryValidationException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;

    public UnpreparedException(InetSocketAddress address, String message) {
        super(String.format("A prepared query was submitted on %s but was not known of that node: %s", address, message));
        this.address = address;
    }

    private UnpreparedException(InetSocketAddress address, String message, UnpreparedException cause) {
        super(message, cause);
        this.address = address;
    }

    @Override
    public InetAddress getHost() {
        return this.address != null ? this.address.getAddress() : null;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public UnpreparedException copy() {
        return new UnpreparedException(this.address, this.getMessage(), this);
    }
}

