/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.cli.aio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.cli.aio.AllInOne;
import org.apache.uima.ducc.cli.aio.DDParser;
import org.apache.uima.ducc.common.uima.UimaHelper;
import org.apache.uima.ducc.user.common.QuotedOptions;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.XMLInputSource;

public class CasPipeline {
    public static String cid = CasPipeline.class.getSimpleName();
    protected AllInOne.MsgHandler mh;
    protected Properties properties = new Properties();
    private AnalysisEngineDescription aed = null;
    AnalysisEngine ae = null;
    private CAS cas = null;

    public CasPipeline(Properties properties, AllInOne.MsgHandler mh) {
        this.properties = properties;
        this.mh = mh;
    }

    private ArrayList<String> toArrayList(String overrides) {
        ArrayList list = QuotedOptions.tokenizeList((String)overrides, (boolean)true);
        return list;
    }

    private File getFile(String descriptor) {
        File file;
        String mid = "getFile";
        if (descriptor.endsWith(".xml")) {
            this.mh.frameworkDebug(cid, mid, descriptor);
            file = new File(descriptor);
        } else {
            String relativePath = descriptor.replace('.', '/') + ".xml";
            URL url = this.getClass().getClassLoader().getResource(relativePath);
            if (url == null) {
                throw new IllegalArgumentException(relativePath + " not found in classpath");
            }
            this.mh.frameworkDebug(cid, mid, url.getFile());
            file = new File(url.getFile());
        }
        return file;
    }

    private void initializeByDD() throws Exception {
        String mid = "initializeByDD";
        String dd = this.properties.getProperty(AllInOne.ProcessDD);
        File ddFile = this.getFile(dd);
        DDParser ddParser = new DDParser(ddFile);
        String ddImport = ddParser.getDDImport();
        this.mh.frameworkDebug(cid, mid, ddImport);
        File uimaFile = this.getFile(ddImport);
        XMLInputSource xis = new XMLInputSource(uimaFile);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xis);
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
    }

    private void initializeByParts() throws Exception {
        String ccDescriptor;
        String aeDescriptor;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ArrayList<ArrayList<String>> overrides = new ArrayList<ArrayList<String>>();
        ArrayList<String> descriptors = new ArrayList<String>();
        String cmDescriptor = this.properties.getProperty(AllInOne.ProcessDescriptorCM);
        if (cmDescriptor != null) {
            ArrayList<String> cmOverrides = this.toArrayList(this.properties.getProperty(AllInOne.ProcessDescriptorCMOverrides));
            overrides.add(cmOverrides);
            descriptors.add(cmDescriptor);
        }
        if ((aeDescriptor = this.properties.getProperty(AllInOne.ProcessDescriptorAE)) != null) {
            ArrayList<String> aeOverrides = this.toArrayList(this.properties.getProperty(AllInOne.ProcessDescriptorAEOverrides));
            overrides.add(aeOverrides);
            descriptors.add(aeDescriptor);
        }
        if ((ccDescriptor = this.properties.getProperty(AllInOne.ProcessDescriptorCC)) != null) {
            ArrayList<String> ccOverrides = this.toArrayList(this.properties.getProperty(AllInOne.ProcessDescriptorCCOverrides));
            overrides.add(ccOverrides);
            descriptors.add(ccDescriptor);
        }
        if (descriptors.size() == 3) {
            this.aed = UimaHelper.createAggregateDescription((boolean)false, overrides, (String[])new String[]{(String)descriptors.get(0), (String)descriptors.get(1), (String)descriptors.get(2)});
        } else if (descriptors.size() == 2) {
            this.aed = UimaHelper.createAggregateDescription((boolean)false, overrides, (String[])new String[]{(String)descriptors.get(0), (String)descriptors.get(1)});
        } else if (descriptors.size() == 1) {
            this.aed = UimaHelper.createAggregateDescription((boolean)false, overrides, (String[])new String[]{(String)descriptors.get(0)});
        }
        System.out.println("Created descriptor:");
        this.aed.toXML((OutputStream)System.out);
        System.out.println("");
        this.aed.toXML((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        File file = null;
        XMLInputSource xis = new XMLInputSource((InputStream)bais, file);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xis);
        this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
    }

    public void initialize() throws Exception {
        String dd = this.properties.getProperty(AllInOne.ProcessDD);
        if (dd != null) {
            this.initializeByDD();
        } else {
            this.initializeByParts();
        }
    }

    public CAS process(CAS cas) throws AnalysisEngineProcessException {
        this.ae.process(cas);
        return cas;
    }

    public void destroy() {
        this.ae.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CAS getEmptyCas() throws ResourceInitializationException {
        if (this.cas != null) {
            this.cas.reset();
            return this.cas;
        }
        TypePriorities ae_tp = this.ae.getProcessingResourceMetaData().getTypePriorities();
        TypeSystemDescription ae_tsd = this.ae.getProcessingResourceMetaData().getTypeSystem();
        FsIndexDescription[] ae_fid = this.ae.getProcessingResourceMetaData().getFsIndexes();
        Class<CasCreationUtils> clazz = CasCreationUtils.class;
        synchronized (CasCreationUtils.class) {
            this.cas = CasCreationUtils.createCas((TypeSystemDescription)ae_tsd, (TypePriorities)ae_tp, (FsIndexDescription[])ae_fid);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.cas;
        }
    }

    public void dumpStatistics(PrintStream out) {
        out.println("");
        out.println("+---------------------------+");
        out.println("| UIMA Component Statistics |");
        out.println("+---------------------------+");
        out.println("");
        AnalysisEngineManagement aem = this.ae.getManagementInterface();
        CasPipeline.dumpComponentStatistics(out, 0, aem);
    }

    private static void dumpComponentStatistics(PrintStream out, int level, AnalysisEngineManagement aem) {
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "  ";
        }
        out.println(indent + aem.getName() + ": " + aem.getAnalysisTime() + "ms, ");
        for (AnalysisEngineManagement childAem : aem.getComponents().values()) {
            CasPipeline.dumpComponentStatistics(out, level + 1, childAem);
        }
    }
}

