/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.builders;

import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.apache.uima.ducc.ps.service.IService;
import org.apache.uima.ducc.ps.service.errors.ServiceException;
import org.apache.uima.ducc.ps.service.errors.ServiceInitializationException;
import org.apache.uima.ducc.ps.service.main.Application;
import org.apache.uima.ducc.ps.service.main.PullService;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.UimaServiceProcessor;
import org.apache.uima.ducc.ps.service.registry.IRegistryClient;

public final class PullServiceStepBuilder {
    private static Application app;

    private PullServiceStepBuilder() {
    }

    public static ServiceProcessorStep newBuilder() {
        return PullServiceStepBuilder.newBuilder(null);
    }

    public static ServiceProcessorStep newBuilder(Application application) {
        app = application;
        return new ServiceSteps();
    }

    public static void main(String[] args) {
        int scaleout = 1;
        String analysisEngineDescriptor = args[0];
        UimaServiceProcessor processor = new UimaServiceProcessor(analysisEngineDescriptor);
        IService service = PullServiceStepBuilder.newBuilder().withProcessor(processor).withClientURL("http://localhost:8080/TAS").withType("Note Service").withScaleout(scaleout).withOptionalsDone().build();
        try {
            service.initialize();
            service.start();
        }
        catch (ExecutionException | ServiceException | ServiceInitializationException exception) {
            // empty catch block
        }
    }

    public static interface BuildStep {
        public IService build();
    }

    public static interface OptionalsStep {
        public OptionalsStep withScaleout(int var1);

        public OptionalsStep withType(String var1);

        public OptionalsStep withWaitOnNoTask(int var1);

        public BuildStep withOptionalsDone();
    }

    public static interface RegistryStep {
        public OptionalsStep withRegistry(IRegistryClient var1);

        public OptionalsStep withClientURL(String var1);
    }

    public static interface ServiceProcessorStep {
        public RegistryStep withProcessor(IServiceProcessor var1);
    }

    private static class ServiceSteps
    implements ServiceProcessorStep,
    RegistryStep,
    OptionalsStep,
    BuildStep {
        private IServiceProcessor serviceProcessor;
        private IRegistryClient registryClient;
        private int scaleout = 1;
        private String serviceType;
        private String clientURL;
        private int waitTimeInMillis;

        private ServiceSteps() {
        }

        @Override
        public IService build() {
            PullService service = null;
            service = Objects.nonNull(app) ? new PullService(this.serviceType, app) : new PullService(this.serviceType);
            service.setScaleout(this.scaleout);
            service.setWaitTime(this.waitTimeInMillis);
            if (this.registryClient == null) {
                service.setClientURL(this.clientURL);
            } else {
                service.setRegistryClient(this.registryClient);
            }
            service.setServiceProcessor(this.serviceProcessor);
            return service;
        }

        @Override
        public OptionalsStep withScaleout(int scaleout) {
            this.scaleout = scaleout;
            return this;
        }

        @Override
        public OptionalsStep withType(String type) {
            this.serviceType = type;
            return this;
        }

        @Override
        public OptionalsStep withWaitOnNoTask(int waitTimeInMillis) {
            this.waitTimeInMillis = waitTimeInMillis;
            return this;
        }

        @Override
        public BuildStep withOptionalsDone() {
            return this;
        }

        @Override
        public OptionalsStep withRegistry(IRegistryClient registry) {
            this.registryClient = registry;
            return this;
        }

        @Override
        public OptionalsStep withClientURL(String clientURL) {
            this.clientURL = clientURL;
            return this;
        }

        @Override
        public RegistryStep withProcessor(IServiceProcessor processor) {
            this.serviceProcessor = processor;
            return this;
        }
    }
}

