/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ps.service.processor.uima;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.ducc.ps.service.IServiceState;
import org.apache.uima.ducc.ps.service.ServiceConfiguration;
import org.apache.uima.ducc.ps.service.errors.IServiceErrorHandler;
import org.apache.uima.ducc.ps.service.metrics.builtin.ProcessWindowStats;
import org.apache.uima.ducc.ps.service.monitor.IServiceMonitor;
import org.apache.uima.ducc.ps.service.monitor.builtin.RemoteStateObserver;
import org.apache.uima.ducc.ps.service.processor.IProcessResult;
import org.apache.uima.ducc.ps.service.processor.IServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.IServiceResultSerializer;
import org.apache.uima.ducc.ps.service.processor.uima.AbstractServiceProcessor;
import org.apache.uima.ducc.ps.service.processor.uima.UimaProcessResult;
import org.apache.uima.ducc.ps.service.processor.uima.utils.PerformanceMetrics;
import org.apache.uima.ducc.ps.service.processor.uima.utils.UimaMetricsGenerator;
import org.apache.uima.ducc.ps.service.processor.uima.utils.UimaResultDefaultSerializer;
import org.apache.uima.ducc.ps.service.utils.UimaSerializer;
import org.apache.uima.ducc.ps.service.utils.UimaUtils;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.util.CasPool;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.apache.uima.util.XMLInputSource;

public class UimaServiceProcessor
extends AbstractServiceProcessor
implements IServiceProcessor {
    public static final String IMPORT_BY_NAME_PREFIX = "*importByName:";
    Logger logger = UIMAFramework.getLogger(UimaServiceProcessor.class);
    private IServiceResultSerializer resultSerializer;
    private ThreadLocal<AnalysisEngine> threadLocal = new ThreadLocal();
    private ReentrantLock initStateLock = new ReentrantLock();
    private boolean sendInitializingState = true;
    private ResourceManager rm = UIMAFramework.newDefaultResourceManager();
    private CasPool casPool = null;
    private int scaleout = 1;
    private String analysisEngineDescriptor;
    private AnalysisEngineMetaData analysisEngineMetadata;
    private static Object platformMBeanServer;
    private ServiceConfiguration serviceConfiguration;
    private IServiceMonitor monitor;
    private AtomicInteger numberOfInitializedThreads = new AtomicInteger();
    private IServiceErrorHandler errorHandler;

    public UimaServiceProcessor(String analysisEngineDescriptor) {
        this(analysisEngineDescriptor, new UimaResultDefaultSerializer(), new ServiceConfiguration());
    }

    public UimaServiceProcessor(String analysisEngineDescriptor, ServiceConfiguration serviceConfiguration) {
        this(analysisEngineDescriptor, new UimaResultDefaultSerializer(), serviceConfiguration);
    }

    public UimaServiceProcessor(String analysisEngineDescriptor, IServiceResultSerializer resultSerializer, ServiceConfiguration serviceConfiguration) {
        this.analysisEngineDescriptor = analysisEngineDescriptor;
        this.resultSerializer = resultSerializer;
        this.serviceConfiguration = serviceConfiguration;
        this.launchStateInitializationCollector();
        if (serviceConfiguration.getJpType() != null) {
            this.serializerMap = new HashMap();
        }
        if (serviceConfiguration.getMaxErrors() != null) {
            this.maxErrors = Integer.parseInt(serviceConfiguration.getMaxErrors());
        }
        if (serviceConfiguration.getErrorWindowSize() != null) {
            this.windowSize = Integer.parseInt(serviceConfiguration.getErrorWindowSize());
        }
    }

    @Override
    public void setErrorHandlerWindow(int maxErrors, int windowSize) {
        this.maxErrors = maxErrors;
        this.windowSize = windowSize;
    }

    private void launchStateInitializationCollector() {
        this.monitor = new RemoteStateObserver(this.serviceConfiguration, this.logger);
    }

    @Override
    public void setScaleout(int howManyThreads) {
        this.scaleout = howManyThreads;
    }

    @Override
    public int getScaleout() {
        return this.scaleout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Process Thread:" + Thread.currentThread().getName() + " Initializing AE");
        }
        this.errorHandler = this.getErrorHandler(this.logger);
        try {
            this.initStateLock.lockInterruptibly();
            if (this.sendInitializingState) {
                this.sendInitializingState = false;
                this.monitor.onStateChange(IServiceState.State.Initializing.toString(), new Properties());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.initStateLock.unlock();
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("RESOURCE_MANAGER", this.rm);
        paramsMap.put("MBEAN_SERVER", platformMBeanServer);
        try {
            XMLInputSource is = UimaUtils.getXMLInputSource(this.analysisEngineDescriptor);
            String aed = is.getURL().toString();
            ResourceSpecifier rSpecifier = UimaUtils.getResourceSpecifier(aed);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)rSpecifier, paramsMap);
            this.threadLocal.set(ae);
            Class<UimaServiceProcessor> clazz = UimaServiceProcessor.class;
            synchronized (UimaServiceProcessor.class) {
                if (this.casPool == null) {
                    this.initializeCasPool(ae.getAnalysisEngineMetaData());
                }
                // ** MonitorExit[var6_9] (shouldn't be in output)
                if (this.serviceConfiguration.getJpType() != null) {
                    this.serializerMap.put(Thread.currentThread().getId(), new UimaSerializer());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, null, (Throwable)e);
            this.monitor.onStateChange(IServiceState.State.FailedInitialization.toString(), new Properties());
            throw new RuntimeException(e);
        }
        {
            if (this.logger.isLoggable(Level.INFO)) {
                this.logger.log(Level.INFO, "Process Thread:" + Thread.currentThread().getName() + " Done Initializing AE");
            }
            if (this.numberOfInitializedThreads.incrementAndGet() == this.scaleout) {
                super.delay(this.logger, this.DEFAULT_INIT_DELAY);
                this.monitor.onStateChange(IServiceState.State.Running.toString(), new Properties());
            }
            return;
        }
    }

    private void initializeCasPool(AnalysisEngineMetaData aeMeta) throws ResourceInitializationException {
        Properties props = new Properties();
        props.setProperty("cas_initial_heap_size", "1000");
        this.analysisEngineMetadata = aeMeta;
        this.casPool = new CasPool(this.scaleout, (ProcessingResourceMetaData)this.analysisEngineMetadata, this.rm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessResult process(String serializedTask) {
        AnalysisEngine ae = null;
        CAS cas = this.casPool.getCas();
        try {
            if (this.serviceConfiguration.getJpType() != null) {
                this.getUimaSerializer().deserializeCasFromXmi(serializedTask, cas);
            } else {
                cas.setDocumentText(serializedTask);
                cas.setDocumentLanguage("en");
            }
            ae = this.threadLocal.get();
            List<PerformanceMetrics> beforeAnalysis = UimaMetricsGenerator.get(ae);
            ae.process(cas);
            List<PerformanceMetrics> afterAnalysis = UimaMetricsGenerator.get(ae);
            List<PerformanceMetrics> casMetrics = UimaMetricsGenerator.getDelta(afterAnalysis, beforeAnalysis);
            this.successCount.incrementAndGet();
            this.errorCountSinceLastSuccess.set(0L);
            UimaProcessResult uimaProcessResult = new UimaProcessResult(this.resultSerializer.serialize(casMetrics));
            return uimaProcessResult;
        }
        catch (Exception e) {
            UimaProcessResult result;
            this.logger.log(Level.WARNING, "", (Throwable)e);
            ProcessWindowStats stats = new ProcessWindowStats(this.errorCount.incrementAndGet(), this.successCount.get(), this.errorCountSinceLastSuccess.incrementAndGet());
            IServiceErrorHandler.Action action = this.errorHandler.handleProcessError(e, this, stats);
            UimaProcessResult uimaProcessResult = result = new UimaProcessResult(e, action);
            return uimaProcessResult;
        }
        finally {
            if (cas != null) {
                this.casPool.releaseCas(cas);
            }
        }
    }

    public void setErrorHandler(IServiceErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void stop() {
        this.logger.log(Level.INFO, this.getClass().getName() + " stop() called");
        try {
            AnalysisEngine ae = this.threadLocal.get();
            if (ae != null) {
                ae.destroy();
            }
            super.stop();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "stop", (Throwable)e);
        }
    }

    static {
        try {
            Class<?> managementFactory = Class.forName("java.lang.management.ManagementFactory");
            Method getPlatformMBeanServer = managementFactory.getMethod("getPlatformMBeanServer", new Class[0]);
            platformMBeanServer = getPlatformMBeanServer.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            platformMBeanServer = null;
        }
    }
}

