/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Navigate;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.TimeoutMap;
import org.apache.camel.Traceable;
import org.apache.camel.processor.aggregate.AggregateController;
import org.apache.camel.processor.aggregate.AggregateProcessorStatistics;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.ClosedCorrelationKeyException;
import org.apache.camel.processor.aggregate.CompletionAwareAggregationStrategy;
import org.apache.camel.processor.aggregate.DefaultAggregateController;
import org.apache.camel.processor.aggregate.DelegateAggregationStrategy;
import org.apache.camel.processor.aggregate.MemoryAggregationRepository;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.processor.aggregate.OptimisticLockingAwareAggregationStrategy;
import org.apache.camel.processor.aggregate.PreCompletionAwareAggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.OptimisticLockingAggregationRepository;
import org.apache.camel.spi.RecoverableAggregationRepository;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.ShutdownPrepared;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultTimeoutMap;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable,
ShutdownPrepared,
ShutdownAware,
IdAware {
    public static final String AGGREGATE_TIMEOUT_CHECKER = "AggregateTimeoutChecker";
    private static final Logger LOG = LoggerFactory.getLogger(AggregateProcessor.class);
    private final Lock lock = new ReentrantLock();
    private final AtomicBoolean aggregateRepositoryWarned = new AtomicBoolean();
    private final CamelContext camelContext;
    private final Processor processor;
    private String id;
    private AggregationStrategy aggregationStrategy;
    private boolean preCompletion;
    private Expression correlationExpression;
    private AggregateController aggregateController;
    private final ExecutorService executorService;
    private final boolean shutdownExecutorService;
    private OptimisticLockRetryPolicy optimisticLockRetryPolicy = new OptimisticLockRetryPolicy();
    private ScheduledExecutorService timeoutCheckerExecutorService;
    private boolean shutdownTimeoutCheckerExecutorService;
    private ScheduledExecutorService recoverService;
    private TimeoutMap<String, String> timeoutMap;
    private ExceptionHandler exceptionHandler;
    private AggregationRepository aggregationRepository;
    private Map<String, String> closedCorrelationKeys;
    private final Set<String> batchConsumerCorrelationKeys = new ConcurrentSkipListSet<String>();
    private final Set<String> inProgressCompleteExchanges = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<String, RedeliveryData> redeliveryState = new ConcurrentHashMap<String, RedeliveryData>();
    private final AggregateProcessorStatistics statistics = new Statistics();
    private final AtomicLong totalIn = new AtomicLong();
    private final AtomicLong totalCompleted = new AtomicLong();
    private final AtomicLong completedBySize = new AtomicLong();
    private final AtomicLong completedByStrategy = new AtomicLong();
    private final AtomicLong completedByInterval = new AtomicLong();
    private final AtomicLong completedByTimeout = new AtomicLong();
    private final AtomicLong completedByPredicate = new AtomicLong();
    private final AtomicLong completedByBatchConsumer = new AtomicLong();
    private final AtomicLong completedByForce = new AtomicLong();
    private boolean ignoreInvalidCorrelationKeys;
    private Integer closeCorrelationKeyOnCompletion;
    private boolean parallelProcessing;
    private boolean optimisticLocking;
    private boolean eagerCheckCompletion;
    private Predicate completionPredicate;
    private long completionTimeout;
    private Expression completionTimeoutExpression;
    private long completionInterval;
    private int completionSize;
    private Expression completionSizeExpression;
    private boolean completionFromBatchConsumer;
    private AtomicInteger batchConsumerCounter = new AtomicInteger();
    private boolean discardOnCompletionTimeout;
    private boolean forceCompletionOnStop;
    private boolean completeAllOnStop;
    private ProducerTemplate deadLetterProducerTemplate;

    public AggregateProcessor(CamelContext camelContext, Processor processor, Expression correlationExpression, AggregationStrategy aggregationStrategy, ExecutorService executorService, boolean shutdownExecutorService) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(processor, "processor");
        ObjectHelper.notNull(correlationExpression, "correlationExpression");
        ObjectHelper.notNull(aggregationStrategy, "aggregationStrategy");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.processor = processor;
        this.correlationExpression = correlationExpression;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
        this.exceptionHandler = new LoggingExceptionHandler(camelContext, this.getClass());
    }

    public String toString() {
        return "AggregateProcessor[to: " + this.processor + "]";
    }

    @Override
    public String getTraceLabel() {
        return "aggregate[" + this.correlationExpression + "]";
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        ArrayList<Processor> answer = new ArrayList<Processor>(1);
        answer.add(this.processor);
        return answer;
    }

    @Override
    public boolean hasNext() {
        return this.processor != null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.doProcess(exchange);
        }
        catch (Throwable e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcess(Exchange exchange) throws Exception {
        boolean completeAllGroupsInclusive;
        boolean completeAllGroups;
        if (this.getStatistics().isStatisticsEnabled()) {
            this.totalIn.incrementAndGet();
        }
        if (completeAllGroups = exchange.getIn().getHeader("CamelAggregationCompleteAllGroups", false, Boolean.TYPE).booleanValue()) {
            this.forceCompletionOfAllGroups();
            return;
        }
        String key = this.correlationExpression.evaluate(exchange, String.class);
        if (ObjectHelper.isEmpty(key)) {
            if (this.isIgnoreInvalidCorrelationKeys()) {
                LOG.debug("Invalid correlation key. This Exchange will be ignored: {}", (Object)exchange);
                return;
            }
            throw new CamelExchangeException("Invalid correlation key", exchange);
        }
        if (this.closedCorrelationKeys != null && this.closedCorrelationKeys.containsKey(key)) {
            throw new ClosedCorrelationKeyException(key, exchange);
        }
        if (this.optimisticLocking) {
            List<Exchange> aggregated = null;
            boolean exhaustedRetries = true;
            int attempt = 0;
            while (true) {
                ++attempt;
                Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
                try {
                    aggregated = this.doAggregation(key, copy);
                    exhaustedRetries = false;
                }
                catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                    LOG.trace("On attempt {} OptimisticLockingAggregationRepository: {} threw OptimisticLockingException while trying to add() key: {} and exchange: {}", new Object[]{attempt, this.aggregationRepository, key, copy, e});
                    this.optimisticLockRetryPolicy.doDelay(attempt);
                    if (this.optimisticLockRetryPolicy.shouldRetry(attempt)) continue;
                }
                break;
            }
            if (exhaustedRetries) {
                throw new CamelExchangeException("Exhausted optimistic locking retry attempts, tried " + attempt + " times", exchange, new OptimisticLockingAggregationRepository.OptimisticLockingException());
            }
            if (aggregated != null) {
                for (Exchange agg : aggregated) {
                    this.onSubmitCompletion(key, agg);
                }
            }
        } else {
            Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
            List<Exchange> aggregated = null;
            this.lock.lock();
            try {
                aggregated = this.doAggregation(key, copy);
            }
            finally {
                this.lock.unlock();
            }
            if (aggregated != null) {
                for (Exchange agg : aggregated) {
                    this.onSubmitCompletion(key, agg);
                }
            }
        }
        if (completeAllGroupsInclusive = exchange.getIn().getHeader("CamelAggregationCompleteAllGroupsInclusive", false, Boolean.TYPE).booleanValue()) {
            this.forceCompletionOfAllGroups();
        }
    }

    private List<Exchange> doAggregation(String key, Exchange newExchange) throws CamelExchangeException {
        Exchange answer;
        Exchange originalExchange;
        LOG.trace("onAggregation +++ start +++ with correlation key: {}", (Object)key);
        ArrayList<Exchange> list = new ArrayList<Exchange>();
        String complete = null;
        Exchange oldExchange = originalExchange = this.aggregationRepository.get(newExchange.getContext(), key);
        Integer size = 1;
        if (oldExchange != null) {
            if (this.optimisticLocking && this.aggregationRepository instanceof MemoryAggregationRepository) {
                oldExchange = originalExchange.copy();
            }
            Integer n = size = oldExchange.getProperty("CamelAggregatedSize", 0, Integer.class);
            Integer n2 = size = Integer.valueOf(size + 1);
        }
        ExchangeHelper.prepareAggregation(oldExchange, newExchange);
        if (this.preCompletion) {
            try {
                newExchange.setProperty("CamelAggregatedSize", size);
                complete = this.isPreCompleted(key, oldExchange, newExchange);
                if (complete == null) {
                    this.trackTimeout(key, newExchange);
                }
                newExchange.removeProperty("CamelAggregatedSize");
            }
            catch (Throwable e) {
                throw new CamelExchangeException("Error occurred during preComplete", newExchange, e);
            }
        } else if (this.isEagerCheckCompletion()) {
            newExchange.setProperty("CamelAggregatedSize", size);
            complete = this.isCompleted(key, newExchange);
            if (complete == null) {
                this.trackTimeout(key, newExchange);
            }
            newExchange.removeProperty("CamelAggregatedSize");
        }
        if (this.preCompletion && complete != null) {
            this.doAggregationComplete(complete, list, key, originalExchange, oldExchange);
            complete = null;
            oldExchange = null;
            originalExchange = null;
            size = 1;
            this.trackTimeout(key, newExchange);
        }
        try {
            answer = this.onAggregation(oldExchange, newExchange);
        }
        catch (Throwable e) {
            throw new CamelExchangeException("Error occurred during aggregation", newExchange, e);
        }
        if (answer == null) {
            throw new CamelExchangeException("AggregationStrategy " + this.aggregationStrategy + " returned null which is not allowed", newExchange);
        }
        if (this.aggregationRepository instanceof RecoverableAggregationRepository) {
            boolean valid;
            boolean bl = valid = oldExchange == null || answer.getExchangeId().equals(oldExchange.getExchangeId());
            if (!valid && this.aggregateRepositoryWarned.compareAndSet(false, true)) {
                LOG.warn("AggregationStrategy should return the oldExchange instance instead of the newExchange whenever possible as otherwise this can lead to unexpected behavior with some RecoverableAggregationRepository implementations");
            }
        }
        answer.setProperty("CamelAggregatedSize", size);
        if (!this.preCompletion && !this.isEagerCheckCompletion() && (complete = this.isCompleted(key, answer)) == null) {
            this.trackTimeout(key, newExchange);
        }
        if (complete == null) {
            this.doAggregationRepositoryAdd(newExchange.getContext(), key, originalExchange, answer);
        } else {
            this.doAggregationComplete(complete, list, key, originalExchange, answer);
        }
        LOG.trace("onAggregation +++  end  +++ with correlation key: {}", (Object)key);
        return list;
    }

    protected void doAggregationComplete(String complete, List<Exchange> list, String key, Exchange originalExchange, Exchange answer) {
        if ("consumer".equals(complete)) {
            for (String batchKey : this.batchConsumerCorrelationKeys) {
                Exchange batchAnswer = batchKey.equals(key) ? answer : this.aggregationRepository.get(this.camelContext, batchKey);
                if (batchAnswer == null) continue;
                batchAnswer.setProperty("CamelAggregatedCompletedBy", complete);
                this.onCompletion(batchKey, originalExchange, batchAnswer, false);
                list.add(batchAnswer);
            }
            this.batchConsumerCorrelationKeys.clear();
            answer = null;
        } else if (answer != null) {
            answer.setProperty("CamelAggregatedCompletedBy", complete);
            answer = this.onCompletion(key, originalExchange, answer, false);
        }
        if (answer != null) {
            list.add(answer);
        }
    }

    protected void doAggregationRepositoryAdd(CamelContext camelContext, String key, Exchange oldExchange, Exchange newExchange) {
        LOG.trace("In progress aggregated oldExchange: {}, newExchange: {} with correlation key: {}", new Object[]{oldExchange, newExchange, key});
        if (this.optimisticLocking) {
            try {
                ((OptimisticLockingAggregationRepository)this.aggregationRepository).add(camelContext, key, oldExchange, newExchange);
            }
            catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                this.onOptimisticLockingFailure(oldExchange, newExchange);
                throw e;
            }
        } else {
            this.aggregationRepository.add(camelContext, key, newExchange);
        }
    }

    protected void onOptimisticLockingFailure(Exchange oldExchange, Exchange newExchange) {
        AggregationStrategy strategy = this.aggregationStrategy;
        if (strategy instanceof DelegateAggregationStrategy) {
            strategy = ((DelegateAggregationStrategy)((Object)strategy)).getDelegate();
        }
        if (strategy instanceof OptimisticLockingAwareAggregationStrategy) {
            LOG.trace("onOptimisticLockFailure with AggregationStrategy: {}, oldExchange: {}, newExchange: {}", new Object[]{strategy, oldExchange, newExchange});
            ((OptimisticLockingAwareAggregationStrategy)strategy).onOptimisticLockFailure(oldExchange, newExchange);
        }
    }

    protected String isPreCompleted(String key, Exchange oldExchange, Exchange newExchange) {
        boolean complete = false;
        AggregationStrategy strategy = this.aggregationStrategy;
        if (strategy instanceof DelegateAggregationStrategy) {
            strategy = ((DelegateAggregationStrategy)((Object)strategy)).getDelegate();
        }
        if (strategy instanceof PreCompletionAwareAggregationStrategy) {
            complete = ((PreCompletionAwareAggregationStrategy)strategy).preComplete(oldExchange, newExchange);
        }
        return complete ? "strategy" : null;
    }

    protected String isCompleted(String key, Exchange exchange) {
        int size;
        Integer value;
        boolean answer;
        if (this.isCompletionFromBatchConsumer()) {
            this.batchConsumerCorrelationKeys.add(key);
            this.batchConsumerCounter.incrementAndGet();
            int size2 = exchange.getProperty("CamelBatchSize", 0, Integer.class);
            if (size2 > 0 && this.batchConsumerCounter.intValue() >= size2) {
                this.batchConsumerCounter.set(0);
                return "consumer";
            }
        }
        if (exchange.getProperty("CamelAggregationCompleteCurrentGroup", false, Boolean.TYPE).booleanValue()) {
            return "strategy";
        }
        if (this.getCompletionPredicate() != null && (answer = this.getCompletionPredicate().matches(exchange))) {
            return "predicate";
        }
        boolean sizeChecked = false;
        if (this.getCompletionSizeExpression() != null && (value = this.getCompletionSizeExpression().evaluate(exchange, Integer.class)) != null && value > 0) {
            sizeChecked = true;
            int size3 = exchange.getProperty("CamelAggregatedSize", 1, Integer.class);
            if (size3 >= value) {
                return "size";
            }
        }
        if (!sizeChecked && this.getCompletionSize() > 0 && (size = exchange.getProperty("CamelAggregatedSize", 1, Integer.class).intValue()) >= this.getCompletionSize()) {
            return "size";
        }
        return null;
    }

    protected void trackTimeout(String key, Exchange exchange) {
        Long value;
        boolean timeoutSet = false;
        if (this.getCompletionTimeoutExpression() != null && (value = this.getCompletionTimeoutExpression().evaluate(exchange, Long.class)) != null && value > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, value, exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, value);
            timeoutSet = true;
        }
        if (!timeoutSet && this.getCompletionTimeout() > 0L) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Updating correlation key {} to timeout after {} ms. as exchange received: {}", new Object[]{key, this.getCompletionTimeout(), exchange});
            }
            this.addExchangeToTimeoutMap(key, exchange, this.getCompletionTimeout());
        }
    }

    protected Exchange onAggregation(Exchange oldExchange, Exchange newExchange) {
        return this.aggregationStrategy.aggregate(oldExchange, newExchange);
    }

    protected boolean onPreCompletionAggregation(Exchange oldExchange, Exchange newExchange) {
        AggregationStrategy strategy = this.aggregationStrategy;
        if (strategy instanceof DelegateAggregationStrategy) {
            strategy = ((DelegateAggregationStrategy)((Object)strategy)).getDelegate();
        }
        if (strategy instanceof PreCompletionAwareAggregationStrategy) {
            return ((PreCompletionAwareAggregationStrategy)strategy).preComplete(oldExchange, newExchange);
        }
        return false;
    }

    protected Exchange onCompletion(String key, Exchange original, Exchange aggregated, boolean fromTimeout) {
        Exchange answer;
        if (original != null) {
            original.setProperty("CamelAggregatedCorrelationKey", key);
        }
        aggregated.setProperty("CamelAggregatedCorrelationKey", key);
        if (original != null) {
            this.aggregationRepository.remove(aggregated.getContext(), key, original);
        }
        if (!fromTimeout && this.timeoutMap != null) {
            LOG.trace("Removing correlation key {} from timeout", (Object)key);
            this.timeoutMap.remove(key);
        }
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.put(key, key);
        }
        if (fromTimeout) {
            AggregationStrategy strategy = this.aggregationStrategy;
            if (strategy instanceof DelegateAggregationStrategy) {
                strategy = ((DelegateAggregationStrategy)((Object)strategy)).getDelegate();
            }
            if (strategy instanceof TimeoutAwareAggregationStrategy) {
                long timeout = this.getCompletionTimeout() > 0L ? this.getCompletionTimeout() : -1L;
                ((TimeoutAwareAggregationStrategy)strategy).timeout(aggregated, -1, -1, timeout);
            }
        }
        if (fromTimeout && this.isDiscardOnCompletionTimeout()) {
            LOG.debug("Aggregation for correlation key {} discarding aggregated exchange: {}", (Object)key, (Object)aggregated);
            this.aggregationRepository.confirm(aggregated.getContext(), aggregated.getExchangeId());
            this.redeliveryState.remove(aggregated.getExchangeId());
            answer = null;
        } else {
            answer = aggregated;
        }
        return answer;
    }

    private void onSubmitCompletion(String key, final Exchange exchange) {
        LOG.debug("Aggregation complete for correlation key {} sending aggregated exchange: {}", (Object)key, (Object)exchange);
        this.inProgressCompleteExchanges.add(exchange.getExchangeId());
        AggregationStrategy target = this.aggregationStrategy;
        if (target instanceof DelegateAggregationStrategy) {
            target = ((DelegateAggregationStrategy)((Object)target)).getDelegate();
        }
        if (target instanceof CompletionAwareAggregationStrategy) {
            ((CompletionAwareAggregationStrategy)target).onCompletion(exchange);
        }
        if (this.getStatistics().isStatisticsEnabled()) {
            this.totalCompleted.incrementAndGet();
            String completedBy = exchange.getProperty("CamelAggregatedCompletedBy", String.class);
            if ("interval".equals(completedBy)) {
                this.completedByInterval.incrementAndGet();
            } else if ("timeout".equals(completedBy)) {
                this.completedByTimeout.incrementAndGet();
            } else if ("force".equals(completedBy)) {
                this.completedByForce.incrementAndGet();
            } else if ("consumer".equals(completedBy)) {
                this.completedByBatchConsumer.incrementAndGet();
            } else if ("predicate".equals(completedBy)) {
                this.completedByPredicate.incrementAndGet();
            } else if ("size".equals(completedBy)) {
                this.completedBySize.incrementAndGet();
            } else if ("strategy".equals(completedBy)) {
                this.completedByStrategy.incrementAndGet();
            }
        }
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Processing aggregated exchange: {}", (Object)exchange);
                exchange.addOnCompletion(new AggregateOnCompletion(exchange.getExchangeId()));
                try {
                    AggregateProcessor.this.processor.process(exchange);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                if (exchange.getException() != null) {
                    AggregateProcessor.this.getExceptionHandler().handleException("Error processing aggregated exchange", exchange, exchange.getException());
                } else {
                    LOG.trace("Processing aggregated exchange: {} complete.", (Object)exchange);
                }
            }
        });
    }

    protected void restoreTimeoutMapFromAggregationRepository() throws Exception {
        Set<String> keys = this.aggregationRepository.getKeys();
        if (keys == null || keys.isEmpty()) {
            return;
        }
        StopWatch watch = new StopWatch();
        LOG.trace("Starting restoring CompletionTimeout for {} existing exchanges from the aggregation repository...", (Object)keys.size());
        for (String key : keys) {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            long timeout = exchange.hasProperties() ? exchange.getProperty("CamelAggregatedTimeout", 0, Long.TYPE) : 0L;
            if (timeout <= 0L) continue;
            LOG.trace("Restoring CompletionTimeout for exchangeId: {} with timeout: {} millis.", (Object)exchange.getExchangeId(), (Object)timeout);
            this.addExchangeToTimeoutMap(key, exchange, timeout);
        }
        LOG.info("Restored {} CompletionTimeout conditions in the AggregationTimeoutChecker in {}", (Object)this.timeoutMap.size(), (Object)TimeUtils.printDuration(watch.stop()));
    }

    private void addExchangeToTimeoutMap(String key, Exchange exchange, long timeout) {
        exchange.setProperty("CamelAggregatedTimeout", timeout);
        this.timeoutMap.put(key, exchange.getExchangeId(), timeout);
    }

    public int getClosedCorrelationKeysCacheSize() {
        if (this.closedCorrelationKeys != null) {
            return this.closedCorrelationKeys.size();
        }
        return 0;
    }

    public void clearClosedCorrelationKeysCache() {
        if (this.closedCorrelationKeys != null) {
            this.closedCorrelationKeys.clear();
        }
    }

    public AggregateProcessorStatistics getStatistics() {
        return this.statistics;
    }

    public int getInProgressCompleteExchanges() {
        return this.inProgressCompleteExchanges.size();
    }

    public Predicate getCompletionPredicate() {
        return this.completionPredicate;
    }

    public void setCompletionPredicate(Predicate completionPredicate) {
        this.completionPredicate = completionPredicate;
    }

    public boolean isEagerCheckCompletion() {
        return this.eagerCheckCompletion;
    }

    public void setEagerCheckCompletion(boolean eagerCheckCompletion) {
        this.eagerCheckCompletion = eagerCheckCompletion;
    }

    public long getCompletionTimeout() {
        return this.completionTimeout;
    }

    public void setCompletionTimeout(long completionTimeout) {
        this.completionTimeout = completionTimeout;
    }

    public Expression getCompletionTimeoutExpression() {
        return this.completionTimeoutExpression;
    }

    public void setCompletionTimeoutExpression(Expression completionTimeoutExpression) {
        this.completionTimeoutExpression = completionTimeoutExpression;
    }

    public long getCompletionInterval() {
        return this.completionInterval;
    }

    public void setCompletionInterval(long completionInterval) {
        this.completionInterval = completionInterval;
    }

    public int getCompletionSize() {
        return this.completionSize;
    }

    public void setCompletionSize(int completionSize) {
        this.completionSize = completionSize;
    }

    public Expression getCompletionSizeExpression() {
        return this.completionSizeExpression;
    }

    public void setCompletionSizeExpression(Expression completionSizeExpression) {
        this.completionSizeExpression = completionSizeExpression;
    }

    public boolean isIgnoreInvalidCorrelationKeys() {
        return this.ignoreInvalidCorrelationKeys;
    }

    public void setIgnoreInvalidCorrelationKeys(boolean ignoreInvalidCorrelationKeys) {
        this.ignoreInvalidCorrelationKeys = ignoreInvalidCorrelationKeys;
    }

    public Integer getCloseCorrelationKeyOnCompletion() {
        return this.closeCorrelationKeyOnCompletion;
    }

    public void setCloseCorrelationKeyOnCompletion(Integer closeCorrelationKeyOnCompletion) {
        this.closeCorrelationKeyOnCompletion = closeCorrelationKeyOnCompletion;
    }

    public boolean isCompletionFromBatchConsumer() {
        return this.completionFromBatchConsumer;
    }

    public void setCompletionFromBatchConsumer(boolean completionFromBatchConsumer) {
        this.completionFromBatchConsumer = completionFromBatchConsumer;
    }

    public boolean isCompleteAllOnStop() {
        return this.completeAllOnStop;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(boolean parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public boolean isOptimisticLocking() {
        return this.optimisticLocking;
    }

    public void setOptimisticLocking(boolean optimisticLocking) {
        this.optimisticLocking = optimisticLocking;
    }

    public AggregationRepository getAggregationRepository() {
        return this.aggregationRepository;
    }

    public void setAggregationRepository(AggregationRepository aggregationRepository) {
        this.aggregationRepository = aggregationRepository;
    }

    public boolean isDiscardOnCompletionTimeout() {
        return this.discardOnCompletionTimeout;
    }

    public void setDiscardOnCompletionTimeout(boolean discardOnCompletionTimeout) {
        this.discardOnCompletionTimeout = discardOnCompletionTimeout;
    }

    public void setForceCompletionOnStop(boolean forceCompletionOnStop) {
        this.forceCompletionOnStop = forceCompletionOnStop;
    }

    public void setCompleteAllOnStop(boolean completeAllOnStop) {
        this.completeAllOnStop = completeAllOnStop;
    }

    public void setTimeoutCheckerExecutorService(ScheduledExecutorService timeoutCheckerExecutorService) {
        this.timeoutCheckerExecutorService = timeoutCheckerExecutorService;
    }

    public ScheduledExecutorService getTimeoutCheckerExecutorService() {
        return this.timeoutCheckerExecutorService;
    }

    public boolean isShutdownTimeoutCheckerExecutorService() {
        return this.shutdownTimeoutCheckerExecutorService;
    }

    public void setShutdownTimeoutCheckerExecutorService(boolean shutdownTimeoutCheckerExecutorService) {
        this.shutdownTimeoutCheckerExecutorService = shutdownTimeoutCheckerExecutorService;
    }

    public void setOptimisticLockRetryPolicy(OptimisticLockRetryPolicy optimisticLockRetryPolicy) {
        this.optimisticLockRetryPolicy = optimisticLockRetryPolicy;
    }

    public OptimisticLockRetryPolicy getOptimisticLockRetryPolicy() {
        return this.optimisticLockRetryPolicy;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Expression getCorrelationExpression() {
        return this.correlationExpression;
    }

    public void setCorrelationExpression(Expression correlationExpression) {
        this.correlationExpression = correlationExpression;
    }

    public AggregateController getAggregateController() {
        return this.aggregateController;
    }

    public void setAggregateController(AggregateController aggregateController) {
        this.aggregateController = aggregateController;
    }

    @Override
    protected void doStart() throws Exception {
        RecoverableAggregationRepository recoverable;
        AggregationStrategy strategy = this.aggregationStrategy;
        if (strategy instanceof DelegateAggregationStrategy) {
            strategy = ((DelegateAggregationStrategy)((Object)strategy)).getDelegate();
        }
        if (strategy instanceof PreCompletionAwareAggregationStrategy) {
            this.preCompletion = true;
            LOG.info("PreCompletionAwareAggregationStrategy detected. Aggregator {} is in pre-completion mode.", (Object)this.getId());
        }
        if (!this.preCompletion && this.getCompletionTimeout() <= 0L && this.getCompletionInterval() <= 0L && this.getCompletionSize() <= 0 && this.getCompletionPredicate() == null && !this.isCompletionFromBatchConsumer() && this.getCompletionTimeoutExpression() == null && this.getCompletionSizeExpression() == null) {
            throw new IllegalStateException("At least one of the completions options [completionTimeout, completionInterval, completionSize, completionPredicate, completionFromBatchConsumer] must be set");
        }
        if (this.getCloseCorrelationKeyOnCompletion() != null) {
            if (this.getCloseCorrelationKeyOnCompletion() > 0) {
                LOG.info("Using ClosedCorrelationKeys with a LRUCache with a capacity of " + this.getCloseCorrelationKeyOnCompletion());
                this.closedCorrelationKeys = new LRUCache<String, String>(this.getCloseCorrelationKeyOnCompletion());
            } else {
                LOG.info("Using ClosedCorrelationKeys with unbounded capacity");
                this.closedCorrelationKeys = new ConcurrentHashMap<String, String>();
            }
        }
        if (this.aggregationRepository == null) {
            this.aggregationRepository = new MemoryAggregationRepository(this.optimisticLocking);
            LOG.info("Defaulting to MemoryAggregationRepository");
        }
        if (this.optimisticLocking) {
            if (!(this.aggregationRepository instanceof OptimisticLockingAggregationRepository)) {
                throw new IllegalArgumentException("Optimistic locking cannot be enabled without using an AggregationRepository that implements OptimisticLockingAggregationRepository");
            }
            LOG.info("Optimistic locking is enabled");
        }
        ServiceHelper.startServices(this.aggregationStrategy, this.processor, this.aggregationRepository);
        if (this.aggregationRepository instanceof RecoverableAggregationRepository && (recoverable = (RecoverableAggregationRepository)this.aggregationRepository).isUseRecovery()) {
            long interval = recoverable.getRecoveryIntervalInMillis();
            if (interval <= 0L) {
                throw new IllegalArgumentException("AggregationRepository has recovery enabled and the RecoveryInterval option must be a positive number, was: " + interval);
            }
            this.recoverService = this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, "AggregateRecoverChecker", 1);
            RecoverTask recoverTask = new RecoverTask(recoverable);
            LOG.info("Using RecoverableAggregationRepository by scheduling recover checker to run every " + interval + " millis.");
            this.recoverService.scheduleWithFixedDelay(recoverTask, 1000L, interval, TimeUnit.MILLISECONDS);
            if (recoverable.getDeadLetterUri() != null) {
                int max = recoverable.getMaximumRedeliveries();
                if (max <= 0) {
                    throw new IllegalArgumentException("Option maximumRedeliveries must be a positive number, was: " + max);
                }
                LOG.info("After " + max + " failed redelivery attempts Exchanges will be moved to deadLetterUri: " + recoverable.getDeadLetterUri());
                Endpoint endpoint = this.camelContext.getEndpoint(recoverable.getDeadLetterUri());
                if (endpoint == null) {
                    throw new NoSuchEndpointException(recoverable.getDeadLetterUri());
                }
                this.deadLetterProducerTemplate = this.camelContext.createProducerTemplate();
            }
        }
        if (this.getCompletionInterval() > 0L && this.getCompletionTimeout() > 0L) {
            throw new IllegalArgumentException("Only one of completionInterval or completionTimeout can be used, not both.");
        }
        if (this.getCompletionInterval() > 0L) {
            LOG.info("Using CompletionInterval to run every " + this.getCompletionInterval() + " millis.");
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, AGGREGATE_TIMEOUT_CHECKER, 1));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.getTimeoutCheckerExecutorService().scheduleAtFixedRate(new AggregationIntervalTask(), this.getCompletionInterval(), this.getCompletionInterval(), TimeUnit.MILLISECONDS);
        }
        if (this.getCompletionTimeout() > 0L || this.getCompletionTimeoutExpression() != null) {
            LOG.info("Using CompletionTimeout to trigger after " + this.getCompletionTimeout() + " millis of inactivity.");
            if (this.getTimeoutCheckerExecutorService() == null) {
                this.setTimeoutCheckerExecutorService(this.camelContext.getExecutorServiceManager().newScheduledThreadPool((Object)this, AGGREGATE_TIMEOUT_CHECKER, 1));
                this.shutdownTimeoutCheckerExecutorService = true;
            }
            this.timeoutMap = new AggregationTimeoutMap(this.getTimeoutCheckerExecutorService(), 1000L);
            this.restoreTimeoutMapFromAggregationRepository();
            ServiceHelper.startService(this.timeoutMap);
        }
        if (this.aggregateController == null) {
            this.aggregateController = new DefaultAggregateController();
        }
        this.aggregateController.onStart(this);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.aggregateController != null) {
            this.aggregateController.onStop(this);
        }
        if (this.recoverService != null) {
            this.camelContext.getExecutorServiceManager().shutdown(this.recoverService);
        }
        ServiceHelper.stopServices(this.timeoutMap, this.processor, this.deadLetterProducerTemplate);
        if (this.closedCorrelationKeys != null) {
            ServiceHelper.stopService(this.closedCorrelationKeys);
            this.closedCorrelationKeys.clear();
        }
        this.batchConsumerCorrelationKeys.clear();
        this.redeliveryState.clear();
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        if (!forced && this.forceCompletionOnStop) {
            this.doForceCompletionOnStop();
        }
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        if (this.completeAllOnStop) {
            Set<String> keys = this.getAggregationRepository().getKeys();
            return keys != null ? keys.size() : 0;
        }
        return 0;
    }

    private void doForceCompletionOnStop() {
        int expected = this.forceCompletionOfAllGroups();
        StopWatch watch = new StopWatch();
        while (this.inProgressCompleteExchanges.size() > 0) {
            LOG.trace("Waiting for {} inflight exchanges to complete", (Object)this.getInProgressCompleteExchanges());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for {} inflight exchanges to complete.", (Object)this.getInProgressCompleteExchanges());
                break;
            }
        }
        if (expected > 0) {
            LOG.info("Forcing completion of all groups with {} exchanges completed in {}", (Object)expected, (Object)TimeUtils.printDuration(watch.stop()));
        }
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.aggregationRepository, this.aggregationStrategy);
        this.inProgressCompleteExchanges.clear();
        if (this.shutdownExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        if (this.shutdownTimeoutCheckerExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.timeoutCheckerExecutorService);
            this.timeoutCheckerExecutorService = null;
        }
        super.doShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceCompletionOfGroup(String key) {
        int total = 0;
        if (!this.optimisticLocking) {
            this.lock.lock();
        }
        try {
            Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
            if (exchange != null) {
                total = 1;
                LOG.trace("Force completion triggered for correlation key: {}", (Object)key);
                exchange.setProperty("CamelAggregatedCompletedBy", "force");
                Exchange answer = this.onCompletion(key, exchange, exchange, false);
                if (answer != null) {
                    this.onSubmitCompletion(key, answer);
                }
            }
        }
        finally {
            if (!this.optimisticLocking) {
                this.lock.unlock();
            }
        }
        LOG.trace("Completed force completion of group {}", (Object)key);
        if (total > 0) {
            LOG.debug("Forcing completion of group {} with {} exchanges", (Object)key, (Object)total);
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forceCompletionOfAllGroups() {
        boolean allow;
        boolean bl = allow = this.camelContext.getStatus().isStarted() || this.camelContext.getStatus().isStopping();
        if (!allow) {
            LOG.warn("Cannot start force completion of all groups because CamelContext({}) has not been started", (Object)this.camelContext.getName());
            return 0;
        }
        LOG.trace("Starting force completion of all groups task");
        Set<String> keys = this.aggregationRepository.getKeys();
        int total = 0;
        if (keys != null && !keys.isEmpty()) {
            if (!this.optimisticLocking) {
                this.lock.lock();
            }
            total = keys.size();
            try {
                for (String key : keys) {
                    Exchange exchange = this.aggregationRepository.get(this.camelContext, key);
                    if (exchange == null) continue;
                    LOG.trace("Force completion triggered for correlation key: {}", (Object)key);
                    exchange.setProperty("CamelAggregatedCompletedBy", "force");
                    Exchange answer = this.onCompletion(key, exchange, exchange, false);
                    if (answer == null) continue;
                    this.onSubmitCompletion(key, answer);
                }
            }
            finally {
                if (!this.optimisticLocking) {
                    this.lock.unlock();
                }
            }
        }
        LOG.trace("Completed force completion of all groups task");
        if (total > 0) {
            LOG.debug("Forcing completion of all groups with {} exchanges", (Object)total);
        }
        return total;
    }

    private final class RecoverTask
    implements Runnable {
        private final RecoverableAggregationRepository recoverable;

        private RecoverTask(RecoverableAggregationRepository recoverable) {
            this.recoverable = recoverable;
        }

        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Recover check cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting recover check");
            LinkedHashSet copyOfInProgress = new LinkedHashSet(AggregateProcessor.this.inProgressCompleteExchanges);
            Set<String> exchangeIds = this.recoverable.scan(AggregateProcessor.this.camelContext);
            for (String exchangeId : exchangeIds) {
                boolean inProgress;
                if (!AggregateProcessor.this.isRunAllowed()) {
                    LOG.info("We are shutting down so stop recovering");
                    return;
                }
                boolean bl = inProgress = copyOfInProgress.contains(exchangeId) || AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
                if (inProgress) {
                    LOG.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                    continue;
                }
                LOG.debug("Loading aggregated exchange with id: {} to be recovered.", (Object)exchangeId);
                Exchange exchange = this.recoverable.recover(AggregateProcessor.this.camelContext, exchangeId);
                if (exchange == null) continue;
                String key = exchange.getProperty("CamelAggregatedCorrelationKey", String.class);
                exchange.getIn().setHeader("CamelRedelivered", Boolean.TRUE);
                RedeliveryData data = (RedeliveryData)AggregateProcessor.this.redeliveryState.get(exchange.getExchangeId());
                if (data != null && this.recoverable.getMaximumRedeliveries() > 0 && data.redeliveryCounter >= this.recoverable.getMaximumRedeliveries()) {
                    LOG.warn("The recovered exchange is exhausted after " + this.recoverable.getMaximumRedeliveries() + " attempts, will now be moved to dead letter channel: " + this.recoverable.getDeadLetterUri());
                    try {
                        exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                        exchange.getIn().setHeader("CamelRedeliveryExhausted", Boolean.TRUE);
                        AggregateProcessor.this.deadLetterProducerTemplate.send(this.recoverable.getDeadLetterUri(), exchange);
                    }
                    catch (Throwable e) {
                        exchange.setException(e);
                    }
                    if (exchange.getException() != null) {
                        AggregateProcessor.this.getExceptionHandler().handleException("Failed to move recovered Exchange to dead letter channel: " + this.recoverable.getDeadLetterUri(), exchange.getException());
                        continue;
                    }
                    this.recoverable.confirm(AggregateProcessor.this.camelContext, exchangeId);
                    continue;
                }
                if (data == null) {
                    data = new RedeliveryData();
                    AggregateProcessor.this.redeliveryState.put(exchange.getExchangeId(), data);
                }
                ++data.redeliveryCounter;
                exchange.getIn().setHeader("CamelRedeliveryCounter", data.redeliveryCounter);
                if (this.recoverable.getMaximumRedeliveries() > 0) {
                    exchange.getIn().setHeader("CamelRedeliveryMaxCounter", this.recoverable.getMaximumRedeliveries());
                }
                LOG.debug("Delivery attempt: {} to recover aggregated exchange with id: {}", (Object)data.redeliveryCounter, (Object)exchangeId);
                AggregateProcessor.this.onSubmitCompletion(key, exchange);
            }
            LOG.trace("Recover check complete");
        }
    }

    private final class AggregationIntervalTask
    implements Runnable {
        private AggregationIntervalTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AggregateProcessor.this.camelContext.getStatus().isStarted()) {
                LOG.trace("Completion interval task cannot start due CamelContext({}) has not been started yet", (Object)AggregateProcessor.this.camelContext.getName());
                return;
            }
            LOG.trace("Starting completion interval task");
            Set<String> keys = AggregateProcessor.this.aggregationRepository.getKeys();
            if (keys != null && !keys.isEmpty()) {
                if (!AggregateProcessor.this.optimisticLocking) {
                    AggregateProcessor.this.lock.lock();
                }
                try {
                    for (String key : keys) {
                        boolean stolenInterval = false;
                        Exchange exchange = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
                        if (exchange == null) {
                            stolenInterval = true;
                        } else {
                            LOG.trace("Completion interval triggered for correlation key: {}", (Object)key);
                            exchange.setProperty("CamelAggregatedCompletedBy", "interval");
                            try {
                                Exchange answer = AggregateProcessor.this.onCompletion(key, exchange, exchange, false);
                                if (answer != null) {
                                    AggregateProcessor.this.onSubmitCompletion(key, answer);
                                }
                            }
                            catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                                stolenInterval = true;
                            }
                        }
                        if (!AggregateProcessor.this.optimisticLocking || !stolenInterval) continue;
                        LOG.debug("Another Camel instance has already processed this interval aggregation for exchange with correlation id: {}", (Object)key);
                    }
                }
                finally {
                    if (!AggregateProcessor.this.optimisticLocking) {
                        AggregateProcessor.this.lock.unlock();
                    }
                }
            }
            LOG.trace("Completion interval task complete");
        }
    }

    private final class AggregationTimeoutMap
    extends DefaultTimeoutMap<String, String> {
        private AggregationTimeoutMap(ScheduledExecutorService executor, long requestMapPollTimeMillis) {
            super(executor, requestMapPollTimeMillis, AggregateProcessor.this.optimisticLocking);
        }

        @Override
        public void purge() {
            if (!AggregateProcessor.this.optimisticLocking) {
                AggregateProcessor.this.lock.lock();
            }
            try {
                super.purge();
            }
            finally {
                if (!AggregateProcessor.this.optimisticLocking) {
                    AggregateProcessor.this.lock.unlock();
                }
            }
        }

        @Override
        public boolean onEviction(String key, String exchangeId) {
            this.log.debug("Completion timeout triggered for correlation key: {}", (Object)key);
            boolean inProgress = AggregateProcessor.this.inProgressCompleteExchanges.contains(exchangeId);
            if (inProgress) {
                LOG.trace("Aggregated exchange with id: {} is already in progress.", (Object)exchangeId);
                return true;
            }
            boolean evictionStolen = false;
            Exchange answer = AggregateProcessor.this.aggregationRepository.get(AggregateProcessor.this.camelContext, key);
            if (answer == null) {
                evictionStolen = true;
            } else {
                answer.setProperty("CamelAggregatedCompletedBy", "timeout");
                try {
                    answer = AggregateProcessor.this.onCompletion(key, answer, answer, true);
                    if (answer != null) {
                        AggregateProcessor.this.onSubmitCompletion(key, answer);
                    }
                }
                catch (OptimisticLockingAggregationRepository.OptimisticLockingException e) {
                    evictionStolen = true;
                }
            }
            if (AggregateProcessor.this.optimisticLocking && evictionStolen) {
                LOG.debug("Another Camel instance has already successfully correlated or processed this timeout eviction for exchange with id: {} and correlation id: {}", (Object)exchangeId, (Object)key);
            }
            return true;
        }
    }

    private final class AggregateOnCompletion
    implements Synchronization {
        private final String exchangeId;

        private AggregateOnCompletion(String exchangeId) {
            this.exchangeId = exchangeId;
        }

        @Override
        public void onFailure(Exchange exchange) {
            LOG.trace("Aggregated exchange onFailure: {}", (Object)exchange);
            AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
        }

        @Override
        public void onComplete(Exchange exchange) {
            LOG.trace("Aggregated exchange onComplete: {}", (Object)exchange);
            try {
                AggregateProcessor.this.aggregationRepository.confirm(exchange.getContext(), this.exchangeId);
                AggregateProcessor.this.redeliveryState.remove(this.exchangeId);
            }
            finally {
                AggregateProcessor.this.inProgressCompleteExchanges.remove(this.exchangeId);
            }
        }

        public String toString() {
            return "AggregateOnCompletion";
        }
    }

    private class Statistics
    implements AggregateProcessorStatistics {
        private boolean statisticsEnabled = true;

        private Statistics() {
        }

        @Override
        public long getTotalIn() {
            return AggregateProcessor.this.totalIn.get();
        }

        @Override
        public long getTotalCompleted() {
            return AggregateProcessor.this.totalCompleted.get();
        }

        @Override
        public long getCompletedBySize() {
            return AggregateProcessor.this.completedBySize.get();
        }

        @Override
        public long getCompletedByStrategy() {
            return AggregateProcessor.this.completedByStrategy.get();
        }

        @Override
        public long getCompletedByInterval() {
            return AggregateProcessor.this.completedByInterval.get();
        }

        @Override
        public long getCompletedByTimeout() {
            return AggregateProcessor.this.completedByTimeout.get();
        }

        @Override
        public long getCompletedByPredicate() {
            return AggregateProcessor.this.completedByPredicate.get();
        }

        @Override
        public long getCompletedByBatchConsumer() {
            return AggregateProcessor.this.completedByBatchConsumer.get();
        }

        @Override
        public long getCompletedByForce() {
            return AggregateProcessor.this.completedByForce.get();
        }

        @Override
        public void reset() {
            AggregateProcessor.this.totalIn.set(0L);
            AggregateProcessor.this.totalCompleted.set(0L);
            AggregateProcessor.this.completedBySize.set(0L);
            AggregateProcessor.this.completedByStrategy.set(0L);
            AggregateProcessor.this.completedByTimeout.set(0L);
            AggregateProcessor.this.completedByPredicate.set(0L);
            AggregateProcessor.this.completedByBatchConsumer.set(0L);
            AggregateProcessor.this.completedByForce.set(0L);
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public void setStatisticsEnabled(boolean statisticsEnabled) {
            this.statisticsEnabled = statisticsEnabled;
        }
    }

    private class RedeliveryData {
        int redeliveryCounter;

        private RedeliveryData() {
        }
    }
}

