/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.StringTokenizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class NormalizeSpace
extends SystemFunction {
    public int getIntrinsicDependencies() {
        int n = super.getIntrinsicDependencies();
        if (this.argument.length == 0) {
            n |= 2;
        }
        return n;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        if (this.argument.length == 0 && itemType == null) {
            StaticError staticError = new StaticError("The context item for normalize-space() is undefined");
            staticError.setErrorCode("XPDY0002");
            staticError.setIsTypeError(true);
            staticError.setLocator(this);
            throw staticError;
        }
        return super.typeCheck(staticContext, itemType);
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        if (this.argument.length == 0) {
            return this;
        }
        return Literal.makeLiteral((Value)((Object)this.evaluateItem(staticContext.makeEarlyEvaluationContext())));
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        if (this.argument.length == 0) {
            Item item = xPathContext.getContextItem();
            if (item == null) {
                this.dynamicError("Context item for normalize-space() is undefined", "FONC0001", xPathContext);
            }
            return StringValue.makeStringValue(Whitespace.collapseWhitespace(item.getStringValueCS()));
        }
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        return StringValue.makeStringValue(Whitespace.collapseWhitespace(atomicValue.getStringValueCS()));
    }

    public static CharSequence normalize(CharSequence charSequence) {
        if (Whitespace.containsWhitespace(charSequence)) {
            StringTokenizer stringTokenizer = new StringTokenizer(((Object)charSequence).toString());
            if (stringTokenizer.hasMoreTokens()) {
                FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
                while (true) {
                    fastStringBuffer.append(stringTokenizer.nextToken());
                    if (!stringTokenizer.hasMoreTokens()) break;
                    fastStringBuffer.append(' ');
                }
                return fastStringBuffer.condense();
            }
            return "";
        }
        return charSequence;
    }
}

