/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;

public class WorkMapHelper {
    private static final DuccLogger logger = DuccLogger.getLogger(WorkMapHelper.class);
    private static DuccId jobid = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDuccWork(DuccWorkMap workMap, IDuccWork dw, Object object, String methodName) {
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            workMap.addDuccWork(dw);
        }
        ts.ended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDuccWork(DuccWorkMap workMap, IDuccWork dw, Object object, String methodName) {
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccId duccId = dw.getDuccId();
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            workMap.removeDuccWork(duccId);
        }
        ts.ended();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDuccWork cloneDuccWork(DuccWorkMap workMap, String duccId, Object object, String methodName) {
        String location = "cloneDuccWork";
        IDuccWork dwClone = null;
        logger.trace(location, jobid, new Object[]{"enter", duccId});
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            IDuccWork dw = workMap.findDuccWork(duccId);
            if (dw != null) {
                dwClone = (IDuccWork)SerializationUtils.clone((Serializable)dw);
            } else {
                StringBuffer sb = new StringBuffer();
                DuccId id = new DuccId(Long.parseLong(duccId));
                sb.append("jobs:" + workMap.getJobKeySet().size());
                sb.append(" ");
                sb.append("reservations:" + workMap.getReservationKeySet().size());
                sb.append(" ");
                sb.append("managedReservations:" + workMap.getManagedReservationKeySet().size());
                sb.append(" ");
                sb.append("services:" + workMap.getServiceKeySet().size());
                logger.warn(location, id, new Object[]{sb.toString()});
            }
        }
        ts.ended();
        logger.trace(location, jobid, new Object[]{"exit", duccId, dwClone});
        return dwClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDuccWork findDuccWork(DuccWorkMap workMap, String duccId, Object object, String methodName) {
        IDuccWork dw = null;
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            dw = workMap.findDuccWork(duccId);
        }
        ts.ended();
        return dw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDuccWork findDuccWork(DuccWorkMap workMap, DuccId duccId, Object object, String methodName) {
        IDuccWork dw = null;
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            dw = workMap.findDuccWork(duccId);
        }
        ts.ended();
        return dw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IDuccWork findDuccWork(DuccWorkMap workMap, IDuccTypes.DuccType duccType, String id, Object object, String methodName) {
        IDuccWork dw = null;
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            dw = workMap.findDuccWork(duccType, id);
        }
        ts.ended();
        return dw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DuccWorkMap deepCopy(DuccWorkMap workMap, Object object, String methodName) {
        DuccWorkMap workMapCopy = null;
        TrackSync ts = TrackSync.await(workMap, object.getClass(), methodName);
        DuccWorkMap duccWorkMap = workMap;
        synchronized (duccWorkMap) {
            ts.using();
            workMapCopy = workMap.deepCopy();
        }
        ts.ended();
        return workMapCopy;
    }
}

