/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.ckpt;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.ckpt.AOrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.ckpt.IOrchestratorCheckpoint;
import org.apache.uima.ducc.orchestrator.utilities.Checkpointable;
import org.apache.uima.ducc.orchestrator.utilities.TrackSync;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.history.HistoryFactory;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class OrchestratorCheckpointDb
extends AOrchestratorCheckpoint
implements IOrchestratorCheckpoint {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorCheckpointDb.class);
    private static DuccId jobid = null;
    private static String saveLocation = "db";

    protected OrchestratorCheckpointDb() {
        IOHelper.mkdirs((String)orchestratorCommonArea.getStateDirectory());
        this.ckptOnOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveState() {
        String location = "saveState";
        IHistoryPersistenceManager saver = HistoryFactory.getInstance((String)this.getClass().getName());
        logger.trace(location, jobid, new Object[]{messages.fetch("enter")});
        boolean retVal = false;
        if (this.isCkptEnabled()) {
            DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
            TrackSync ts = TrackSync.await(workMap, this.getClass(), location);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                try {
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("saving to ") + saveLocation});
                    Checkpointable checkpointable = orchestratorCommonArea.getCheckpointable();
                    retVal = saver.checkpoint(checkpointable.getWorkMap(), checkpointable.getProcessToJobMap());
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("saved ") + saveLocation});
                }
                catch (Exception e) {
                    logger.error(location, jobid, (Throwable)e, new Object[0]);
                }
            }
            ts.ended();
        } else {
            logger.debug(location, jobid, new Object[]{messages.fetchLabel("bypass saving to ") + saveLocation});
        }
        logger.trace(location, jobid, new Object[]{messages.fetch("exit")});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreState() {
        String location = "restoreState";
        logger.trace(location, jobid, new Object[]{messages.fetch("enter")});
        IHistoryPersistenceManager saver = HistoryFactory.getInstance((String)this.getClass().getName());
        boolean retVal = false;
        if (this.isCkptEnabled()) {
            DuccWorkMap workMap = orchestratorCommonArea.getWorkMap();
            TrackSync ts = TrackSync.await(workMap, this.getClass(), location);
            DuccWorkMap duccWorkMap = workMap;
            synchronized (duccWorkMap) {
                ts.using();
                try {
                    logger.info(location, jobid, new Object[]{messages.fetchLabel("restoring from ") + saveLocation});
                    Pair ret = saver.restore();
                    if (ret.first() != null) {
                        Checkpointable checkpointable = new Checkpointable((DuccWorkMap)ret.first(), (ConcurrentHashMap)ret.second());
                        orchestratorCommonArea.setCheckpointable(checkpointable);
                        logger.info(location, null, new Object[]{messages.fetch("restored")});
                    } else {
                        logger.info(location, null, new Object[]{"No checkpoint found."});
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error(location, null, (Throwable)e, new Object[0]);
                }
                catch (Exception e) {
                    logger.warn(location, null, (Throwable)e, new Object[0]);
                }
            }
            ts.ended();
        } else {
            logger.info(location, null, new Object[]{messages.fetchLabel("bypass restoring from ") + saveLocation});
        }
        logger.trace(location, null, new Object[]{messages.fetch("exit")});
        return retVal;
    }
}

