/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.config;

import org.apache.camel.Body;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.jetty9.JettyHttpComponent9;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.uima.ducc.common.config.CommonConfiguration;
import org.apache.uima.ducc.common.config.DuccBlastGuardPredicate;
import org.apache.uima.ducc.common.exception.DuccRuntimeException;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IDuccLoggerComponents;
import org.apache.uima.ducc.common.utils.XStreamUtils;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.Orchestrator;
import org.apache.uima.ducc.orchestrator.OrchestratorComponent;
import org.apache.uima.ducc.orchestrator.event.OrchestratorEventListener;
import org.apache.uima.ducc.orchestrator.state.IOrchestratorState;
import org.apache.uima.ducc.orchestrator.state.OrchestratorState;
import org.apache.uima.ducc.orchestrator.system.events.log.SystemEventsLogger;
import org.apache.uima.ducc.transport.DuccTransportConfiguration;
import org.apache.uima.ducc.transport.event.AServiceRequest;
import org.apache.uima.ducc.transport.event.CancelJobDuccEvent;
import org.apache.uima.ducc.transport.event.CancelJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationDuccEvent;
import org.apache.uima.ducc.transport.event.CancelReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceDuccEvent;
import org.apache.uima.ducc.transport.event.CancelServiceReplyDuccEvent;
import org.apache.uima.ducc.transport.event.DuccWorkReplyEvent;
import org.apache.uima.ducc.transport.event.DuccWorkRequestEvent;
import org.apache.uima.ducc.transport.event.JdReplyEvent;
import org.apache.uima.ducc.transport.event.JdRequestEvent;
import org.apache.uima.ducc.transport.event.OrchestratorStateDuccEvent;
import org.apache.uima.ducc.transport.event.ServiceReplyEvent;
import org.apache.uima.ducc.transport.event.SubmitJobDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitJobReplyDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitReservationReplyDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceDuccEvent;
import org.apache.uima.ducc.transport.event.SubmitServiceReplyDuccEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={DuccTransportConfiguration.class, CommonConfiguration.class})
public class OrchestratorConfiguration {
    @Autowired
    CommonConfiguration common;
    @Autowired
    DuccTransportConfiguration orchestratorTransport;
    private DuccLogger duccLogger = DuccLogger.getLogger(OrchestratorConfiguration.class);
    private DuccId jobid = null;

    public RouteBuilder routeBuilderForEndpoint(final String endpoint, final OrchestratorEventListener delegate) {
        return new RouteBuilder(){

            public void configure() {
                this.from(endpoint).bean((Object)delegate);
            }
        };
    }

    private RouteBuilder routeBuilder(final CamelContext context, final OrchestratorEventListener delegate) throws Exception {
        return new RouteBuilder(){

            public void configure() {
                JettyHttpComponent9 jettyComponent = new JettyHttpComponent9();
                context.addComponent("jetty", (Component)jettyComponent);
                this.onException(Throwable.class).maximumRedeliveries(0).handled(false).process((Processor)new ErrorProcessor());
                ((RouteDefinition)((RouteDefinition)this.from("jetty://http://0.0.0.0:" + OrchestratorConfiguration.this.common.duccORHttpPort + "?matchOnUriPrefix=true").unmarshal().xstream().bean((Object)delegate)).process((Processor)new OrchestratorReplyProcessor())).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getOut().setHeader("CamelHttpResponseCode", (Object)200);
                        exchange.getOut().setHeader("content-type", (Object)"text/xml");
                        Object o = exchange.getIn().getBody();
                        if (o != null) {
                            String body = XStreamUtils.marshall((Object)o);
                            exchange.getOut().setBody((Object)body);
                            exchange.getOut().setHeader("content-length", (Object)body.length());
                        } else {
                            OrchestratorConfiguration.this.duccLogger.warn("RouteBuilder.configure", null, (Throwable)new DuccRuntimeException("Orchestrator Has Not Provided a Reply Object."), new Object[0]);
                            exchange.getOut().setHeader("CamelHttpResponseCode", (Object)500);
                        }
                    }
                });
            }
        };
    }

    private RouteBuilder routeBuilderForOrchestratorStatePost(Orchestrator orchestrator, final String targetEndpointToReceiveOrchestratorStateUpdate, final int statePublishRate) throws Exception {
        final OrchestratorStateProcessor orchestratorp = new OrchestratorStateProcessor(orchestrator);
        return new RouteBuilder(){

            public void configure() {
                DuccBlastGuardPredicate blastFilter = new DuccBlastGuardPredicate(OrchestratorConfiguration.this.duccLogger);
                ((ExpressionNode)this.from("timer:orchestratorStateDumpTimer?fixedRate=true&period=" + statePublishRate).filter((Predicate)blastFilter).process((Processor)orchestratorp)).to(targetEndpointToReceiveOrchestratorStateUpdate);
            }
        };
    }

    public OrchestratorEventListener orchestratorDelegateListener(OrchestratorComponent orchestrator) {
        OrchestratorEventListener orchestratorel = new OrchestratorEventListener(orchestrator);
        return orchestratorel;
    }

    @Bean
    public OrchestratorComponent orchestrator() throws Exception {
        OrchestratorComponent orchestrator = new OrchestratorComponent(this.common.camelContext());
        OrchestratorEventListener delegateListener = this.orchestratorDelegateListener(orchestrator);
        delegateListener.initSmChannel(this.common.camelContext(), this.common.smApiEndpoint);
        delegateListener.setDuccEventDispatcher(this.orchestratorTransport.duccEventDispatcher(this.common.pmRequestEndpoint, orchestrator.getContext()));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilder(orchestrator.getContext(), delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.daemonsStateChangeEndpoint, delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.rmStateUpdateEndpoint, delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.smStateUpdateEndpoint, delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.jdStateUpdateEndpoint, delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForEndpoint(this.common.nodeInventoryEndpoint, delegateListener));
        orchestrator.getContext().addRoutes((RoutesBuilder)this.routeBuilderForOrchestratorStatePost(orchestrator, this.common.orchestratorStateUpdateEndpoint, Integer.parseInt(this.common.orchestratorStatePublishRate)));
        return orchestrator;
    }

    public class ServiceRequestHandler {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleRequest(@Body SubmitJobDuccEvent jobSubmit) throws Exception {
            System.out.println("ServiceRequestHandler Received Request of type: " + jobSubmit.getClass().getName());
            ServiceRequestHandler serviceRequestHandler = this;
            synchronized (serviceRequestHandler) {
                this.wait(2000L);
            }
        }
    }

    public class ErrorProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
            OrchestratorConfiguration.this.duccLogger.error("ErrorProcessor.process", null, caused, new Object[0]);
            exchange.getOut().setBody((Object)caused);
        }
    }

    private class OrchestratorStateProcessor
    implements Processor {
        private Orchestrator orchestrator;

        private OrchestratorStateProcessor(Orchestrator orchestrator) {
            this.orchestrator = orchestrator;
        }

        public void process(Exchange exchange) throws Exception {
            String location = "OrchestratorStateProcessor.process";
            OrchestratorStateDuccEvent jse = this.orchestrator.getState();
            IOrchestratorState orchestratorState = OrchestratorState.getInstance();
            long seqNo = orchestratorState.getNextPublicationSequenceNumber();
            OrchestratorConfiguration.this.duccLogger.debug(location, OrchestratorConfiguration.this.jobid, new Object[]{"" + seqNo});
            jse.setSequence(seqNo);
            exchange.getIn().setBody((Object)jse);
        }
    }

    private class OrchestratorReplyProcessor
    implements Processor {
        private OrchestratorReplyProcessor() {
        }

        public void process(Exchange exchange) throws Exception {
            SubmitServiceReplyDuccEvent replyServiceEvent;
            SubmitReservationReplyDuccEvent replyReservationEvent;
            SubmitJobReplyDuccEvent replyJobEvent;
            Object obj = exchange.getIn().getBody();
            if (obj instanceof JdRequestEvent) {
                JdRequestEvent jdRequestEvent = (JdRequestEvent)exchange.getIn().getBody(JdRequestEvent.class);
                JdReplyEvent jdReplyEvent = new JdReplyEvent();
                jdReplyEvent.setProcessMap(jdRequestEvent.getProcessMap());
                String killDriverReason = jdRequestEvent.getKillDriverReason();
                jdReplyEvent.setKillDriverReason(killDriverReason);
                exchange.getIn().setBody((Object)jdReplyEvent);
            }
            if (obj instanceof DuccWorkRequestEvent) {
                DuccWorkRequestEvent duccWorkRequestEvent = (DuccWorkRequestEvent)exchange.getIn().getBody(DuccWorkRequestEvent.class);
                DuccWorkReplyEvent duccWorkReplyEvent = new DuccWorkReplyEvent();
                duccWorkReplyEvent.setDw(duccWorkRequestEvent.getDw());
                exchange.getIn().setBody((Object)duccWorkReplyEvent);
            }
            if (obj instanceof SubmitJobDuccEvent) {
                SubmitJobDuccEvent submitJobEvent = (SubmitJobDuccEvent)exchange.getIn().getBody(SubmitJobDuccEvent.class);
                replyJobEvent = new SubmitJobReplyDuccEvent();
                replyJobEvent.setProperties(submitJobEvent.getProperties());
                exchange.getIn().setBody((Object)replyJobEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, submitJobEvent, replyJobEvent);
            }
            if (obj instanceof CancelJobDuccEvent) {
                CancelJobDuccEvent cancelJobEvent = (CancelJobDuccEvent)exchange.getIn().getBody(CancelJobDuccEvent.class);
                replyJobEvent = new CancelJobReplyDuccEvent();
                replyJobEvent.setProperties(cancelJobEvent.getProperties());
                exchange.getIn().setBody((Object)replyJobEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, cancelJobEvent, (CancelJobReplyDuccEvent)replyJobEvent);
            }
            if (obj instanceof SubmitReservationDuccEvent) {
                SubmitReservationDuccEvent submitReservationEvent = (SubmitReservationDuccEvent)exchange.getIn().getBody(SubmitReservationDuccEvent.class);
                replyReservationEvent = new SubmitReservationReplyDuccEvent();
                replyReservationEvent.setProperties(submitReservationEvent.getProperties());
                exchange.getIn().setBody((Object)replyReservationEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, submitReservationEvent, replyReservationEvent);
            }
            if (obj instanceof CancelReservationDuccEvent) {
                CancelReservationDuccEvent cancelReservationEvent = (CancelReservationDuccEvent)exchange.getIn().getBody(CancelReservationDuccEvent.class);
                replyReservationEvent = new CancelReservationReplyDuccEvent();
                replyReservationEvent.setProperties(cancelReservationEvent.getProperties());
                exchange.getIn().setBody((Object)replyReservationEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, cancelReservationEvent, (CancelReservationReplyDuccEvent)replyReservationEvent);
            }
            if (obj instanceof SubmitServiceDuccEvent) {
                SubmitServiceDuccEvent submitServiceEvent = (SubmitServiceDuccEvent)exchange.getIn().getBody(SubmitServiceDuccEvent.class);
                replyServiceEvent = new SubmitServiceReplyDuccEvent();
                replyServiceEvent.setProperties(submitServiceEvent.getProperties());
                exchange.getIn().setBody((Object)replyServiceEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, submitServiceEvent, replyServiceEvent);
            }
            if (obj instanceof CancelServiceDuccEvent) {
                CancelServiceDuccEvent cancelServiceEvent = (CancelServiceDuccEvent)exchange.getIn().getBody(CancelServiceDuccEvent.class);
                replyServiceEvent = new CancelServiceReplyDuccEvent();
                replyServiceEvent.setProperties(cancelServiceEvent.getProperties());
                exchange.getIn().setBody((Object)replyServiceEvent);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_orchestrator, cancelServiceEvent, (CancelServiceReplyDuccEvent)replyServiceEvent);
            }
            if (obj instanceof AServiceRequest) {
                AServiceRequest serviceRequest = (AServiceRequest)exchange.getIn().getBody(AServiceRequest.class);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_servicesManager, serviceRequest);
                ServiceReplyEvent serviceReply = serviceRequest.getReply();
                exchange.getIn().setBody((Object)serviceReply);
                SystemEventsLogger.info(IDuccLoggerComponents.abbrv_servicesManager, serviceRequest, serviceReply);
            }
        }
    }
}

