/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.state;

import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.database.OrDbOrchestratorProperties;
import org.apache.uima.ducc.orchestrator.state.IOrchestratorState;
import org.apache.uima.ducc.orchestrator.state.OrchestratorStateDbConversion;

public class OrchestratorStateDb
implements IOrchestratorState {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorStateDb.class);
    private static DuccId jobid = null;
    private OrDbOrchestratorProperties orDbOrchestratorProperties = OrDbOrchestratorProperties.getInstance();
    private static OrchestratorStateDb instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IOrchestratorState getInstance() {
        String location = "getInstance";
        Class<OrchestratorStateDb> clazz = OrchestratorStateDb.class;
        synchronized (OrchestratorStateDb.class) {
            logger.debug(location, jobid, new Object[]{"" + instance});
            if (instance == null) {
                instance = new OrchestratorStateDb();
                instance.initialize();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void initialize() {
        OrchestratorStateDbConversion.convert();
    }

    private long getNextSequenceNumberState() {
        return this.orDbOrchestratorProperties.getNextPublicationSeqNo();
    }

    @Override
    public long getNextPublicationSequenceNumber() {
        return this.getNextSequenceNumberState();
    }

    private void setNextSequenceNumberState(long value) {
        this.orDbOrchestratorProperties.setPublicationSeqNo(value);
    }

    @Override
    public void setNextPublicationSequenceNumber(long seqNo) {
        this.setNextSequenceNumberState(seqNo);
    }

    private void setNextSequenceNumberStateIfGreater(NodeIdentity nodeIdentity, long value) {
        this.orDbOrchestratorProperties.setPublicationSeqNoIfLarger(value);
    }

    @Override
    public void setNextPublicationSequenceNumberIfGreater(long value, NodeIdentity nodeIdentity) {
        this.setNextSequenceNumberStateIfGreater(nodeIdentity, value);
    }

    @Override
    public long getNextDuccWorkSequenceNumber() {
        long prev = this.orDbOrchestratorProperties.getDuccWorkSeqNo();
        long next = prev + 1L;
        this.orDbOrchestratorProperties.setDuccWorkSeqNo(next);
        return next;
    }

    @Override
    public long getDuccWorkSequenceNumber() {
        long prev = this.orDbOrchestratorProperties.getDuccWorkSeqNo();
        return prev;
    }

    @Override
    public void setDuccWorkSequenceNumber(long seqNo) {
        this.orDbOrchestratorProperties.setDuccWorkSeqNo(seqNo);
    }

    @Override
    public void setDuccWorkSequenceNumberIfGreater(long seqNo) {
        this.orDbOrchestratorProperties.setDuccWorkSeqNoIfLarger(seqNo);
    }
}

