/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.orchestrator.state;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Properties;
import org.apache.uima.ducc.common.db.DbHelper;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.orchestrator.OrchestratorCommonArea;
import org.apache.uima.ducc.orchestrator.state.IOrchestratorState;
import org.apache.uima.ducc.orchestrator.state.OrchestratorStateDb;
import org.apache.uima.ducc.orchestrator.state.OrchestratorStateJson;

public class OrchestratorStateDbConversion {
    private static DuccLogger logger = DuccLogger.getLogger(OrchestratorStateDbConversion.class);
    private static DuccId jobid = null;
    private static OrchestratorCommonArea orchestratorCommonArea = OrchestratorCommonArea.getInstance();
    private static String jsonFileName = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator-state.json";
    private static String propertiesFileName = orchestratorCommonArea.getStateDirectory() + File.separator + "orchestrator.properties";
    private static final String constSeqNo = "seqno";
    private static Gson gson = new Gson();
    private static IOrchestratorState orchestratorStateDb = OrchestratorStateDb.getInstance();

    public static void convert() {
        if (OrchestratorStateDbConversion.isDbEnabled()) {
            OrchestratorStateDbConversion.jsonConvert();
            OrchestratorStateDbConversion.propertiesConvert();
        }
    }

    private static void jsonConvert() {
        String location = "jsonConvert";
        try {
            if (OrchestratorStateDbConversion.jsonFileExists()) {
                long seqNo = OrchestratorStateDbConversion.getPublishSeqNoFromFile();
                if (seqNo > 0L) {
                    OrchestratorStateDbConversion.setPublishSeqNoInDb(seqNo);
                }
                OrchestratorStateDbConversion.jsonEraseFile();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static void propertiesConvert() {
        String location = "propertiesConvert";
        try {
            if (OrchestratorStateDbConversion.propertiesFileExists()) {
                long seqNo = OrchestratorStateDbConversion.getDuccWorkSeqNoFromFile();
                if (seqNo > 0L) {
                    OrchestratorStateDbConversion.setDuccWorkSeqNoInDb(seqNo);
                }
                OrchestratorStateDbConversion.propertiesEraseFile();
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private static boolean isDbDisabled() {
        String location = "isDbDisabled";
        boolean retVal = DbHelper.isDbDisabled();
        logger.info(location, jobid, new Object[]{retVal});
        return retVal;
    }

    private static boolean isDbEnabled() {
        return !OrchestratorStateDbConversion.isDbDisabled();
    }

    private static boolean jsonFileExists() {
        String location = "jsonFileExists";
        File file = new File(jsonFileName);
        boolean retVal = file.exists();
        logger.info(location, jobid, new Object[]{jsonFileName, retVal});
        return retVal;
    }

    private static boolean jsonEraseFile() {
        String location = "jsonEraseFile";
        File file = new File(jsonFileName);
        boolean retVal = file.delete();
        logger.info(location, jobid, new Object[]{jsonFileName, retVal});
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPublishSeqNoFromFile() throws Exception {
        String location = "getPublishSeqNoFromFile";
        long retVal = -1L;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(jsonFileName);
            br = new BufferedReader(fr);
            Type typeOfMap = new TypeToken<OrchestratorStateJson>(){}.getType();
            OrchestratorStateJson importedState = (OrchestratorStateJson)gson.fromJson((Reader)br, typeOfMap);
            retVal = importedState.getSequenceNumberState();
            br.close();
            fr.close();
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (fr != null) {
                fr.close();
            }
        }
        logger.info(location, jobid, new Object[]{retVal});
        return retVal;
    }

    private static void setPublishSeqNoInDb(long value) {
        String location = "setPublishSeqNoInDb";
        orchestratorStateDb.setNextPublicationSequenceNumber(value);
        logger.info(location, jobid, new Object[]{value});
    }

    private static boolean propertiesFileExists() {
        String location = "propertiesFileExists";
        File file = new File(propertiesFileName);
        boolean retVal = file.exists();
        logger.info(location, jobid, new Object[]{propertiesFileName, retVal});
        return retVal;
    }

    private static boolean propertiesEraseFile() {
        String location = "propertiesEraseFile";
        File file = new File(propertiesFileName);
        boolean retVal = file.delete();
        logger.info(location, jobid, new Object[]{propertiesFileName, retVal});
        return retVal;
    }

    private static long getDuccWorkSeqNoFromFile() throws Exception {
        String location = "getDuccWorkSeqNoFromFile";
        long retVal = 0L;
        try {
            Properties properties = new Properties();
            FileInputStream fis = new FileInputStream(propertiesFileName);
            properties.load(fis);
            fis.close();
            String key = constSeqNo;
            String value = properties.getProperty(key);
            retVal = Long.parseLong(value);
        }
        catch (Exception e) {
            logger.error(location, jobid, (Throwable)e, new Object[0]);
        }
        logger.info(location, jobid, new Object[]{retVal});
        return retVal;
    }

    private static void setDuccWorkSeqNoInDb(long value) {
        String location = "setDuccWorkSeqNoInDb";
        orchestratorStateDb.setDuccWorkSequenceNumber(value);
        logger.info(location, jobid, new Object[]{value});
    }
}

