/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.HashSet;
import java.util.Set;
import org.apache.mina.common.BufferDataException;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.PooledByteBufferAllocator;
import org.apache.mina.common.support.ByteBufferHexDumper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuffer
implements Comparable<ByteBuffer> {
    private static ByteBufferAllocator allocator = new PooledByteBufferAllocator();
    private static boolean useDirectBuffers = true;
    private static final Set<String> primitiveTypeNames = new HashSet<String>();

    public static ByteBufferAllocator getAllocator() {
        return allocator;
    }

    public static void setAllocator(ByteBufferAllocator newAllocator) {
        if (newAllocator == null) {
            throw new NullPointerException("allocator");
        }
        ByteBufferAllocator oldAllocator = allocator;
        allocator = newAllocator;
        if (null != oldAllocator) {
            oldAllocator.dispose();
        }
    }

    public static boolean isUseDirectBuffers() {
        return useDirectBuffers;
    }

    public static void setUseDirectBuffers(boolean useDirectBuffers) {
        ByteBuffer.useDirectBuffers = useDirectBuffers;
    }

    public static ByteBuffer allocate(int capacity) {
        if (useDirectBuffers) {
            try {
                return ByteBuffer.allocate(capacity, true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return ByteBuffer.allocate(capacity, false);
    }

    public static ByteBuffer allocate(int capacity, boolean direct) {
        return allocator.allocate(capacity, direct);
    }

    public static ByteBuffer wrap(java.nio.ByteBuffer nioBuffer) {
        return allocator.wrap(nioBuffer);
    }

    public static ByteBuffer wrap(byte[] byteArray) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray));
    }

    public static ByteBuffer wrap(byte[] byteArray, int offset, int length) {
        return ByteBuffer.wrap(java.nio.ByteBuffer.wrap(byteArray, offset, length));
    }

    protected ByteBuffer() {
    }

    public abstract void acquire();

    public abstract void release();

    public abstract java.nio.ByteBuffer buf();

    public abstract boolean isDirect();

    public abstract boolean isReadOnly();

    public abstract int capacity();

    public abstract ByteBuffer capacity(int var1);

    public abstract boolean isAutoExpand();

    public abstract ByteBuffer setAutoExpand(boolean var1);

    public ByteBuffer expand(int expectedRemaining) {
        return this.expand(this.position(), expectedRemaining);
    }

    public abstract ByteBuffer expand(int var1, int var2);

    public abstract boolean isPooled();

    public abstract void setPooled(boolean var1);

    public abstract int position();

    public abstract ByteBuffer position(int var1);

    public abstract int limit();

    public abstract ByteBuffer limit(int var1);

    public abstract ByteBuffer mark();

    public abstract int markValue();

    public abstract ByteBuffer reset();

    public abstract ByteBuffer clear();

    public ByteBuffer sweep() {
        this.clear();
        return this.fillAndReset(this.remaining());
    }

    public ByteBuffer sweep(byte value) {
        this.clear();
        return this.fillAndReset(value, this.remaining());
    }

    public abstract ByteBuffer flip();

    public abstract ByteBuffer rewind();

    public int remaining() {
        return this.limit() - this.position();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public abstract ByteBuffer duplicate();

    public abstract ByteBuffer slice();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract byte[] array();

    public abstract int arrayOffset();

    public abstract byte get();

    public short getUnsigned() {
        return (short)(this.get() & 0xFF);
    }

    public abstract ByteBuffer put(byte var1);

    public abstract byte get(int var1);

    public short getUnsigned(int index) {
        return (short)(this.get(index) & 0xFF);
    }

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer get(byte[] var1, int var2, int var3);

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public abstract ByteBuffer put(java.nio.ByteBuffer var1);

    public ByteBuffer put(ByteBuffer src) {
        return this.put(src.buf());
    }

    public abstract ByteBuffer put(byte[] var1, int var2, int var3);

    public ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public abstract ByteBuffer compact();

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.isDirect()) {
            buf.append("DirectBuffer");
        } else {
            buf.append("HeapBuffer");
        }
        buf.append("[pos=");
        buf.append(this.position());
        buf.append(" lim=");
        buf.append(this.limit());
        buf.append(" cap=");
        buf.append(this.capacity());
        buf.append(": ");
        buf.append(this.getHexDump());
        buf.append(']');
        return buf.toString();
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + this.get(i);
        }
        return h;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer that = (ByteBuffer)o;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(ByteBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            byte v2;
            byte v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    public abstract ByteOrder order();

    public abstract ByteBuffer order(ByteOrder var1);

    public abstract char getChar();

    public abstract ByteBuffer putChar(char var1);

    public abstract char getChar(int var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract CharBuffer asCharBuffer();

    public abstract short getShort();

    public int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    public abstract ByteBuffer putShort(short var1);

    public abstract short getShort(int var1);

    public int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ShortBuffer asShortBuffer();

    public abstract int getInt();

    public long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1);

    public abstract int getInt(int var1);

    public long getUnsignedInt(int index) {
        return (long)this.getInt(index) & 0xFFFFFFFFL;
    }

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract IntBuffer asIntBuffer();

    public abstract long getLong();

    public abstract ByteBuffer putLong(long var1);

    public abstract long getLong(int var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract LongBuffer asLongBuffer();

    public abstract float getFloat();

    public abstract ByteBuffer putFloat(float var1);

    public abstract float getFloat(int var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract FloatBuffer asFloatBuffer();

    public abstract double getDouble();

    public abstract ByteBuffer putDouble(double var1);

    public abstract double getDouble(int var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract DoubleBuffer asDoubleBuffer();

    public InputStream asInputStream() {
        return new InputStream(){

            public int available() {
                return ByteBuffer.this.remaining();
            }

            public synchronized void mark(int readlimit) {
                ByteBuffer.this.mark();
            }

            public boolean markSupported() {
                return true;
            }

            public int read() {
                if (ByteBuffer.this.hasRemaining()) {
                    return ByteBuffer.this.get() & 0xFF;
                }
                return -1;
            }

            public int read(byte[] b, int off, int len) {
                int remaining = ByteBuffer.this.remaining();
                if (remaining > 0) {
                    int readBytes = Math.min(remaining, len);
                    ByteBuffer.this.get(b, off, readBytes);
                    return readBytes;
                }
                return -1;
            }

            public synchronized void reset() {
                ByteBuffer.this.reset();
            }

            public long skip(long n) {
                int bytes = n > Integer.MAX_VALUE ? ByteBuffer.this.remaining() : Math.min(ByteBuffer.this.remaining(), (int)n);
                ByteBuffer.this.skip(bytes);
                return bytes;
            }
        };
    }

    public OutputStream asOutputStream() {
        return new OutputStream(){

            public void write(byte[] b, int off, int len) {
                ByteBuffer.this.put(b, off, len);
            }

            public void write(int b) {
                ByteBuffer.this.put((byte)b);
            }
        };
    }

    public String getHexDump() {
        return ByteBufferHexDumper.getHexdump(this);
    }

    public String getString(CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        int oldPos = this.position();
        int oldLimit = this.limit();
        if (!utf16) {
            while (this.hasRemaining() && this.get() != 0) {
            }
            end = this.position();
            if (end == oldLimit && this.get(end - 1) != 0) {
                this.limit(end);
            } else {
                this.limit(end - 1);
            }
        } else {
            while (this.remaining() >= 2) {
                boolean lowZero;
                boolean highZero = this.get() == 0;
                boolean bl = lowZero = this.get() == 0;
                if (!highZero || !lowZero) continue;
                break;
            }
            if ((end = this.position()) == oldLimit || end == oldLimit - 1) {
                this.limit(end);
            } else {
                this.limit(end - 2);
            }
        }
        this.position(oldPos);
        if (!this.hasRemaining()) {
            this.limit(oldLimit);
            this.position(end);
            return "";
        }
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            if (!cr.isError()) continue;
            this.limit(oldLimit);
            this.position(oldPos);
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public String getString(int fieldSize, CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int i;
        int end;
        ByteBuffer.checkFieldSize(fieldSize);
        if (fieldSize == 0) {
            return "";
        }
        if (!this.hasRemaining()) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int oldPos = this.position();
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferUnderflowException();
        }
        if (!utf16) {
            for (i = 0; i < fieldSize && this.get() != 0; ++i) {
            }
            if (i == fieldSize) {
                this.limit(end);
            } else {
                this.limit(this.position() - 1);
            }
        } else {
            for (i = 0; i < fieldSize; i += 2) {
                boolean lowZero;
                boolean highZero = this.get() == 0;
                boolean bl = lowZero = this.get() == 0;
                if (highZero && lowZero) break;
            }
            if (i == fieldSize) {
                this.limit(end);
            } else {
                this.limit(this.position() - 2);
            }
        }
        this.position(oldPos);
        if (!this.hasRemaining()) {
            this.limit(oldLimit);
            this.position(end);
            return "";
        }
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            if (!cr.isError()) continue;
            this.limit(oldLimit);
            this.position(oldPos);
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public ByteBuffer putString(CharSequence val, CharsetEncoder encoder) throws CharacterCodingException {
        CoderResult cr;
        if (val.length() == 0) {
            return this;
        }
        CharBuffer in = CharBuffer.wrap(val);
        encoder.reset();
        int expandedState = 0;
        block4: while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow()) {
            if (cr.isOverflow()) {
                if (this.isAutoExpand()) {
                    switch (expandedState) {
                        case 0: {
                            this.autoExpand((int)Math.ceil((float)in.remaining() * encoder.averageBytesPerChar()));
                            ++expandedState;
                            continue block4;
                        }
                        case 1: {
                            this.autoExpand((int)Math.ceil((float)in.remaining() * encoder.maxBytesPerChar()));
                            ++expandedState;
                            continue block4;
                        }
                    }
                    throw new RuntimeException("Expanded by " + (int)Math.ceil((float)in.remaining() * encoder.maxBytesPerChar()) + " but that wasn't enough for '" + val + "'");
                }
            } else {
                expandedState = 0;
            }
            cr.throwException();
        }
        return this;
    }

    public ByteBuffer putString(CharSequence val, int fieldSize, CharsetEncoder encoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        ByteBuffer.checkFieldSize(fieldSize);
        if (fieldSize == 0) {
            return this;
        }
        this.autoExpand(fieldSize);
        boolean utf16 = encoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new IllegalArgumentException("fieldSize is not even.");
        }
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferOverflowException();
        }
        if (val.length() == 0) {
            if (!utf16) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
            this.position(end);
            return this;
        }
        CharBuffer in = CharBuffer.wrap(val);
        this.limit(end);
        encoder.reset();
        while (!(cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf())).isUnderflow() && !cr.isOverflow()) {
            cr.throwException();
        }
        this.limit(oldLimit);
        if (this.position() < end) {
            if (!utf16) {
                this.put((byte)0);
            } else {
                this.put((byte)0);
                this.put((byte)0);
            }
        }
        this.position(end);
        return this;
    }

    public String getPrefixedString(CharsetDecoder decoder) throws CharacterCodingException {
        return this.getPrefixedString(2, decoder);
    }

    public String getPrefixedString(int prefixLength, CharsetDecoder decoder) throws CharacterCodingException {
        CoderResult cr;
        int end;
        if (!this.prefixedDataAvailable(prefixLength)) {
            throw new BufferUnderflowException();
        }
        int fieldSize = 0;
        switch (prefixLength) {
            case 1: {
                fieldSize = this.getUnsigned();
                break;
            }
            case 2: {
                fieldSize = this.getUnsignedShort();
                break;
            }
            case 4: {
                fieldSize = this.getInt();
            }
        }
        if (fieldSize == 0) {
            return "";
        }
        boolean utf16 = decoder.charset().name().startsWith("UTF-16");
        if (utf16 && (fieldSize & 1) != 0) {
            throw new BufferDataException("fieldSize is not even for a UTF-16 string.");
        }
        int oldLimit = this.limit();
        if (oldLimit < (end = this.position() + fieldSize)) {
            throw new BufferUnderflowException();
        }
        this.limit(end);
        decoder.reset();
        int expectedLength = (int)((float)this.remaining() * decoder.averageCharsPerByte()) + 1;
        CharBuffer out = CharBuffer.allocate(expectedLength);
        while (!(cr = this.hasRemaining() ? decoder.decode(this.buf(), out, true) : decoder.flush(out)).isUnderflow()) {
            if (cr.isOverflow()) {
                CharBuffer o = CharBuffer.allocate(out.capacity() + expectedLength);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            cr.throwException();
        }
        this.limit(oldLimit);
        this.position(end);
        return out.flip().toString();
    }

    public ByteBuffer putPrefixedString(CharSequence in, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, 2, 0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, prefixLength, 0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence in, int prefixLength, int padding, CharsetEncoder encoder) throws CharacterCodingException {
        return this.putPrefixedString(in, prefixLength, padding, (byte)0, encoder);
    }

    public ByteBuffer putPrefixedString(CharSequence val, int prefixLength, int padding, byte padValue, CharsetEncoder encoder) throws CharacterCodingException {
        int padMask;
        int maxLength;
        switch (prefixLength) {
            case 1: {
                maxLength = 255;
                break;
            }
            case 2: {
                maxLength = 65535;
                break;
            }
            case 4: {
                maxLength = Integer.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + prefixLength);
            }
        }
        if (val.length() > maxLength) {
            throw new IllegalArgumentException("The specified string is too long.");
        }
        if (val.length() == 0) {
            switch (prefixLength) {
                case 1: {
                    this.put((byte)0);
                    break;
                }
                case 2: {
                    this.putShort((short)0);
                    break;
                }
                case 4: {
                    this.putInt(0);
                }
            }
            return this;
        }
        switch (padding) {
            case 0: 
            case 1: {
                padMask = 0;
                break;
            }
            case 2: {
                padMask = 1;
                break;
            }
            case 4: {
                padMask = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("padding: " + padding);
            }
        }
        CharBuffer in = CharBuffer.wrap(val);
        int expectedLength = (int)((float)in.remaining() * encoder.averageBytesPerChar()) + 1;
        this.skip(prefixLength);
        int oldPos = this.position();
        encoder.reset();
        while (true) {
            CoderResult cr = in.hasRemaining() ? encoder.encode(in, this.buf(), true) : encoder.flush(this.buf());
            if (this.position() - oldPos > maxLength) {
                throw new IllegalArgumentException("The specified string is too long.");
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow() && this.isAutoExpand()) {
                this.autoExpand(expectedLength);
                continue;
            }
            cr.throwException();
        }
        this.fill(padValue, padding - (this.position() - oldPos & padMask));
        int length = this.position() - oldPos;
        switch (prefixLength) {
            case 1: {
                this.put(oldPos - 1, (byte)length);
                break;
            }
            case 2: {
                this.putShort(oldPos - 2, (short)length);
                break;
            }
            case 4: {
                this.putInt(oldPos - 4, length);
            }
        }
        return this;
    }

    public Object getObject() throws ClassNotFoundException {
        return this.getObject(Thread.currentThread().getContextClassLoader());
    }

    public Object getObject(final ClassLoader classLoader) throws ClassNotFoundException {
        if (!this.prefixedDataAvailable(4)) {
            throw new BufferUnderflowException();
        }
        int length = this.getInt();
        if (length <= 4) {
            throw new BufferDataException("Object length should be greater than 4: " + length);
        }
        int oldLimit = this.limit();
        this.limit(this.position() + length);
        try {
            ObjectInputStream in = new ObjectInputStream(this.asInputStream()){

                @Override
                protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
                    int type = this.read();
                    if (type < 0) {
                        throw new EOFException();
                    }
                    switch (type) {
                        case 0: {
                            return super.readClassDescriptor();
                        }
                        case 1: {
                            String className = this.readUTF();
                            Class<?> clazz = Class.forName(className, true, classLoader);
                            return ObjectStreamClass.lookup(clazz);
                        }
                    }
                    throw new StreamCorruptedException("Unexpected class descriptor type: " + type);
                }

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String name = desc.getName();
                    try {
                        return Class.forName(name, false, classLoader);
                    }
                    catch (ClassNotFoundException ex) {
                        return super.resolveClass(desc);
                    }
                }
            };
            Object object = in.readObject();
            return object;
        }
        catch (IOException e) {
            throw new BufferDataException(e);
        }
        finally {
            this.limit(oldLimit);
        }
    }

    public ByteBuffer putObject(Object o) {
        int oldPos = this.position();
        this.skip(4);
        try {
            ObjectOutputStream out = new ObjectOutputStream(this.asOutputStream()){

                protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
                    String className = desc.getName();
                    if (primitiveTypeNames.contains(className)) {
                        this.write(0);
                        super.writeClassDescriptor(desc);
                    } else {
                        this.write(1);
                        this.writeUTF(desc.getName());
                    }
                }
            };
            out.writeObject(o);
            out.flush();
        }
        catch (IOException e) {
            throw new BufferDataException(e);
        }
        int newPos = this.position();
        this.position(oldPos);
        this.putInt(newPos - oldPos - 4);
        this.position(newPos);
        return this;
    }

    public boolean prefixedDataAvailable(int prefixLength) {
        return this.prefixedDataAvailable(prefixLength, Integer.MAX_VALUE);
    }

    public boolean prefixedDataAvailable(int prefixLength, int maxDataLength) {
        int dataLength;
        if (this.remaining() < prefixLength) {
            return false;
        }
        switch (prefixLength) {
            case 1: {
                dataLength = this.getUnsigned(this.position());
                break;
            }
            case 2: {
                dataLength = this.getUnsignedShort(this.position());
                break;
            }
            case 4: {
                dataLength = this.getInt(this.position());
                break;
            }
            default: {
                throw new IllegalArgumentException("prefixLength: " + prefixLength);
            }
        }
        if (dataLength < 0 || dataLength > maxDataLength) {
            throw new BufferDataException("dataLength: " + dataLength);
        }
        return this.remaining() - prefixLength >= dataLength;
    }

    public ByteBuffer skip(int size) {
        this.autoExpand(size);
        return this.position(this.position() + size);
    }

    public ByteBuffer fill(byte value, int size) {
        int intValue;
        this.autoExpand(size);
        int q = size >>> 3;
        int r = size & 7;
        if (q > 0) {
            intValue = value | value << 8 | value << 16 | value << 24;
            long longValue = intValue;
            longValue <<= 32;
            longValue |= (long)intValue;
            for (int i = q; i > 0; --i) {
                this.putLong(longValue);
            }
        }
        q = r >>> 2;
        r &= 3;
        if (q > 0) {
            intValue = value | value << 8 | value << 16 | value << 24;
            this.putInt(intValue);
        }
        q = r >> 1;
        r &= 1;
        if (q > 0) {
            short shortValue = (short)(value | value << 8);
            this.putShort(shortValue);
        }
        if (r > 0) {
            this.put(value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(byte value, int size) {
        this.autoExpand(size);
        int pos = this.position();
        try {
            this.fill(value, size);
        }
        finally {
            this.position(pos);
        }
        return this;
    }

    public ByteBuffer fill(int size) {
        this.autoExpand(size);
        int q = size >>> 3;
        int r = size & 7;
        for (int i = q; i > 0; --i) {
            this.putLong(0L);
        }
        q = r >>> 2;
        r &= 3;
        if (q > 0) {
            this.putInt(0);
        }
        q = r >> 1;
        r &= 1;
        if (q > 0) {
            this.putShort((short)0);
        }
        if (r > 0) {
            this.put((byte)0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer fillAndReset(int size) {
        this.autoExpand(size);
        int pos = this.position();
        try {
            this.fill(size);
        }
        finally {
            this.position(pos);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int expectedRemaining) {
        if (this.isAutoExpand()) {
            this.expand(expectedRemaining);
        }
        return this;
    }

    protected ByteBuffer autoExpand(int pos, int expectedRemaining) {
        if (this.isAutoExpand()) {
            this.expand(pos, expectedRemaining);
        }
        return this;
    }

    private static void checkFieldSize(int fieldSize) {
        if (fieldSize < 0) {
            throw new IllegalArgumentException("fieldSize cannot be negative: " + fieldSize);
        }
    }

    static {
        primitiveTypeNames.add("void");
        primitiveTypeNames.add("boolean");
        primitiveTypeNames.add("byte");
        primitiveTypeNames.add("char");
        primitiveTypeNames.add("short");
        primitiveTypeNames.add("int");
        primitiveTypeNames.add("long");
        primitiveTypeNames.add("float");
        primitiveTypeNames.add("double");
    }
}

