/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.camel.LoggingLevel;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.mina.TextLineDelimiter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.mina.common.IoFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

@UriParams
public class MinaConfiguration
implements Cloneable {
    @UriPath(enums="tcp,udp,vm")
    @Metadata(required="true")
    private String protocol;
    @UriPath
    @Metadata(required="true")
    private String host;
    @UriPath
    @Metadata(required="true")
    private int port;
    @UriParam(defaultValue="true")
    private boolean sync = true;
    @UriParam(label="codec")
    private boolean textline;
    @UriParam(label="codec")
    private TextLineDelimiter textlineDelimiter;
    @UriParam(label="codec")
    private ProtocolCodecFactory codec;
    @UriParam(label="codec")
    private String encoding;
    @UriParam(defaultValue="30000")
    private long timeout = 30000L;
    @UriParam(label="producer,advanced", defaultValue="true")
    private boolean lazySessionCreation = true;
    @UriParam(label="advanced")
    private boolean transferExchange;
    @UriParam
    private boolean minaLogger;
    @UriParam(label="codec", defaultValue="-1")
    private int encoderMaxLineLength = -1;
    @UriParam(label="codec", defaultValue="1024")
    private int decoderMaxLineLength = 1024;
    @UriParam(label="codec")
    private List<IoFilter> filters;
    @UriParam(label="codec", defaultValue="true")
    private boolean allowDefaultCodec = true;
    @UriParam
    private boolean disconnect;
    @UriParam(label="consumer,advanced", defaultValue="true")
    private boolean disconnectOnNoReply = true;
    @UriParam(label="consumer,advanced", defaultValue="WARN")
    private LoggingLevel noReplyLogLevel = LoggingLevel.WARN;
    @UriParam(label="consumer")
    private boolean clientMode;

    public MinaConfiguration copy() {
        try {
            return (MinaConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getCharsetName() {
        if (this.encoding == null) {
            return null;
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new IllegalArgumentException("The encoding: " + this.encoding + " is not supported");
        }
        return Charset.forName(this.encoding).name();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean sync) {
        this.sync = sync;
    }

    public boolean isTextline() {
        return this.textline;
    }

    public void setTextline(boolean textline) {
        this.textline = textline;
    }

    public TextLineDelimiter getTextlineDelimiter() {
        return this.textlineDelimiter;
    }

    public void setTextlineDelimiter(TextLineDelimiter textlineDelimiter) {
        this.textlineDelimiter = textlineDelimiter;
    }

    public ProtocolCodecFactory getCodec() {
        return this.codec;
    }

    public void setCodec(ProtocolCodecFactory codec) {
        this.codec = codec;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isLazySessionCreation() {
        return this.lazySessionCreation;
    }

    public void setLazySessionCreation(boolean lazySessionCreation) {
        this.lazySessionCreation = lazySessionCreation;
    }

    public boolean isTransferExchange() {
        return this.transferExchange;
    }

    public void setTransferExchange(boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public void setEncoderMaxLineLength(int encoderMaxLineLength) {
        this.encoderMaxLineLength = encoderMaxLineLength;
    }

    public int getEncoderMaxLineLength() {
        return this.encoderMaxLineLength;
    }

    public void setDecoderMaxLineLength(int decoderMaxLineLength) {
        this.decoderMaxLineLength = decoderMaxLineLength;
    }

    public int getDecoderMaxLineLength() {
        return this.decoderMaxLineLength;
    }

    public boolean isMinaLogger() {
        return this.minaLogger;
    }

    public void setMinaLogger(boolean minaLogger) {
        this.minaLogger = minaLogger;
    }

    public List<IoFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<IoFilter> filters) {
        this.filters = filters;
    }

    public boolean isDatagramProtocol() {
        return this.protocol.equals("udp");
    }

    public void setAllowDefaultCodec(boolean allowDefaultCodec) {
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public boolean isAllowDefaultCodec() {
        return this.allowDefaultCodec;
    }

    public boolean isDisconnect() {
        return this.disconnect;
    }

    public void setDisconnect(boolean disconnect) {
        this.disconnect = disconnect;
    }

    public boolean isDisconnectOnNoReply() {
        return this.disconnectOnNoReply;
    }

    public void setDisconnectOnNoReply(boolean disconnectOnNoReply) {
        this.disconnectOnNoReply = disconnectOnNoReply;
    }

    public LoggingLevel getNoReplyLogLevel() {
        return this.noReplyLogLevel;
    }

    public void setNoReplyLogLevel(LoggingLevel noReplyLogLevel) {
        this.noReplyLogLevel = noReplyLogLevel;
    }

    public boolean isClientMode() {
        return this.clientMode;
    }

    public void setClientMode(boolean clientMode) {
        this.clientMode = clientMode;
    }

    public String getUriString() {
        return "mina:" + this.getProtocol() + ":" + this.getHost() + ":" + this.getPort();
    }
}

