/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mina;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.mina.common.ByteBuffer;

@Converter
public final class MinaConverter {
    private MinaConverter() {
    }

    @Converter
    public static byte[] toByteArray(ByteBuffer buffer) {
        buffer.mark();
        try {
            byte[] answer = new byte[buffer.remaining()];
            buffer.get(answer);
            byte[] byArray = answer;
            return byArray;
        }
        finally {
            buffer.reset();
        }
    }

    @Converter
    public static String toString(ByteBuffer buffer, Exchange exchange) {
        byte[] bytes = MinaConverter.toByteArray(buffer);
        return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)bytes);
    }

    @Converter
    public static InputStream toInputStream(ByteBuffer buffer) {
        return buffer.asInputStream();
    }

    @Converter
    public static ObjectInput toObjectInput(ByteBuffer buffer) throws IOException {
        InputStream is = MinaConverter.toInputStream(buffer);
        return new ObjectInputStream(is);
    }

    @Converter
    public static ByteBuffer toByteBuffer(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.allocate((int)bytes.length);
        buf.put(bytes);
        return buf;
    }
}

