/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.InetHelper;
import org.apache.uima.ducc.common.utils.TimeStamp;

public class DuccDaemonRuntimeProperties {
    public static DaemonName[] daemonNames = new DaemonName[]{DaemonName.Broker, DaemonName.Database, DaemonName.Orchestrator, DaemonName.ProcessManager, DaemonName.ResourceManager, DaemonName.ServiceManager, DaemonName.Webserver};
    public static String keyDaemonName = "daemonName";
    public static String keyBootTime = "bootTime";
    public static String keyBootType = "bootType";
    public static String keyNodeName = "nodeName";
    public static String keyNodeIpAddress = "nodeIpAddress";
    public static String keyPid = "pid";
    public static String keyJmxUrl = "jmxUrl";
    private static DuccDaemonRuntimeProperties instance = new DuccDaemonRuntimeProperties();
    private String ducc_daemons_dir = IDuccEnv.DUCC_DAEMONS_DIR;
    private String ducc_agents_dir = IDuccEnv.DUCC_AGENTS_DIR;
    private String suffix = "-boot.properties";

    public static DuccDaemonRuntimeProperties getInstance() {
        return instance;
    }

    private DuccDaemonRuntimeProperties() {
        this.init();
    }

    private void init() {
        IOHelper.mkdirs(this.ducc_daemons_dir);
        IOHelper.mkdirs(this.ducc_agents_dir);
    }

    private String getDaemonsHostDir() {
        return IDuccEnv.DUCC_DAEMONS_DIR + InetHelper.getHostName() + File.separator;
    }

    public Properties get(DaemonName daemonName) {
        Properties properties = new Properties();
        String fileName = this.getDaemonsHostDir() + (Object)((Object)daemonName) + this.suffix;
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + fileName);
        }
        return properties;
    }

    public void put(DaemonName daemonName, Properties properties) {
        String fileDir = this.getDaemonsHostDir();
        IOHelper.mkdirs(fileDir);
        String fileName = fileDir + (Object)((Object)daemonName) + this.suffix;
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            properties.store(fos, "");
            fos.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file: " + fileName);
        }
    }

    public void boot(DaemonName daemonName, String jmxUrl) {
        Properties bootProperties = new Properties();
        String daemonNameText = daemonName.toString();
        String bootTime = TimeStamp.simpleFormat("" + System.currentTimeMillis());
        String nodeIpAddress = "?";
        String nodeName = "?";
        String pid = "?";
        try {
            nodeIpAddress = InetAddress.getLocalHost().getHostAddress();
            nodeName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bootProperties.put(keyDaemonName, daemonNameText);
        bootProperties.put(keyBootTime, bootTime);
        bootProperties.put(keyJmxUrl, jmxUrl);
        bootProperties.put(keyNodeIpAddress, nodeIpAddress);
        bootProperties.put(keyNodeName, nodeName);
        bootProperties.put(keyPid, pid);
        DuccDaemonRuntimeProperties.getInstance().put(daemonName, bootProperties);
    }

    public Properties getAgent(String agentName) {
        Properties properties = new Properties();
        String fileName = IDuccEnv.DUCC_AGENTS_DIR + agentName + this.suffix;
        try {
            File file = new File(fileName);
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + fileName);
        }
        catch (IOException e) {
            System.out.println("Error reading file: " + fileName);
        }
        return properties;
    }

    public void putAgent(String agentName, Properties properties) {
        String fileName = IDuccEnv.DUCC_AGENTS_DIR + agentName + this.suffix;
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            properties.store(fos, "");
            fos.close();
        }
        catch (IOException e) {
            System.out.println("Error writing file: " + fileName);
        }
    }

    public void bootAgent(String name, String ip, String jmxUrl) {
        Properties bootProperties = new Properties();
        String bootTime = TimeStamp.simpleFormat("" + System.currentTimeMillis());
        String nodeIpAddress = "?";
        String nodeName = "?";
        String pid = "?";
        try {
            nodeIpAddress = InetAddress.getLocalHost().getHostAddress();
            nodeName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        bootProperties.put(keyDaemonName, name);
        bootProperties.put(keyBootTime, bootTime);
        bootProperties.put(keyJmxUrl, jmxUrl);
        bootProperties.put(keyNodeIpAddress, nodeIpAddress);
        bootProperties.put(keyNodeName, nodeName);
        bootProperties.put(keyPid, pid);
        DuccDaemonRuntimeProperties.getInstance().putAgent(name, bootProperties);
    }

    public static enum DaemonName {
        Broker,
        Database,
        Orchestrator,
        ResourceManager,
        ProcessManager,
        ServiceManager,
        Webserver;

    }
}

