/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.node.metrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.uima.ducc.common.utils.id.IDuccId;

public class NodeUsersInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uid;
    private List<NodeProcess> reserveProcesses = new ArrayList<NodeProcess>();
    private transient List<IDuccId> reservations = new ArrayList<IDuccId>();
    private List<NodeProcess> rogueProcesses = new ArrayList<NodeProcess>();
    private AtomicInteger counter = new AtomicInteger(1);

    public NodeUsersInfo(String uid) {
        this.uid = uid;
    }

    public boolean markAsRogue(int ceiling) {
        if (this.counter.get() < ceiling) {
            this.counter.addAndGet(1);
            return false;
        }
        return true;
    }

    public String getUid() {
        return this.uid;
    }

    public List<IDuccId> getReservations() {
        return this.reservations;
    }

    public List<NodeProcess> getRogueProcesses() {
        return this.rogueProcesses;
    }

    public void addPid(String pid, String ppid, boolean java) {
        this.reserveProcesses.add(new NodeProcess(pid, ppid, java));
    }

    public void addReservation(IDuccId reservation) {
        this.reservations.add(reservation);
    }

    public void addReservation(List<IDuccId> reservations) {
        this.reservations = reservations;
    }

    public void addRogueProcess(String roguePID, String ppid, boolean isJava) {
        this.rogueProcesses.add(new NodeProcess(roguePID, ppid, isJava));
    }

    public String toString() {
        if (this.reservations.size() == 0 && this.rogueProcesses.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        String reservation = this.reservations.size() > 0 ? "Y" : "N";
        String userId = this.getUid();
        String rogue = this.reservations.size() == 0 ? "Y" : "N";
        sb.append(String.format("\n%32s%20s%8s%12s%12s\n", "UserID", "Reservation", "Rogue", "Java", "NonJava"));
        sb.append(String.format("%32s%20s%8s%12s%12s\n", StringUtils.center((String)"", (int)30, (String)"-"), StringUtils.center((String)"", (int)18, (String)"-"), StringUtils.center((String)"", (int)6, (String)"-"), StringUtils.leftPad((String)"", (int)10, (String)"-"), StringUtils.leftPad((String)"", (int)10, (String)"-")));
        if (this.reservations.size() > 0) {
            for (NodeProcess process : this.reserveProcesses) {
                if (process.isJava()) {
                    sb.append(String.format("%32s%20s%8s%12s%12s\n", userId, reservation, rogue, process.getPid(), ""));
                } else {
                    sb.append(String.format("%32s%20s%8s%12s%12s\n", userId, reservation, rogue, "", process.getPid()));
                }
                userId = "";
                reservation = "";
            }
        } else {
            for (NodeProcess process : this.rogueProcesses) {
                if (process.isJava()) {
                    sb.append(String.format("%32s%20s%8s%12s%12s\n", userId, reservation, rogue, process.getPid(), ""));
                } else {
                    sb.append(String.format("%32s%20s%8s%12s%12s\n", userId, reservation, rogue, "", process.getPid()));
                }
                userId = "";
                reservation = "";
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    public List<NodeProcess> getReserveProcesses() {
        return this.reserveProcesses;
    }

    public class NodeProcess
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean java;
        String pid;
        String ppid;

        public NodeProcess(String pid, String ppid, boolean isJava) {
            this.pid = pid;
            this.java = isJava;
        }

        public String getPpid() {
            return this.ppid;
        }

        public void setPpid(String ppid) {
            this.ppid = ppid;
        }

        public boolean isJava() {
            return this.java;
        }

        public void setJava(boolean java) {
            this.java = java;
        }

        public String getPid() {
            return this.pid;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }
    }
}

