/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.FileHelper;
import org.apache.uima.ducc.common.utils.Utils;

public class AlienFile
extends AlienAbstract {
    private static DuccLogger duccLogger = DuccLogger.getLogger(AlienFile.class);
    private static String ducc_ling = Utils.resolvePlaceholderIfExists(System.getProperty("ducc.agent.launcher.ducc_spawn_path"), System.getProperties());
    private String command_cat = "/bin/cat";
    private String file_name;
    private File devNull = new File("/dev/null");
    private int exitValue;

    protected void set_command_cat(String value) {
        this.command_cat = value;
    }

    protected String get_command_cat() {
        return this.command_cat;
    }

    protected void set_file_name(String value) {
        this.file_name = value;
    }

    protected String get_file_name() {
        return this.file_name;
    }

    public AlienFile(String user, String file_name) {
        this.set_user(user);
        this.set_file_name(file_name);
    }

    private String[] getCommand() {
        String[] command_ducc_ling_yes = new String[]{ducc_ling, this.q_parameter, this.u_parameter, this.user, this.command_cat, this.file_name};
        String[] command_ducc_ling_no = new String[]{this.command_cat, this.file_name};
        String[] command = command_ducc_ling_yes;
        if (ducc_ling == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private String reader() throws Exception {
        String string;
        String location = "reader";
        BufferedReader br = null;
        InputStreamReader isr = null;
        Process p = null;
        StringBuilder sb = new StringBuilder();
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        try {
            String line;
            p = pb.start();
            InputStream pOut = p.getInputStream();
            if (FileHelper.isGzFileType(this.file_name)) {
                GZIPInputStream gis = new GZIPInputStream(pOut);
                isr = new InputStreamReader((InputStream)gis, this.encoding);
            } else {
                isr = new InputStreamReader(pOut);
            }
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
            int rc = p.waitFor();
            string = rc == 0 ? sb.toString() : null;
        }
        catch (Exception e) {
            block8: {
                String string2;
                try {
                    int rc;
                    if (p == null || (rc = p.waitFor()) == 0) break block8;
                    string2 = null;
                }
                catch (Throwable throwable) {
                    this.closer(br);
                    this.closer(isr);
                    throw throwable;
                }
                this.closer(br);
                this.closer(isr);
                return string2;
            }
            duccLogger.error(location, this.duccId, e, new Object[0]);
            throw e;
        }
        this.closer(br);
        this.closer(isr);
        return string;
    }

    public String getString() throws Exception {
        String data = this.reader();
        if (data != null) {
            data = data.trim();
        }
        return data;
    }

    public InputStreamReader getInputStreamReader() throws Exception {
        InputStreamReader isr = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        if (FileHelper.isGzFileType(this.file_name)) {
            GZIPInputStream gis = new GZIPInputStream(pOut);
            isr = new InputStreamReader((InputStream)gis, this.encoding);
        } else {
            isr = new InputStreamReader(pOut);
        }
        return isr;
    }

    public DataInputStream getDataInputStream() throws Exception {
        DataInputStream dis = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb = pb.redirectError(this.devNull);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        dis = new DataInputStream(pOut);
        return dis;
    }

    public String[] getResult(boolean includeStderr, String ... command) {
        String location = "getLines";
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            String[] prefix = new String[]{ducc_ling, "-q", "-u", this.user};
            ArrayList<String> fullCmd = new ArrayList<String>();
            fullCmd.addAll(Arrays.asList(prefix));
            fullCmd.addAll(Arrays.asList(command));
            ProcessBuilder pb = new ProcessBuilder(fullCmd);
            if (includeStderr) {
                pb.redirectErrorStream(true);
            } else {
                pb.redirectError(new File("/dev/null"));
            }
            Process process = pb.start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            this.exitValue = process.waitFor();
        }
        catch (Exception e) {
            this.exitValue = -1;
            duccLogger.error(location, this.duccId, e, new Object[0]);
        }
        return lines.toArray(new String[lines.size()]);
    }

    public int getRc() {
        return this.exitValue;
    }

    public static void main(String[] args) throws Exception {
        String arg_user = args[0];
        String arg_file = args[1];
        AlienFile alienFile = new AlienFile(arg_user, arg_file);
        String data = alienFile.getString();
        System.out.println(data);
    }
}

