/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.text.DecimalFormat;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;

public class DuccHandlerUtils {
    private static DuccLogger duccLogger = DuccLogger.getLogger(DuccHandlerUtils.class);
    private static DuccId jobid = null;
    private static DecimalFormat formatter = new DecimalFormat("###0.0");
    public static double GB = Math.pow(10.0, 9.0);
    public static double MB = Math.pow(10.0, 6.0);
    public static double KB = Math.pow(10.0, 3.0);

    public static String warn(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append(text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String down() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_red\">");
        sb.append("down");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_green\">");
        sb.append("up");
        sb.append("</span>");
        return sb.toString();
    }

    public static String disabled() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("disabled");
        sb.append("</span>");
        return sb.toString();
    }

    public static String up_provisional(String text) {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("up" + text);
        sb.append("</span>");
        return sb.toString();
    }

    public static String unknown() {
        StringBuffer sb = new StringBuffer();
        sb.append("<span class=\"health_black\">");
        sb.append("unknown");
        sb.append("</span>");
        return sb.toString();
    }

    public static String getSwapSizeDisplay(double swapBytes) {
        String retVal = formatter.format(swapBytes / GB);
        return retVal;
    }

    public static String getSwapSizeHover(double swapBytes) {
        String retVal = null;
        retVal = swapBytes == 0.0 ? formatter.format(swapBytes / GB) + " GB" : (swapBytes >= GB / 10.0 ? formatter.format(swapBytes / GB) + " GB" : (swapBytes >= MB / 10.0 ? formatter.format(swapBytes / MB) + " MB" : (swapBytes >= KB / 10.0 ? formatter.format(swapBytes / KB) + " KB" : formatter.format(swapBytes) + " Bytes")));
        return retVal;
    }

    public static boolean safeCompare(String s1, String s2) {
        boolean retVal = false;
        if (s1 != null && s2 != null) {
            retVal = s1.equals(s2);
        }
        return retVal;
    }

    public static String getNode(IDuccProcess p) {
        String name;
        String retVal = null;
        Node node = p.getNode();
        NodeIdentity ni = node.getNodeIdentity();
        retVal = name = ni.getIp();
        return retVal;
    }

    public static String getPid(IDuccProcess p) {
        String retVal = p.getPID();
        return retVal;
    }

    public static IDuccProcess getJobProcess(IDuccWorkJob job, String node, String pid) {
        String location = "getJobProcess";
        IDuccProcess retVal = null;
        try {
            IDuccProcessMap map = job.getProcessMap();
            for (Map.Entry entry : map.entrySet()) {
                IDuccProcess p = (IDuccProcess)entry.getValue();
                String pnode = DuccHandlerUtils.getNode(p);
                String ppid = DuccHandlerUtils.getPid(p);
                duccLogger.debug(location, jobid, new Object[]{node, pid, pnode, ppid});
                if (!DuccHandlerUtils.safeCompare(node, pnode) || !DuccHandlerUtils.safeCompare(pid, ppid)) continue;
                retVal = p;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static long getReferenceTime(IDuccWorkJob job, String node, String pid) {
        String location = "getReferenceTime";
        long retVal = System.currentTimeMillis();
        if (job != null) {
            long time;
            ITimeWindow tw;
            IDuccProcess p;
            IDuccStandardInfo stdInfo;
            long time2;
            if (job.isCompleted() && (time2 = (stdInfo = job.getStandardInfo()).getDateOfCompletionMillis()) > 0L) {
                duccLogger.debug(location, jobid, new Object[]{"job: " + time2});
                retVal = time2;
            }
            if ((p = DuccHandlerUtils.getJobProcess(job, node, pid)) != null && (tw = p.getTimeWindowRun()) != null && (time = tw.getEndLong()) > 0L) {
                duccLogger.debug(location, jobid, new Object[]{"process: " + time});
                retVal = time;
            }
        }
        return retVal;
    }
}

