/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.ws.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.ducc.common.persistence.or.IDbDuccWorks;
import org.apache.uima.ducc.common.persistence.or.ITypedProperties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbDuccWorks;
import org.apache.uima.ducc.transport.event.common.DuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.ws.server.DuccFile;
import org.apache.uima.ducc.ws.utils.alien.EffectiveUser;

public class HelperSpecifications {
    private static DuccLogger duccLogger = DuccLogger.getLogger(HelperSpecifications.class);
    private static DuccId jobid = null;
    private static HelperSpecifications instance = new HelperSpecifications();
    private IDbDuccWorks dbDuccWorks = null;

    public static HelperSpecifications getInstance() {
        return instance;
    }

    public HelperSpecifications() {
        this.init();
    }

    private void init() {
        String location = "init";
        try {
            this.dbDuccWorks = new DbDuccWorks(duccLogger);
        }
        catch (Exception e) {
            duccLogger.error(location, jobid, (Throwable)e, new Object[0]);
        }
    }

    private HashMap<String, Properties> getSpecificationPropertiesFromFiles(DuccWorkJob dwj, EffectiveUser eu, String filename) {
        String location = "getJobSpecificationPropertiesFromFiles";
        DuccId duccid = jobid;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        try {
            duccid = dwj.getDuccId();
            if (dwj != null) {
                String path = dwj.getUserLogDir() + filename;
                String key = PType.user.name();
                Properties properties = DuccFile.getUserSpecifiedProperties(eu, (IDuccWorkJob)dwj);
                if (properties != null && properties.size() > 0) {
                    map.put(key, properties);
                }
                key = PType.all.name();
                properties = DuccFile.getProperties(eu, path);
                if (properties != null && properties.size() > 0) {
                    map.put(key, properties);
                }
            }
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    private Map<String, Properties> getSpecificationPropertiesFromDb(String specificationType, Long id) {
        String location = "getSpecificationPropertiesFromDb";
        DuccId duccid = jobid;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        try {
            ITypedProperties typedProperties = this.dbDuccWorks.fetchSpecification(specificationType, id.longValue());
            Map dbmap = typedProperties.getMap();
            if (dbmap != null) {
                Properties all;
                Properties user = (Properties)dbmap.get(ITypedProperties.PropertyType.user.name());
                if (user != null) {
                    map.put(PType.user.name(), user);
                }
                if ((all = (Properties)dbmap.get(ITypedProperties.PropertyType.system.name())) == null) {
                    all = new Properties();
                }
                all.putAll((Map<?, ?>)user);
                map.put(PType.all.name(), all);
            }
            duccid = new DuccId(id.longValue());
            duccLogger.debug(location, duccid, new Object[]{"size=" + map.size()});
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    private HashMap<String, Properties> getJobSpecificationPropertiesFromFiles(DuccWorkJob dwj, EffectiveUser eu) {
        String location = "getJobSpecificationPropertiesFromFiles";
        DuccId duccid = jobid;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        try {
            if (dwj != null) {
                duccid = dwj.getDuccId();
                String filename = "job-specification.properties";
                map = this.getSpecificationPropertiesFromFiles(dwj, eu, filename);
            }
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    private Map<String, Properties> getJobSpecificationPropertiesFromDb(DuccWorkJob dwj, EffectiveUser eu) {
        String location = "getJobSpecificationPropertiesFromDb";
        DuccId duccid = jobid;
        Map<String, Properties> map = new HashMap<String, Properties>();
        try {
            if (dwj != null) {
                String specificationType = ITypedProperties.SpecificationType.Job.name();
                Long id = dwj.getDuccId().getFriendly();
                map = this.getSpecificationPropertiesFromDb(specificationType, id);
            }
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    public Map<String, Properties> getJobSpecificationProperties(DuccWorkJob dwj, EffectiveUser eu) {
        Map<Object, Object> map = new HashMap();
        if (map.size() == 0) {
            map = this.getJobSpecificationPropertiesFromDb(dwj, eu);
        }
        if (map.size() == 0) {
            map = this.getJobSpecificationPropertiesFromFiles(dwj, eu);
        }
        if (map.size() == 0) {
            map = null;
        }
        return map;
    }

    private Map<String, Properties> getManagedReservationSpecificationPropertiesFromDb(DuccWorkJob dwj, EffectiveUser eu) {
        String location = "getManagedReservationSpecificationPropertiesFromDb";
        DuccId duccid = jobid;
        Map<String, Properties> map = new HashMap<String, Properties>();
        try {
            if (dwj != null) {
                String specificationType = ITypedProperties.SpecificationType.ManagedReservation.name();
                Long id = dwj.getDuccId().getFriendly();
                map = this.getSpecificationPropertiesFromDb(specificationType, id);
            }
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    private HashMap<String, Properties> getManagedReservationSpecificationPropertiesFromFiles(DuccWorkJob dwj, EffectiveUser eu) {
        String location = "getManagedReservationSpecificationPropertiesFromFiles";
        DuccId duccid = jobid;
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        try {
            if (dwj != null) {
                duccid = dwj.getDuccId();
                String filename = "managed-reservation.properties";
                map = this.getSpecificationPropertiesFromFiles(dwj, eu, filename);
            }
        }
        catch (Throwable t) {
            duccLogger.debug(location, duccid, t, new Object[0]);
        }
        return map;
    }

    public Map<String, Properties> getManagedReservationSpecificationProperties(DuccWorkJob dwj, EffectiveUser eu) {
        Map<Object, Object> map = new HashMap();
        if (map.size() == 0) {
            map = this.getManagedReservationSpecificationPropertiesFromDb(dwj, eu);
        }
        if (map.size() == 0) {
            map = this.getManagedReservationSpecificationPropertiesFromFiles(dwj, eu);
        }
        if (map.size() == 0) {
            map = null;
        }
        return map;
    }

    public Map<String, Properties> convertAllToSystem(Map<String, Properties> mapAll) {
        HashMap<String, Properties> mapSystem = null;
        if (mapAll != null) {
            mapSystem = new HashMap<String, Properties>();
            Properties propsU = mapAll.get("user");
            Properties propsA = mapAll.get("all");
            if (propsU == null) {
                if (propsA != null) {
                    mapSystem.put("system", propsA);
                }
            } else {
                mapSystem.put("user", propsU);
                if (propsA != null) {
                    Properties propsS = new Properties();
                    for (Object key : propsA.keySet()) {
                        if (propsU.containsKey(key)) continue;
                        propsS.put(key, propsA.get(key));
                    }
                    mapSystem.put("system", propsS);
                }
            }
        }
        return mapSystem;
    }

    public static enum PType {
        user,
        all;

    }
}

