/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.internal;

import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.fit.internal.ClassLoaderUtils;
import org.apache.uima.impl.UimaVersion;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.impl.ResourceManager_impl;

public class ResourceManagerFactory {
    private static ResourceManagerCreator resourceManagerCreator = new DefaultResourceManagerCreator();

    private ResourceManagerFactory() {
    }

    public static ResourceManager newResourceManager() throws ResourceInitializationException {
        return resourceManagerCreator.newResourceManager();
    }

    public static synchronized void setResourceManagerCreator(ResourceManagerCreator resourceManagerCreator) {
        ResourceManagerFactory.resourceManagerCreator = resourceManagerCreator;
    }

    public static ResourceManagerCreator getResourceManagerCreator() {
        return resourceManagerCreator;
    }

    public static class DefaultResourceManagerCreator
    implements ResourceManagerCreator {
        @Override
        public ResourceManager newResourceManager() throws ResourceInitializationException {
            boolean uimaCoreIgnoresContextClassloader;
            UimaContext activeContext = UimaContextHolder.getContext();
            if (activeContext != null) {
                return ((UimaContextAdmin)activeContext).getResourceManager();
            }
            Object resMgr = Thread.currentThread().getContextClassLoader() != null ? new ResourceManager_impl(null) : UIMAFramework.newDefaultResourceManager();
            short maj = UimaVersion.getMajorVersion();
            short min = UimaVersion.getMinorVersion();
            short rev = UimaVersion.getBuildRevision();
            boolean bl = uimaCoreIgnoresContextClassloader = maj == 2 && (min < 10 || min == 10 && rev < 3) || maj == 3 && min == 0 && rev < 1;
            if (uimaCoreIgnoresContextClassloader) {
                resMgr.setExtensionClassLoader(ClassLoaderUtils.findClassloader(), true);
            }
            return resMgr;
        }
    }

    public static interface ResourceManagerCreator {
        public ResourceManager newResourceManager() throws ResourceInitializationException;
    }
}

