/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;

public class UIMAClassLoader
extends URLClassLoader {
    public static final String MHLC = "org.apache.uima.cas.impl.MethodHandlesLookup";
    static byte[] methodHandlesLookupClass;
    private static final int nbrLocks;
    private final Object[] syncLocks = new Object[nbrLocks];
    private boolean isClosed = false;

    public static URL[] transformClasspath(String classpath) throws MalformedURLException {
        StringTokenizer tok = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> pathList = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            pathList.add(tok.nextToken());
        }
        int max = pathList.size();
        URL[] urlArray = new URL[max];
        for (int i = 0; i < max; ++i) {
            urlArray[i] = new File((String)pathList.get(i)).toURI().toURL();
        }
        return urlArray;
    }

    public UIMAClassLoader(String classpath) throws MalformedURLException {
        super(Misc.classpath2urls(classpath));
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath) {
        super(classpath);
        this.commonInit();
    }

    public UIMAClassLoader(URL[] classpath, ClassLoader parent) {
        super(classpath, parent);
        this.commonInit();
    }

    public UIMAClassLoader(String classpath, ClassLoader parent) throws MalformedURLException {
        super(Misc.classpath2urls(classpath), parent);
        this.commonInit();
    }

    private void commonInit() {
        for (int i = 0; i < nbrLocks; ++i) {
            this.syncLocks[i] = new Object();
        }
    }

    public static URLClassLoader newInstance(URL[] urls) {
        throw new UnsupportedOperationException();
    }

    public static URLClassLoader newInstance(URL[] urls, ClassLoader parent) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = MHLC.equals(name) ? this.defineClass(MHLC, methodHandlesLookupClass, 0, methodHandlesLookupClass.length) : this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, false);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        Object object = this.syncLocks[name.hashCode() & nbrLocks - 1];
        synchronized (object) {
            URL url = this.findResource(name);
            if (null == url) {
                url = super.getResource(name);
            }
            return url;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (TypeSystemImpl.staticTsi != null) {
            FSClassRegistry.unregister_jcci_classloader(this);
        }
        super.close();
    }

    Object getClassLoadingLockForTesting(String aClassName) {
        return super.getClassLoadingLock(aClassName);
    }

    static {
        if (!ClassLoader.registerAsParallelCapable()) {
            System.err.println("WARNING - Failed to register the UIMA Class loader as parallel-capable - should never happen");
        }
        methodHandlesLookupClass = Misc.hex_string_to_bytearray("CAFEBABE00000034001B07000201002C6F72672F6170616368652F75696D612F6361732F696D706C2F4D6574686F6448616E646C65734C6F6F6B75700700040100106A6176612F6C616E672F4F626A6563740100063C696E69743E010003282956010004436F64650A000300090C0005000601000F4C696E654E756D6265725461626C650100124C6F63616C5661726961626C655461626C650100047468697301002E4C6F72672F6170616368652F75696D612F6361732F696D706C2F4D6574686F6448616E646C65734C6F6F6B75703B0100166765744D6574686F6448616E646C65734C6F6F6B757001002928294C6A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C6573244C6F6F6B75703B0A0011001307001201001E6A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C65730C0014000F0100066C6F6F6B757001000A536F7572636546696C650100184D6574686F6448616E646C65734C6F6F6B75702E6A61766101000C496E6E6572436C61737365730700190100256A6176612F6C616E672F696E766F6B652F4D6574686F6448616E646C6573244C6F6F6B75700100064C6F6F6B7570002100010003000000000002000200050006000100070000002F00010001000000052AB70008B100000002000A0000000600010000001A000B0000000C000100000005000C000D00000009000E000F00010007000000240001000000000004B80010B000000002000A0000000600010000001D000B0000000200000002001500000002001600170000000A000100180011001A0019");
        nbrLocks = Misc.nextHigherPowerOf2(Runtime.getRuntime().availableProcessors());
    }
}

