/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.cas.TOP;

public class OrderedFsSet_array<T extends FeatureStructure>
implements Iterable<T> {
    private static final boolean TRACE = false;
    private static final boolean MEASURE = false;
    private static final int DEFAULT_SIZE = 8;
    private static final int DEFAULT_MULTIPLICATION_LIMIT = 0x1000000;
    private final int multiplication_limit = 0x1000000;
    TOP[] a;
    int a_nextFreeslot = 0;
    int a_firstUsedslot = 0;
    private final Comparator<TOP> comparatorNoTypeWithID;
    private final Comparator<TOP> comparatorNoTypeWithoutID;
    private int maxSize = 0;
    private StringBuilder tr = null;
    private static int addToEndCount = 0;
    private static int[] batchCountHistogram;
    private static int batchAddCount;
    private static int batchAddTotal;
    private static int[] moveSizeHistogram;
    private static int[] movePctHistogram;
    private static int[] fillHistogram;
    private static int[] iterPctEmptySkip;

    public OrderedFsSet_array(Comparator<TOP> comparatorNoTypeWithID, Comparator<TOP> comparatorNoTypeWithoutID) {
        this.comparatorNoTypeWithID = comparatorNoTypeWithID;
        this.comparatorNoTypeWithoutID = comparatorNoTypeWithoutID;
        this.a = new TOP[8];
    }

    public OrderedFsSet_array(OrderedFsSet_array<T> set, boolean isReadOnly) {
        if (!isReadOnly) {
            Misc.internalError();
        }
        this.a = new TOP[set.a.length];
        System.arraycopy(set.a, 0, this.a, 0, set.a_nextFreeslot);
        this.a_firstUsedslot = set.a_firstUsedslot;
        this.a_nextFreeslot = set.a_nextFreeslot;
        this.comparatorNoTypeWithID = set.comparatorNoTypeWithID;
        this.comparatorNoTypeWithoutID = set.comparatorNoTypeWithoutID;
        this.maxSize = set.maxSize;
    }

    public int size() {
        return this.a_nextFreeslot - this.a_firstUsedslot;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean add(T fs1) {
        throw new UnsupportedOperationException();
    }

    public boolean add(T fs1, Comparator<TOP> comparator) {
        int insertPosOfAddedSpace;
        if (fs1 == null) {
            throw new IllegalArgumentException("Null cannot be added to this set.");
        }
        TOP fs = (TOP)fs1;
        int c = 1;
        boolean highest = false;
        if (this.size() == 0 || (c = comparator.compare(fs, this.a[this.a_nextFreeslot - 1])) > 0) {
            highest = true;
        }
        if (c == 0) {
            return false;
        }
        if (highest) {
            insertPosOfAddedSpace = this.a_nextFreeslot;
        } else {
            insertPosOfAddedSpace = this.find(fs, comparator);
            if (insertPosOfAddedSpace >= 0) {
                return false;
            }
            insertPosOfAddedSpace = -insertPosOfAddedSpace - 1;
        }
        int indexOfNewItem = this.insertSpace(insertPosOfAddedSpace, highest) - 1;
        this.a[indexOfNewItem] = fs;
        this.maxSize = Math.max(this.maxSize, this.size());
        return true;
    }

    private void ensureCapacity() {
        if (this.a_nextFreeslot < this.a.length || this.a_firstUsedslot > 0) {
            return;
        }
        int newSize = this.a.length > 0x1000000 ? this.a.length + 0x1000000 : this.a.length << 1;
        this.a = Arrays.copyOf(this.a, newSize);
    }

    private int insertSpace(int insertPosOfAddedSpace, boolean highest) {
        boolean useFront;
        this.ensureCapacity();
        if (highest) {
            if (this.a_nextFreeslot >= this.a.length) {
                insertPosOfAddedSpace -= this.rebalanceMoveSpaceToEnd();
            }
            ++this.a_nextFreeslot;
            return insertPosOfAddedSpace + 1;
        }
        if (insertPosOfAddedSpace == this.a_firstUsedslot) {
            if (this.a_firstUsedslot == 0) {
                insertPosOfAddedSpace += this.rebalanceMoveSpaceToFront();
            }
            --this.a_firstUsedslot;
            return insertPosOfAddedSpace;
        }
        int distanceFromFront = insertPosOfAddedSpace - this.a_firstUsedslot;
        int distanceFromEnd = this.a_nextFreeslot - insertPosOfAddedSpace;
        boolean bl = useFront = distanceFromFront < distanceFromEnd;
        if (useFront) {
            if (this.a_firstUsedslot == 0) {
                insertPosOfAddedSpace += this.rebalanceMoveSpaceToFront();
            }
            System.arraycopy(this.a, this.a_firstUsedslot, this.a, this.a_firstUsedslot - 1, insertPosOfAddedSpace - this.a_firstUsedslot);
            --this.a_firstUsedslot;
            return insertPosOfAddedSpace;
        }
        if (this.a_nextFreeslot >= this.a.length) {
            insertPosOfAddedSpace -= this.rebalanceMoveSpaceToEnd();
        }
        System.arraycopy(this.a, insertPosOfAddedSpace, this.a, insertPosOfAddedSpace + 1, this.a_nextFreeslot - insertPosOfAddedSpace);
        ++this.a_nextFreeslot;
        return insertPosOfAddedSpace + 1;
    }

    private int rebalanceMoveSpaceToEnd() {
        int amtOfShift = this.a_firstUsedslot + 1 >> 1;
        assert (amtOfShift > 0);
        System.arraycopy(this.a, this.a_firstUsedslot, this.a, this.a_firstUsedslot - amtOfShift, this.size());
        Arrays.fill(this.a, this.a_nextFreeslot - amtOfShift, this.a_nextFreeslot, null);
        this.a_nextFreeslot -= amtOfShift;
        this.a_firstUsedslot -= amtOfShift;
        return amtOfShift;
    }

    private int rebalanceMoveSpaceToFront() {
        int amtOfShift = 1 + this.a.length - this.a_nextFreeslot >> 1;
        assert (amtOfShift > 0);
        System.arraycopy(this.a, this.a_firstUsedslot, this.a, this.a_firstUsedslot + amtOfShift, this.size());
        Arrays.fill(this.a, this.a_firstUsedslot, this.a_firstUsedslot + amtOfShift, null);
        this.a_nextFreeslot += amtOfShift;
        this.a_firstUsedslot += amtOfShift;
        return amtOfShift;
    }

    public int findWithoutID(TOP fs) {
        return this.binarySearch(this.a, this.a_firstUsedslot, this.a_nextFreeslot, fs, this.comparatorNoTypeWithoutID);
    }

    public int find(TOP fs, Comparator<TOP> comparator) {
        return this.binarySearch(this.a, this.a_firstUsedslot, this.a_nextFreeslot, fs, comparator);
    }

    public int binarySearch(TOP[] _a, int start, int end, TOP fs, Comparator<TOP> _comparatorWithID) {
        return Arrays.binarySearch(_a, start, end, fs, _comparatorWithID);
    }

    public boolean remove(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("Null cannot be the argument to remove");
        }
        if (!(o instanceof TOP)) {
            return false;
        }
        TOP fs = (TOP)o;
        int pos = this.binarySearch(this.a, this.a_firstUsedslot, this.a_nextFreeslot, fs, this.comparatorNoTypeWithID);
        if (pos < 0) {
            return false;
        }
        int distanceFromFront = pos - this.a_firstUsedslot;
        int distanceFromEnd = this.a_nextFreeslot - pos;
        if (distanceFromFront < distanceFromEnd) {
            if (distanceFromFront > 0) {
                System.arraycopy(this.a, this.a_firstUsedslot, this.a, this.a_firstUsedslot + 1, distanceFromFront);
            }
            this.a[this.a_firstUsedslot] = null;
            ++this.a_firstUsedslot;
        } else {
            if (distanceFromEnd > 1) {
                System.arraycopy(this.a, pos + 1, this.a, pos, distanceFromEnd - 1);
            }
            --this.a_nextFreeslot;
            this.a[this.a_nextFreeslot] = null;
        }
        return true;
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int len = this.a.length;
        if (this.maxSize < len >> 3 && len > 128) {
            int newSize = len >> 1;
            this.a = new TOP[newSize];
        } else {
            Arrays.fill(this.a, null);
        }
        this.a_firstUsedslot = 0;
        this.a_nextFreeslot = 0;
        this.maxSize = 0;
    }

    public int binarySearchLeftMostEqual(TOP fs, int start, int end, Comparator<TOP> comparator) {
        int pos;
        TOP item;
        int c;
        int lower = start;
        int upper = end;
        do {
            int mid = lower + upper >>> 1;
            item = this.a[mid];
            pos = mid;
        } while (!((c = comparator.compare(item, fs)) == 0 ? (upper = pos) == lower : (lower = pos + 1) == upper));
        return upper;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos;
            {
                this.pos = OrderedFsSet_array.this.a_firstUsedslot;
            }

            @Override
            public boolean hasNext() {
                return this.pos >= 0 && this.pos < OrderedFsSet_array.this.a_nextFreeslot;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return OrderedFsSet_array.this.a[this.pos++];
            }
        };
    }

    public TOP[] toArray() {
        TOP[] r = new TOP[this.size()];
        System.arraycopy(this.a, this.a_firstUsedslot, r, 0, this.size());
        return r;
    }

    public <U> U[] toArray(U[] a1) {
        if (a1.length < this.size()) {
            a1 = (Object[])Array.newInstance(a1.getClass(), this.size());
        }
        System.arraycopy(a1, this.a_firstUsedslot, a1, 0, this.size());
        return a1;
    }

    public T getAtPos(int pos) {
        return (T)this.a[pos];
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrderedFsSet_array [a=");
        if (this.a != null) {
            boolean firstTime = true;
            for (TOP i : this.a) {
                if (firstTime) {
                    firstTime = false;
                } else {
                    b.append(",\n");
                }
                if (i != null) {
                    b.append(i.toShortString());
                    continue;
                }
                b.append("null");
            }
        } else {
            b.append("null");
        }
        b.append(", a_nextFreeslot=").append(this.a_nextFreeslot).append(", a_firstUsedslot=").append(this.a_firstUsedslot).append(", origComparator=").append(this.comparatorNoTypeWithID).append(", maxSize=").append(this.maxSize).append("]");
        return b.toString();
    }

    private static /* synthetic */ void lambda$static$0() {
        int v;
        int i;
        System.out.println("Histogram measures of Ordered Set add / remove operations");
        System.out.format(" - Add to end: %,d,  batch add count: %,d  batch add tot: %,d%n", addToEndCount, batchAddCount, batchAddTotal);
        for (i = 0; i < batchCountHistogram.length; ++i) {
            v = batchCountHistogram[i];
            if (v == 0) continue;
            System.out.format(" batch size: %,d, count: %,d%n", 1 << i, v);
        }
        for (i = 0; i < moveSizeHistogram.length; ++i) {
            v = moveSizeHistogram[i];
            if (v == 0) continue;
            System.out.format(" move size: %,d, count: %,d%n", i == 0 ? 0 : 1 << i - 1, v);
        }
        for (i = 0; i < movePctHistogram.length; ++i) {
            v = movePctHistogram[i];
            if (v == 0) continue;
            System.out.format(" move Pct: %,d - %,d, count: %,d%n", i * 10, (i + 1) * 10, v);
        }
        for (i = 0; i < fillHistogram.length; ++i) {
            v = fillHistogram[i];
            if (v == 0) continue;
            System.out.format(" fill size: %,d, count: %,d%n", i == 0 ? 0 : 1 << i - 1, v);
        }
        for (i = 0; i < iterPctEmptySkip.length; ++i) {
            v = iterPctEmptySkip[i];
            if (v == 0) continue;
            System.out.format(" iterator percent empty needing skip: %,d - %,d, count: %,d%n", i * 10, (i + 1) * 10, v);
        }
    }

    static {
        batchAddCount = 0;
        batchAddTotal = 0;
    }
}

