/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.uniffle.common.netty.IOMode;
import org.apache.uniffle.common.netty.TransportFrameDecoder;
import org.apache.uniffle.common.netty.client.TransportClient;
import org.apache.uniffle.common.netty.client.TransportConf;
import org.apache.uniffle.common.netty.client.TransportContext;
import org.apache.uniffle.common.netty.handle.TransportChannelHandler;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.NettyUtils;
import org.apache.uniffle.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.uniffle.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.uniffle.shaded.io.netty.channel.Channel;
import org.apache.uniffle.shaded.io.netty.channel.ChannelFuture;
import org.apache.uniffle.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.uniffle.shaded.io.netty.channel.ChannelInitializer;
import org.apache.uniffle.shaded.io.netty.channel.ChannelOption;
import org.apache.uniffle.shaded.io.netty.channel.EventLoopGroup;
import org.apache.uniffle.shaded.io.netty.channel.socket.SocketChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClientFactory
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TransportClientFactory.class);
    private final TransportContext context;
    private final TransportConf conf;
    private final ConcurrentHashMap<SocketAddress, ClientPool> connectionPool;
    private final Random rand;
    private final int numConnectionsPerPeer;
    private final Class<? extends Channel> socketChannelClass;
    private EventLoopGroup workerGroup;
    private PooledByteBufAllocator pooledAllocator;

    public TransportClientFactory(TransportContext context) {
        this.context = Objects.requireNonNull(context);
        this.conf = context.getConf();
        this.connectionPool = JavaUtils.newConcurrentMap();
        this.numConnectionsPerPeer = this.conf.numConnectionsPerPeer();
        this.rand = new Random();
        IOMode ioMode = this.conf.ioMode();
        this.socketChannelClass = NettyUtils.getClientChannelClass(ioMode);
        this.workerGroup = NettyUtils.createEventLoop(ioMode, this.conf.clientThreads(), "netty-rpc-client");
        this.pooledAllocator = NettyUtils.createPooledByteBufAllocator(this.conf.preferDirectBufs(), false, this.conf.clientThreads());
    }

    public TransportClient createClient(String remoteHost, int remotePort, int partitionId) throws IOException, InterruptedException {
        return this.createClient(remoteHost, remotePort, partitionId, new TransportFrameDecoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient createClient(String remoteHost, int remotePort, int partitionId, ChannelInboundHandlerAdapter decoder) throws IOException, InterruptedException {
        InetSocketAddress unresolvedAddress = InetSocketAddress.createUnresolved(remoteHost, remotePort);
        ClientPool clientPool = this.connectionPool.computeIfAbsent(unresolvedAddress, x -> new ClientPool(this.numConnectionsPerPeer));
        int clientIndex = partitionId < 0 ? this.rand.nextInt(this.numConnectionsPerPeer) : partitionId % this.numConnectionsPerPeer;
        TransportClient cachedClient = clientPool.clients[clientIndex];
        if (cachedClient != null && cachedClient.isActive()) {
            TransportChannelHandler handler;
            TransportChannelHandler transportChannelHandler = handler = cachedClient.getChannel().pipeline().get(TransportChannelHandler.class);
            synchronized (transportChannelHandler) {
                handler.getResponseHandler().updateTimeOfLastRequest();
            }
            if (cachedClient.isActive()) {
                logger.trace("Returning cached connection to {}: {}", (Object)cachedClient.getSocketAddress(), (Object)cachedClient);
                return cachedClient;
            }
        }
        long preResolveHost = System.nanoTime();
        InetSocketAddress resolvedAddress = new InetSocketAddress(remoteHost, remotePort);
        long hostResolveTimeMs = (System.nanoTime() - preResolveHost) / 1000000L;
        if (hostResolveTimeMs > 2000L) {
            logger.warn("DNS resolution for {} took {} ms", (Object)resolvedAddress, (Object)hostResolveTimeMs);
        } else {
            logger.trace("DNS resolution for {} took {} ms", (Object)resolvedAddress, (Object)hostResolveTimeMs);
        }
        Object object = clientPool.locks[clientIndex];
        synchronized (object) {
            cachedClient = clientPool.clients[clientIndex];
            if (cachedClient != null) {
                if (cachedClient.isActive()) {
                    logger.trace("Returning cached connection to {}: {}", (Object)resolvedAddress, (Object)cachedClient);
                    return cachedClient;
                }
                logger.info("Found inactive connection to {}, creating a new one.", (Object)resolvedAddress);
            }
            clientPool.clients[clientIndex] = this.internalCreateClient(resolvedAddress, decoder);
            return clientPool.clients[clientIndex];
        }
    }

    public TransportClient createClient(String remoteHost, int remotePort) throws IOException, InterruptedException {
        return this.createClient(remoteHost, remotePort, -1);
    }

    private TransportClient internalCreateClient(InetSocketAddress address, final ChannelInboundHandlerAdapter decoder) throws IOException, InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(this.socketChannelClass)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.conf.connectTimeoutMs())).option(ChannelOption.ALLOCATOR, this.pooledAllocator);
        if (this.conf.receiveBuf() > 0) {
            bootstrap.option(ChannelOption.SO_RCVBUF, this.conf.receiveBuf());
        }
        if (this.conf.sendBuf() > 0) {
            bootstrap.option(ChannelOption.SO_SNDBUF, this.conf.sendBuf());
        }
        final AtomicReference clientRef = new AtomicReference();
        final AtomicReference channelRef = new AtomicReference();
        bootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                TransportChannelHandler transportResponseHandler = TransportClientFactory.this.context.initializePipeline(ch, decoder);
                clientRef.set(transportResponseHandler.getClient());
                channelRef.set(ch);
            }
        });
        ChannelFuture cf = bootstrap.connect(address);
        if (!cf.await(this.conf.connectTimeoutMs())) {
            throw new IOException(String.format("Connecting to %s timed out (%s ms)", address, this.conf.connectTimeoutMs()));
        }
        if (cf.cause() != null) {
            throw new IOException(String.format("Failed to connect to %s", address), cf.cause());
        }
        TransportClient client = (TransportClient)clientRef.get();
        assert (client != null) : "Channel future completed successfully with null client";
        if (logger.isDebugEnabled()) {
            logger.debug("Connection to {} successful", (Object)address);
        }
        return client;
    }

    @Override
    public void close() {
        for (ClientPool clientPool : this.connectionPool.values()) {
            for (int i = 0; i < clientPool.clients.length; ++i) {
                TransportClient client = clientPool.clients[i];
                if (client == null) continue;
                clientPool.clients[i] = null;
                JavaUtils.closeQuietly(client);
            }
        }
        this.connectionPool.clear();
        if (this.workerGroup != null && !this.workerGroup.isShuttingDown()) {
            this.workerGroup.shutdownGracefully();
        }
    }

    public TransportContext getContext() {
        return this.context;
    }

    private static class ClientPool {
        TransportClient[] clients;
        Object[] locks;

        ClientPool(int size) {
            this.clients = new TransportClient[size];
            this.locks = new Object[size];
            for (int i = 0; i < size; ++i) {
                this.locks[i] = new Object();
            }
        }
    }
}

