/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hbase.thirdparty.org.jvnet.hk2.internal;

import java.util.HashSet;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ActiveDescriptor;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Filter;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Injectee;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.Operation;
import org.apache.hbase.thirdparty.org.glassfish.hk2.api.ValidationInformation;

public class ValidationInformationImpl
implements ValidationInformation {
    private static final String SERVICE_LOCATOR_IMPL = "org.apache.hbase.thirdparty.org.jvnet.hk2.internal.ServiceLocatorImpl";
    private static final String VALIDATE_METHOD = "validate";
    private static final String CHECK_METHOD = "checkConfiguration";
    private static final String[] SKIP_ME = new String[]{"org.apache.hbase.thirdparty.org.jvnet.hk2.internal", "org.apache.hbase.thirdparty.org.jvnet.hk2.external.generator", "org.apache.hbase.thirdparty.org.glassfish.hk2.extension", "org.apache.hbase.thirdparty.org.glassfish.hk2.api", "org.apache.hbase.thirdparty.org.glassfish.hk2.internal", "org.apache.hbase.thirdparty.org.glassfish.hk2.utilities", "org.apache.hbase.thirdparty.org.glassfish.hk2.utilities.binding", "org.apache.hbase.thirdparty.org.jvnet.hk2.annotations", "org.apache.hbase.thirdparty.org.glassfish.hk2.utilities.cache", "org.apache.hbase.thirdparty.org.glassfish.hk2.utilities.cache.internal", "org.apache.hbase.thirdparty.org.glassfish.hk2.utilities.reflection", "org.apache.hbase.thirdparty.org.jvnet.hk2.component", "java.util.concurrent"};
    private static final HashSet<String> PACKAGES_TO_SKIP = new HashSet();
    private final Operation operation;
    private final ActiveDescriptor<?> candidate;
    private final Injectee injectee;
    private final Filter filter;

    public ValidationInformationImpl(Operation operation, ActiveDescriptor<?> candidate, Injectee injectee, Filter filter) {
        this.operation = operation;
        this.candidate = candidate;
        this.injectee = injectee;
        this.filter = filter;
    }

    public ValidationInformationImpl(Operation operation, ActiveDescriptor<?> candidate) {
        this(operation, candidate, null, null);
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public ActiveDescriptor<?> getCandidate() {
        return this.candidate;
    }

    @Override
    public Injectee getInjectee() {
        return this.injectee;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    private String getPackage(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return name;
        }
        return name.substring(0, index);
    }

    @Override
    public StackTraceElement getCaller() {
        StackTraceElement[] frames = Thread.currentThread().getStackTrace();
        boolean foundValidationCaller = false;
        for (StackTraceElement e : frames) {
            if (!foundValidationCaller) {
                if (!SERVICE_LOCATOR_IMPL.equals(e.getClassName()) || !VALIDATE_METHOD.equals(e.getMethodName()) && !CHECK_METHOD.equals(e.getMethodName())) continue;
                foundValidationCaller = true;
                continue;
            }
            String pack = this.getPackage(e.getClassName());
            if (PACKAGES_TO_SKIP.contains(pack)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        return "ValidationInformation(" + (Object)((Object)this.operation) + "," + this.candidate + "," + this.injectee + "," + this.filter + "," + System.identityHashCode(this) + ")";
    }

    static {
        for (String pack : SKIP_ME) {
            PACKAGES_TO_SKIP.add(pack);
        }
    }
}

