/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.uniffle.common.RemoteStorageInfo;

public class Application
implements Comparable<Application> {
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private String applicationId;
    private String user;
    private String lastHeartBeatTime;
    private String remoteStoragePath;

    public Application() {
    }

    public Application(Builder builder) {
        this.applicationId = builder.applicationId;
        this.user = builder.user;
        this.lastHeartBeatTime = builder.lastHeartBeatTime;
        this.remoteStoragePath = builder.remoteStoragePath;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getUser() {
        return this.user;
    }

    public String getLastHeartBeatTime() {
        return this.lastHeartBeatTime;
    }

    public String getRemoteStoragePath() {
        return this.remoteStoragePath;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setLastHeartBeatTime(String lastHeartBeatTime) {
        this.lastHeartBeatTime = lastHeartBeatTime;
    }

    public void setRemoteStoragePath(String remoteStoragePath) {
        this.remoteStoragePath = remoteStoragePath;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Application)) {
            return false;
        }
        Application otherImpl = (Application)this.getClass().cast(other);
        return new EqualsBuilder().append((Object)this.getApplicationId(), (Object)otherImpl.getApplicationId()).append((Object)this.getUser(), (Object)otherImpl.getUser()).append((Object)this.getLastHeartBeatTime(), (Object)otherImpl.getLastHeartBeatTime()).append((Object)this.getRemoteStoragePath(), (Object)otherImpl.getRemoteStoragePath()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getApplicationId()).append((Object)this.getUser()).append((Object)this.getLastHeartBeatTime()).append((Object)this.getRemoteStoragePath()).toHashCode();
    }

    @Override
    public int compareTo(Application other) {
        return this.applicationId.compareTo(other.applicationId);
    }

    public String toString() {
        return "Application{applicationId='" + this.applicationId + '\'' + ", user='" + this.user + '\'' + ", lastHeartBeatTime='" + this.lastHeartBeatTime + '\'' + ", remoteStoragePath='" + this.remoteStoragePath + '\'' + '}';
    }

    public static class Builder {
        private String applicationId;
        private String user;
        private String lastHeartBeatTime;
        private String remoteStoragePath;

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder lastHeartBeatTime(long lastHeartBeatTime) {
            this.lastHeartBeatTime = DateFormatUtils.format((long)lastHeartBeatTime, (String)Application.DATE_PATTERN);
            return this;
        }

        public Builder remoteStoragePath(RemoteStorageInfo remoteStorageInfo) {
            if (remoteStorageInfo != null) {
                this.remoteStoragePath = remoteStorageInfo.getPath();
            }
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }
}

