/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.AnnotationReader;
import aQute.bnd.component.ComponentDef;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.version.Version;
import aQute.lib.tag.Tag;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

class ReferenceDef {
    Version version = AnnotationReader.V1_0;
    String name;
    String service;
    ReferenceCardinality cardinality;
    ReferencePolicy policy;
    ReferencePolicyOption policyOption;
    String target;
    String bind;
    String unbind;
    String updated;

    ReferenceDef() {
    }

    public void prepare(Analyzer analyzer) throws Exception {
        String error;
        if (this.name == null) {
            analyzer.error("No name for a reference", new Object[0]);
        }
        if (this.updated != null && !this.updated.equals("-") || this.policyOption != null) {
            this.updateVersion(AnnotationReader.V1_2);
        }
        if (this.target != null && (error = Verifier.validateFilter(this.target)) != null) {
            analyzer.error("Invalid target filter %s for %s", this.target, this.name);
        }
        if (this.service == null) {
            analyzer.error("No interface specified on %s", this.name);
        }
    }

    public Tag getTag() {
        Tag ref = new Tag("reference", new Object[0]);
        ref.addAttribute("name", this.name);
        if (this.cardinality != null) {
            ref.addAttribute("cardinality", this.cardinality.toString());
        }
        if (this.policy != null) {
            ref.addAttribute("policy", this.policy.toString());
        }
        ref.addAttribute("interface", this.service);
        if (this.target != null) {
            ref.addAttribute("target", this.target);
        }
        if (this.bind != null && !"-".equals(this.bind)) {
            ref.addAttribute("bind", this.bind);
        }
        if (this.unbind != null && !"-".equals(this.unbind)) {
            ref.addAttribute("unbind", this.unbind);
        }
        if (this.updated != null && !"-".equals(this.updated)) {
            ref.addAttribute("updated", this.updated);
        }
        if (this.policyOption != null) {
            ref.addAttribute("policy-option", this.policyOption.toString());
        }
        return ref;
    }

    public String toString() {
        return this.name;
    }

    void updateVersion(Version version) {
        this.version = ComponentDef.max(this.version, version);
    }
}

