/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStage;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.elasticsearch.action.support.broadcast.BroadcastShardResponse;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;

public class SnapshotIndexShardStatus
extends BroadcastShardResponse
implements ToXContentFragment {
    private SnapshotIndexShardStage stage = SnapshotIndexShardStage.INIT;
    private SnapshotStats stats;
    private String nodeId;
    private String failure;
    static final ObjectParser.NamedObjectParser<SnapshotIndexShardStatus, String> PARSER;

    public SnapshotIndexShardStatus(StreamInput in) throws IOException {
        super(in);
        this.stage = SnapshotIndexShardStage.fromValue(in.readByte());
        this.stats = new SnapshotStats(in);
        this.nodeId = in.readOptionalString();
        this.failure = in.readOptionalString();
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage) {
        super(shardId);
        this.stage = stage;
        this.stats = new SnapshotStats();
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus.Copy indexShardStatus) {
        this(shardId, indexShardStatus, null);
    }

    SnapshotIndexShardStatus(ShardId shardId, IndexShardSnapshotStatus.Copy indexShardStatus, String nodeId) {
        super(shardId);
        switch (indexShardStatus.getStage()) {
            case INIT: {
                this.stage = SnapshotIndexShardStage.INIT;
                break;
            }
            case STARTED: {
                this.stage = SnapshotIndexShardStage.STARTED;
                break;
            }
            case FINALIZE: {
                this.stage = SnapshotIndexShardStage.FINALIZE;
                break;
            }
            case DONE: {
                this.stage = SnapshotIndexShardStage.DONE;
                break;
            }
            case FAILURE: {
                this.stage = SnapshotIndexShardStage.FAILURE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown stage type " + (Object)((Object)indexShardStatus.getStage()));
            }
        }
        this.stats = new SnapshotStats(indexShardStatus.getStartTime(), indexShardStatus.getTotalTime(), indexShardStatus.getIncrementalFileCount(), indexShardStatus.getTotalFileCount(), indexShardStatus.getProcessedFileCount(), indexShardStatus.getIncrementalSize(), indexShardStatus.getTotalSize(), indexShardStatus.getProcessedSize());
        this.failure = indexShardStatus.getFailure();
        this.nodeId = nodeId;
    }

    SnapshotIndexShardStatus(ShardId shardId, SnapshotIndexShardStage stage, SnapshotStats stats, String nodeId, String failure) {
        super(shardId);
        this.stage = stage;
        this.stats = stats;
        this.nodeId = nodeId;
        this.failure = failure;
    }

    public SnapshotIndexShardStage getStage() {
        return this.stage;
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getFailure() {
        return this.failure;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.stage.value());
        this.stats.writeTo(out);
        out.writeOptionalString(this.nodeId);
        out.writeOptionalString(this.failure);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Integer.toString(this.getShardId().getId()));
        builder.field("stage", (Object)this.getStage());
        builder.field("stats", this.stats, params);
        if (this.getNodeId() != null) {
            builder.field("node", this.getNodeId());
        }
        if (this.getFailure() != null) {
            builder.field("reason", this.getFailure());
        }
        builder.endObject();
        return builder;
    }

    public static SnapshotIndexShardStatus fromXContent(XContentParser parser, String indexId) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser::getTokenLocation);
        return PARSER.parse(parser, indexId, parser.currentName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotIndexShardStatus that = (SnapshotIndexShardStatus)o;
        if (this.stage != that.stage) {
            return false;
        }
        if (this.stats != null ? !this.stats.equals(that.stats) : that.stats != null) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
            return false;
        }
        return this.failure != null ? this.failure.equals(that.failure) : that.failure == null;
    }

    public int hashCode() {
        int result = this.stage != null ? this.stage.hashCode() : 0;
        result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.failure != null ? this.failure.hashCode() : 0);
        return result;
    }

    static {
        ConstructingObjectParser<SnapshotIndexShardStatus, ShardId> innerParser = new ConstructingObjectParser<SnapshotIndexShardStatus, ShardId>("snapshot_index_shard_status", true, (parsedObjects, shard) -> {
            SnapshotIndexShardStage stage;
            int i = 0;
            String rawStage = (String)parsedObjects[i++];
            String nodeId = (String)parsedObjects[i++];
            String failure = (String)parsedObjects[i++];
            SnapshotStats stats = (SnapshotStats)parsedObjects[i];
            try {
                stage = SnapshotIndexShardStage.valueOf(rawStage);
            }
            catch (IllegalArgumentException iae) {
                throw new ElasticsearchParseException("failed to parse snapshot index shard status [{}][{}], unknown stage [{}]", shard.getIndex().getName(), shard.getId(), rawStage);
            }
            return new SnapshotIndexShardStatus((ShardId)shard, stage, stats, nodeId, failure);
        });
        innerParser.declareString(ConstructingObjectParser.constructorArg(), new ParseField("stage", new String[0]));
        innerParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("node", new String[0]));
        innerParser.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("reason", new String[0]));
        innerParser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SnapshotStats.fromXContent(p), new ParseField("stats", new String[0]));
        PARSER = (p, indexId, shardName) -> {
            int shard;
            try {
                shard = Integer.parseInt(shardName);
            }
            catch (NumberFormatException nfe) {
                throw new ElasticsearchParseException("failed to parse snapshot index shard status [{}], expected numeric shard id but got [{}]", indexId, shardName);
            }
            ShardId shardId = new ShardId(new Index((String)indexId, "_na_"), shard);
            return (SnapshotIndexShardStatus)innerParser.parse(p, shardId);
        };
    }

    static final class Fields {
        static final String STAGE = "stage";
        static final String REASON = "reason";
        static final String NODE = "node";

        Fields() {
        }
    }
}

