/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import nonapi.io.github.classgraph.utils.LogNode;

public abstract class SingletonMap<K, V> {
    private final ConcurrentMap<K, SingletonHolder<V>> map = new ConcurrentHashMap<K, SingletonHolder<V>>();

    public abstract V newInstance(K var1, LogNode var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key, LogNode log) throws Exception {
        SingletonHolder singletonHolder = (SingletonHolder)this.map.get(key);
        Object instance = null;
        if (singletonHolder != null) {
            instance = singletonHolder.get();
        } else {
            SingletonHolder<Object> newSingletonHolder = new SingletonHolder<Object>();
            SingletonHolder oldSingletonHolder = this.map.putIfAbsent(key, newSingletonHolder);
            if (oldSingletonHolder != null) {
                instance = oldSingletonHolder.get();
            } else {
                try {
                    instance = this.newInstance(key, log);
                    if (instance == null) {
                        if (log != null) {
                            log.log("newInstance returned null for key " + key);
                        }
                        throw new IllegalArgumentException("newInstance returned null for key " + key);
                    }
                }
                finally {
                    newSingletonHolder.set(instance);
                }
            }
        }
        if (instance == null) {
            throw new IllegalArgumentException("instance was null for key " + key);
        }
        return instance;
    }

    public V getIfPresent(K key) throws InterruptedException {
        SingletonHolder singletonHolder = (SingletonHolder)this.map.get(key);
        return singletonHolder == null ? null : (V)singletonHolder.get();
    }

    public List<V> values() throws InterruptedException {
        ArrayList entries = new ArrayList(this.map.size());
        for (Map.Entry ent : this.map.entrySet()) {
            Object entryValue = ((SingletonHolder)ent.getValue()).get();
            if (entryValue == null) continue;
            entries.add(entryValue);
        }
        return entries;
    }

    public void clear() {
        this.map.clear();
    }

    private static class SingletonHolder<V> {
        private V singleton;
        private final CountDownLatch initialized = new CountDownLatch(1);

        private SingletonHolder() {
        }

        void set(V singleton) {
            this.singleton = singleton;
            this.initialized.countDown();
        }

        V get() throws InterruptedException {
            this.initialized.await();
            return this.singleton;
        }
    }
}

