/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.reflection;

import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.codehaus.groovy.reflection.AccessPermissionChecker;
import org.codehaus.groovy.reflection.ReflectionUtils;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class CachedField
extends MetaProperty {
    private final Field cachedField;
    private boolean makeAccessibleDone = false;

    public CachedField(Field field) {
        super(field.getName(), field.getType());
        this.cachedField = field;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    @Override
    public int getModifiers() {
        return this.cachedField.getModifiers();
    }

    @Override
    public Object getProperty(Object object) {
        this.makeAccessibleIfNecessary();
        AccessPermissionChecker.checkAccessPermission(this.cachedField);
        try {
            return this.cachedField.get(object);
        }
        catch (IllegalAccessException e) {
            throw new GroovyRuntimeException("Cannot get the property '" + this.name + "'.", e);
        }
    }

    @Override
    public void setProperty(Object object, Object newValue) {
        this.makeAccessibleIfNecessary();
        AccessPermissionChecker.checkAccessPermission(this.cachedField);
        Object goalValue = DefaultTypeTransformation.castToType(newValue, this.cachedField.getType());
        if (this.isFinal()) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "' because the backing field is final.");
        }
        try {
            this.cachedField.set(object, goalValue);
        }
        catch (IllegalAccessException ex) {
            throw new GroovyRuntimeException("Cannot set the property '" + this.name + "'.", ex);
        }
    }

    public Class getDeclaringClass() {
        return this.cachedField.getDeclaringClass();
    }

    public Field getCachedField() {
        this.makeAccessibleIfNecessary();
        AccessPermissionChecker.checkAccessPermission(this.cachedField);
        return this.cachedField;
    }

    private void makeAccessibleIfNecessary() {
        if (!this.makeAccessibleDone) {
            ReflectionUtils.makeAccessibleInPrivilegedAction(this.cachedField);
            this.makeAccessibleDone = true;
        }
    }
}

